/*
 * Decompiled with CFR 0.152.
 */
package tehnut.harvest;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@JsonAdapter(value=Adapter.class)
public class Crop
implements Predicate<BlockState> {
    private final BlockState mature;
    private Block block;

    public Crop(BlockState mature) {
        this.mature = mature;
    }

    public BlockState getMature() {
        return this.mature;
    }

    public Block getBlock() {
        return this.block == null ? (this.block = this.mature.func_177230_c()) : this.block;
    }

    @Override
    public boolean test(BlockState state) {
        return state == this.mature;
    }

    public String toString() {
        return "Crop{" + this.mature.toString() + "}";
    }

    public static class Adapter
    implements JsonSerializer<Crop>,
    JsonDeserializer<Crop> {
        public Crop deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = element.getAsJsonObject();
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(json.getAsJsonPrimitive("block").getAsString()));
            BlockState state = block.func_176223_P();
            JsonObject stateObject = json.getAsJsonObject("states");
            for (Map.Entry e : stateObject.entrySet()) {
                IProperty property = block.func_176194_O().func_185920_a((String)e.getKey());
                if (property == null) continue;
                String valueString = ((JsonElement)e.getValue()).getAsString();
                Comparable value = (Comparable)property.func_185929_b(valueString).get();
                state = (BlockState)state.func_206870_a(property, value);
            }
            return new Crop(state);
        }

        public JsonElement serialize(Crop src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.addProperty("block", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)src.getBlock()).toString());
            String stateString = src.mature.toString();
            String[] properties = stateString.substring(stateString.indexOf("[") + 1, stateString.length() - 1).split(",");
            JsonObject states = new JsonObject();
            for (String property : properties) {
                String[] split = property.split("=");
                states.addProperty(split[0], split[1]);
            }
            object.add("states", (JsonElement)states);
            return object;
        }
    }
}

