/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.capabilities;

import com.lothrazar.storagenetwork.api.capability.IConnectable;
import com.lothrazar.storagenetwork.api.capability.IConnectableLink;
import com.lothrazar.storagenetwork.api.data.DimPos;
import com.lothrazar.storagenetwork.api.data.EnumStorageDirection;
import com.lothrazar.storagenetwork.api.data.IItemStackMatcher;
import com.lothrazar.storagenetwork.capabilities.CapabilityConnectable;
import com.lothrazar.storagenetwork.capabilities.StorageNetworkCapabilities;
import com.lothrazar.storagenetwork.gui.inventory.FilterItemStackHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CapabilityConnectableLink
implements IConnectableLink,
INBTSerializable<CompoundNBT> {
    public final IConnectable connectable;
    private boolean operationMustBeSmaller = true;
    private ItemStack operationStack = ItemStack.field_190927_a;
    private int operationLimit = 0;
    private FilterItemStackHandler filters = new FilterItemStackHandler();
    private EnumStorageDirection filterDirection = EnumStorageDirection.BOTH;
    private Direction inventoryFace;
    private int priority;

    CapabilityConnectableLink() {
        this.connectable = new CapabilityConnectable();
        this.filters.setIsWhitelist(false);
    }

    public CapabilityConnectableLink(TileEntity tile) {
        this.connectable = (IConnectable)tile.getCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY, null).orElse(null);
        this.filters.setIsWhitelist(false);
    }

    public FilterItemStackHandler getFilter() {
        return this.filters;
    }

    @Override
    public void setFilter(int value, ItemStack stack) {
        this.filters.setStackInSlot(value, stack);
        this.filters.getStacks().set(value, stack);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public List<ItemStack> getStoredStacks() {
        if (this.inventoryFace == null) {
            return Collections.EMPTY_LIST;
        }
        DimPos inventoryPos = this.connectable.getPos().offset(this.inventoryFace);
        IItemHandler itemHandler = (IItemHandler)inventoryPos.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.inventoryFace.func_176734_d());
        if (itemHandler == null) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stack = itemHandler.getStackInSlot(slot);
            if (stack == null || stack.func_190926_b() || this.filters.isStackFiltered(stack)) continue;
            result.add(stack.func_77946_l());
        }
        return result;
    }

    @Override
    public ItemStack insertStack(ItemStack stack, boolean simulate) {
        if (this.filterDirection == EnumStorageDirection.IN) {
            return stack;
        }
        if (this.filters.isStackFiltered(stack)) {
            return stack;
        }
        if (this.inventoryFace == null) {
            return stack;
        }
        DimPos inventoryPos = this.connectable.getPos().offset(this.inventoryFace);
        IItemHandler itemHandler = (IItemHandler)inventoryPos.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.inventoryFace.func_176734_d());
        if (itemHandler == null) {
            return stack;
        }
        return ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)stack, (boolean)simulate);
    }

    @Override
    public ItemStack extractStack(IItemStackMatcher matcher, int size, boolean simulate) {
        if (size <= 0) {
            return ItemStack.field_190927_a;
        }
        if (this.filterDirection == EnumStorageDirection.IN) {
            return ItemStack.field_190927_a;
        }
        if (this.inventoryFace == null) {
            return ItemStack.field_190927_a;
        }
        DimPos inventoryPos = this.connectable.getPos().offset(this.inventoryFace);
        IItemHandler itemHandler = (IItemHandler)inventoryPos.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.inventoryFace.func_176734_d());
        if (itemHandler == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack firstMatchedStack = ItemStack.field_190927_a;
        int remaining = size;
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stack = itemHandler.extractItem(slot, remaining, true);
            if (stack == null || stack.func_190926_b() || this.filters.isStackFiltered(stack)) continue;
            if (firstMatchedStack.func_190926_b()) {
                if (!matcher.match(stack)) continue;
                firstMatchedStack = stack.func_77946_l();
            } else if (!ItemHandlerHelper.canItemStacksStack((ItemStack)firstMatchedStack, (ItemStack)stack)) continue;
            int toExtract = Math.min(stack.func_190916_E(), remaining);
            ItemStack extractedStack = itemHandler.extractItem(slot, toExtract, simulate);
            if ((remaining -= extractedStack.func_190916_E()) <= 0) break;
        }
        int extractCount = size - remaining;
        if (!firstMatchedStack.func_190926_b() && extractCount > 0) {
            firstMatchedStack.func_190920_e(extractCount);
        }
        return firstMatchedStack;
    }

    @Override
    public int getEmptySlots() {
        if (this.filterDirection == EnumStorageDirection.IN) {
            return 0;
        }
        if (this.inventoryFace == null) {
            return 0;
        }
        DimPos inventoryPos = this.connectable.getPos().offset(this.inventoryFace);
        IItemHandler itemHandler = (IItemHandler)inventoryPos.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.inventoryFace.func_176734_d());
        if (itemHandler == null) {
            return 0;
        }
        int emptySlots = 0;
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stack = itemHandler.getStackInSlot(slot);
            if (stack != null && !stack.func_190926_b()) continue;
            ++emptySlots;
        }
        return emptySlots;
    }

    @Override
    public void setPriority(int value) {
        this.priority = value;
    }

    @Override
    public EnumStorageDirection getSupportedTransferDirection() {
        return this.filterDirection;
    }

    public void setInventoryFace(Direction inventoryFace) {
        this.inventoryFace = inventoryFace;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT result = new CompoundNBT();
        result.func_74768_a("prio", this.priority);
        if (this.inventoryFace != null) {
            result.func_74778_a("inventoryFace", this.inventoryFace.toString());
        }
        result.func_74778_a("way", this.filterDirection.toString());
        CompoundNBT operation = new CompoundNBT();
        operation.func_218657_a("stack", (INBT)this.operationStack.serializeNBT());
        operation.func_74757_a("mustBeSmaller", this.operationMustBeSmaller);
        operation.func_74768_a("limit", this.operationLimit);
        result.func_218657_a("operation", (INBT)operation);
        CompoundNBT filters = this.filters.serializeNBT();
        result.func_218657_a("filters", (INBT)filters);
        return result;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.priority = nbt.func_74762_e("prio");
        CompoundNBT filters = nbt.func_74775_l("filters");
        this.filters.deserializeNBT(filters);
        if (nbt.func_74764_b("inventoryFace")) {
            this.inventoryFace = Direction.func_176739_a((String)nbt.func_74779_i("inventoryFace"));
        }
        try {
            this.filterDirection = EnumStorageDirection.valueOf(nbt.func_74779_i("way"));
        }
        catch (Exception e) {
            this.filterDirection = EnumStorageDirection.BOTH;
        }
        CompoundNBT operation = nbt.func_74775_l("operation");
        this.operationStack = ItemStack.field_190927_a;
        if (operation != null) {
            this.operationLimit = operation.func_74762_e("limit");
            this.operationMustBeSmaller = operation.func_74767_n("mustBeSmaller");
            if (operation.func_150297_b("stack", 10)) {
                this.operationStack = ItemStack.func_199557_a((CompoundNBT)operation.func_74775_l("stack"));
            }
        }
    }

    public static class Storage
    implements Capability.IStorage<IConnectableLink> {
        @Nullable
        public INBT writeNBT(Capability<IConnectableLink> capability, IConnectableLink rawInstance, Direction side) {
            CapabilityConnectableLink instance = (CapabilityConnectableLink)rawInstance;
            return instance.serializeNBT();
        }

        public void readNBT(Capability<IConnectableLink> capability, IConnectableLink rawInstance, Direction side, INBT nbt) {
            CapabilityConnectableLink instance = (CapabilityConnectableLink)rawInstance;
            instance.deserializeNBT((CompoundNBT)nbt);
        }
    }

    public static class Factory
    implements Callable<IConnectableLink> {
        @Override
        public IConnectableLink call() throws Exception {
            return new CapabilityConnectableLink();
        }
    }
}

