/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.cos.impl.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import lain.mods.cos.impl.ModObjects;
import lain.mods.cos.impl.client.Hacks;
import lain.mods.cos.impl.inventory.InventoryCosArmor;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.server.SDisconnectPacket;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.Pair;

public enum PlayerRenderHandler {
    INSTANCE;

    public static boolean Disabled;
    private static final int MAXSIZE = 11;
    private LoadingCache<Object, Pair<NonNullList<ItemStack>, MutableInt>> cache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<Object, Pair<NonNullList<ItemStack>, MutableInt>>(){

        public Pair<NonNullList<ItemStack>, MutableInt> load(Object key) throws Exception {
            return Pair.of((Object)NonNullList.func_191197_a((int)11, (Object)ItemStack.field_190927_a), (Object)new MutableInt());
        }
    });

    private static void disconnect(ITextComponent message) {
        Minecraft mc = (Minecraft)LogicalSidedProvider.INSTANCE.get(LogicalSide.CLIENT);
        mc.func_147114_u().func_147253_a(new SDisconnectPacket(message));
        mc.func_147114_u().func_147231_a(message);
    }

    private void handlePostRenderPlayer_High(RenderPlayerEvent.Post event) {
        try {
            PlayerEntity player = event.getEntityPlayer();
            Pair cached = (Pair)this.cache.getUnchecked((Object)player);
            NonNullList armorCached = (NonNullList)cached.getLeft();
            NonNullList armor = player.field_71071_by.field_70460_b;
            if (((MutableInt)cached.getRight()).intValue() != 0) {
                for (int i = 0; i < armor.size(); ++i) {
                    armor.set(i, armorCached.get(i));
                }
                ((MutableInt)cached.getRight()).setValue(0);
            }
        }
        catch (Throwable t) {
            PlayerRenderHandler.disconnect((ITextComponent)new StringTextComponent("Something went wrong during restoration after player rendering, it should be fine to reconnect."));
        }
    }

    private void handlePreRenderPlayer_High(RenderPlayerEvent.Pre event) {
        try {
            int i;
            PlayerEntity player = event.getEntityPlayer();
            Pair cached = (Pair)this.cache.getUnchecked((Object)player);
            NonNullList armorCached = (NonNullList)cached.getLeft();
            NonNullList armor = player.field_71071_by.field_70460_b;
            if (((MutableInt)cached.getRight()).intValue() != 0) {
                for (i = 0; i < armor.size(); ++i) {
                    armor.set(i, armorCached.get(i));
                }
                ((MutableInt)cached.getRight()).setValue(0);
            }
            for (i = 0; i < armor.size(); ++i) {
                armorCached.set(i, armor.get(i));
            }
            ((MutableInt)cached.getRight()).setValue(1);
            if (Disabled) {
                return;
            }
            InventoryCosArmor invCosArmor = ModObjects.invMan.getCosArmorInventoryClient(player.func_110124_au());
            for (int i2 = 0; i2 < armor.size(); ++i2) {
                if (invCosArmor.isSkinArmor(i2)) {
                    armor.set(i2, (Object)ItemStack.field_190927_a);
                    continue;
                }
                ItemStack stack = invCosArmor.func_70301_a(i2);
                if (stack.func_190926_b()) continue;
                armor.set(i2, (Object)stack);
            }
        }
        catch (Throwable t) {
            PlayerRenderHandler.disconnect((ITextComponent)new StringTextComponent("Something went wrong during preparation for player rendering, it should be fine to reconnect."));
        }
    }

    private void handlePreRenderPlayer_LowestCanceled(RenderPlayerEvent.Pre event) {
        if (!event.isCanceled()) {
            return;
        }
        try {
            PlayerEntity player = event.getEntityPlayer();
            Pair cached = (Pair)this.cache.getUnchecked((Object)player);
            NonNullList armorCached = (NonNullList)cached.getLeft();
            NonNullList armor = player.field_71071_by.field_70460_b;
            if (((MutableInt)cached.getRight()).intValue() != 0) {
                for (int i = 0; i < armor.size(); ++i) {
                    armor.set(i, armorCached.get(i));
                }
                ((MutableInt)cached.getRight()).setValue(0);
            }
        }
        catch (Throwable t) {
            PlayerRenderHandler.disconnect((ITextComponent)new StringTextComponent("Something went wrong during restoration for canceled player rendering, it should be fine to reconnect."));
        }
    }

    public void registerEvents() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, this::handlePostRenderPlayer_High);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, this::handlePreRenderPlayer_High);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, true, this::handlePreRenderPlayer_LowestCanceled);
        Hacks.addClientDisconnectionCallback(() -> {
            Disabled = false;
        });
    }

    static {
        Disabled = false;
    }
}

