/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.gui.GuiParser;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemStackTools {
    @Nonnull
    public static ItemStack extractItem(@Nullable TileEntity tileEntity, int slot, int amount) {
        if (tileEntity == null) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(handler -> handler.extractItem(slot, amount, false)).orElse((Object)ItemStack.field_190927_a);
    }

    @Nonnull
    public static ItemStack getStack(@Nullable TileEntity tileEntity, int slot) {
        if (tileEntity == null) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(handler -> handler.getStackInSlot(slot)).orElse((Object)ItemStack.field_190927_a);
    }

    public static void setStack(@Nullable TileEntity tileEntity, int slot, @Nonnull ItemStack stack) {
        if (tileEntity == null) {
            return;
        }
        tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
            handler.extractItem(slot, 64, false);
            handler.insertItem(slot, stack, false);
        });
    }

    public static List<ItemStack> getOres(String name) {
        return Collections.emptyList();
    }

    public static List<ItemStack> getOres(String name, boolean alwaysCreateEntry) {
        return Collections.emptyList();
    }

    @Nonnull
    public static Optional<CompoundNBT> getTag(@Nonnull ItemStack stack) {
        return Optional.ofNullable(stack.func_77978_p());
    }

    @Nonnull
    public static <R> R mapTag(@Nonnull ItemStack stack, Function<CompoundNBT, R> mapping, @Nonnull R def) {
        if (stack.func_77942_o()) {
            return mapping.apply(stack.func_77978_p());
        }
        return def;
    }

    @Nonnull
    public static Function<ItemStack, String> intGetter(String tag, Integer def) {
        return stack -> Integer.toString(ItemStackTools.mapTag(stack, nbt -> nbt.func_74762_e(tag), def));
    }

    @Nonnull
    public static Function<ItemStack, String> strGetter(String tag, String def) {
        return stack -> ItemStackTools.mapTag(stack, nbt -> nbt.func_74779_i(tag), def);
    }

    @Nonnull
    public static Stream<INBT> getListStream(CompoundNBT compound, String tag) {
        ListNBT list = compound.func_150295_c("Items", 10);
        return StreamSupport.stream(list.spliterator(), false);
    }

    public static JsonObject itemStackToJson(ItemStack item) {
        JsonObject object = new JsonObject();
        object.add("item", (JsonElement)new JsonPrimitive(item.func_77973_b().getRegistryName().toString()));
        if (item.func_190916_E() != 1) {
            object.add("amount", (JsonElement)new JsonPrimitive((Number)item.func_190916_E()));
        }
        if (item.func_77942_o()) {
            String string = item.func_77978_p().toString();
            object.add("nbt", (JsonElement)new JsonPrimitive(string));
        }
        return object;
    }

    public static ItemStack jsonToItemStack(JsonObject obj) {
        String itemName = obj.get("item").getAsString();
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
        int amount = 1;
        if (obj.has("amount")) {
            amount = obj.get("amount").getAsInt();
        }
        ItemStack stack = new ItemStack((IItemProvider)item, amount);
        if (obj.has("nbt")) {
            try {
                CompoundNBT nbt = JsonToNBT.func_180713_a((String)obj.get("nbt").getAsString());
                stack.func_77982_d(nbt);
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
        }
        return stack;
    }

    public static GuiParser.GuiCommand itemStackToGuiCommand(String name, ItemStack item) {
        GuiParser.GuiCommand object = new GuiParser.GuiCommand(name);
        object.parameter(item.func_77973_b().getRegistryName().toString());
        object.parameter(item.func_190916_E());
        if (item.func_77942_o()) {
            String string = item.func_77978_p().toString();
            object.command(new GuiParser.GuiCommand("tag").parameter(string));
        }
        return object;
    }

    public static ItemStack guiCommandToItemStack(GuiParser.GuiCommand obj) {
        String itemName = obj.getOptionalPar(0, "minecraft:stick");
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
        int amount = obj.getOptionalPar(1, 1);
        ItemStack stack = new ItemStack((IItemProvider)item, amount);
        obj.findCommand("tag").ifPresent(cmd -> {
            try {
                CompoundNBT nbt = JsonToNBT.func_180713_a((String)cmd.getOptionalPar(0, ""));
                stack.func_77982_d(nbt);
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
        });
        return stack;
    }
}

