/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidTools {
    @Nonnull
    public static ItemStack convertFluidToBucket(@Nonnull FluidStack fluidStack) {
        return (ItemStack)FluidUtil.getFluidHandler((ItemStack)new ItemStack((IItemProvider)Items.field_151133_ar)).map(handler -> {
            handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            return handler.getContainer();
        }).orElse((Object)ItemStack.field_190927_a);
    }

    @Nullable
    public static FluidStack convertBucketToFluid(@Nonnull ItemStack bucket) {
        return (FluidStack)FluidUtil.getFluidHandler((ItemStack)bucket).map(handler -> {
            for (int i = 0; i < handler.getTanks(); ++i) {
                FluidStack contents = handler.getFluidInTank(i);
                if (contents.isEmpty()) continue;
                return contents;
            }
            return null;
        }).orElse(null);
    }

    public static boolean isEmptyContainer(@Nonnull ItemStack itemStack) {
        return (Boolean)FluidUtil.getFluidHandler((ItemStack)itemStack).map(handler -> {
            for (int i = 0; i < handler.getTanks(); ++i) {
                if (handler.getTankCapacity(i) <= 0) continue;
                FluidStack contents = handler.getFluidInTank(i);
                if (contents.isEmpty()) {
                    return true;
                }
                if (contents.getAmount() <= 0) continue;
                return false;
            }
            return false;
        }).orElse((Object)false);
    }

    public static boolean isFilledContainer(@Nonnull ItemStack itemStack) {
        return (Boolean)FluidUtil.getFluidHandler((ItemStack)itemStack).map(handler -> {
            for (int i = 0; i < handler.getTanks(); ++i) {
                FluidStack contents = handler.getFluidInTank(i);
                if (!contents.isEmpty() && contents.getAmount() >= handler.getTankCapacity(i)) continue;
                return false;
            }
            return true;
        }).orElse((Object)false);
    }

    @Nonnull
    public static ItemStack drainContainer(@Nonnull ItemStack container) {
        ItemStack empty = container.func_77946_l();
        empty.func_190920_e(1);
        return (ItemStack)FluidUtil.getFluidHandler((ItemStack)empty).map(handler -> {
            if (!handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE).isEmpty()) {
                return handler.getContainer();
            }
            return ItemStack.field_190927_a;
        }).orElse((Object)ItemStack.field_190927_a);
    }

    @Nonnull
    public static ItemStack fillContainer(@Nonnull FluidStack fluidStack, @Nonnull ItemStack itemStack) {
        return (ItemStack)FluidUtil.getFluidHandler((ItemStack)itemStack.func_77946_l()).map(handler -> {
            int filled = handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            if (filled == 0) {
                return ItemStack.field_190927_a;
            }
            return handler.getContainer();
        }).orElse((Object)ItemStack.field_190927_a);
    }
}

