/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.setup;

import mcjty.lib.McJtyLib;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.information.CapabilityPowerInformation;
import mcjty.lib.api.infusable.CapabilityInfusable;
import mcjty.lib.api.module.CapabilityModuleSupport;
import mcjty.lib.multipart.MultipartBlock;
import mcjty.lib.multipart.MultipartHelper;
import mcjty.lib.multipart.MultipartTE;
import mcjty.lib.network.PacketHandler;
import mcjty.lib.preferences.PreferencesDispatcher;
import mcjty.lib.preferences.PreferencesProperties;
import mcjty.lib.setup.DefaultModSetup;
import mcjty.lib.varia.WrenchChecker;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.network.NetworkRegistry;

public class ModSetup
extends DefaultModSetup {
    public static ResourceLocation PREFERENCES_CAPABILITY_KEY = new ResourceLocation("mcjtylib", "preferences");
    @CapabilityInject(value=PreferencesProperties.class)
    public static Capability<PreferencesProperties> PREFERENCES_CAPABILITY;

    private static void registerCapabilities() {
        CapabilityContainerProvider.register();
        CapabilityInfusable.register();
        CapabilityPowerInformation.register();
        CapabilityModuleSupport.register();
        PreferencesProperties.register();
    }

    @Override
    public void init(FMLCommonSetupEvent e) {
        super.init(e);
        ModSetup.registerCapabilities();
        McJtyLib.networkHandler = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("mcjtylib", "mcjtylib"), () -> "1.0", s -> true, s -> true);
        PacketHandler.registerMessages(McJtyLib.networkHandler);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        McJtyLib.tesla = ModList.get().isLoaded("tesla");
        McJtyLib.cofhapiitem = ModList.get().isLoaded("cofhapi|item");
    }

    @Override
    protected void setupModCompat() {
        WrenchChecker.init();
    }

    public static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
            if (event.phase == TickEvent.Phase.START && !event.player.func_130014_f_().field_72995_K) {
                McJtyLib.getPreferencesProperties(event.player).ifPresent(handler -> handler.tick((ServerPlayerEntity)event.player));
            }
        }

        @SubscribeEvent
        public void onEntityConstructing(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof PlayerEntity) {
                if (!event.getCapabilities().containsKey(PREFERENCES_CAPABILITY_KEY) && !((Entity)event.getObject()).getCapability(PREFERENCES_CAPABILITY).isPresent()) {
                    event.addCapability(PREFERENCES_CAPABILITY_KEY, (ICapabilityProvider)new PreferencesDispatcher());
                } else {
                    throw new IllegalStateException(((Entity)event.getObject()).toString());
                }
            }
        }

        @SubscribeEvent
        public void onPlayerInteract(PlayerInteractEvent.LeftClickBlock event) {
            BlockPos pos;
            World world = event.getWorld();
            BlockState state = world.func_180495_p(pos = event.getPos());
            if (state.func_177230_c() instanceof MultipartBlock) {
                TileEntity tileEntity = world.func_175625_s(pos);
                if (tileEntity instanceof MultipartTE && !world.field_72995_K) {
                    Vec3d hitVec;
                    PlayerEntity player = event.getEntityPlayer();
                    Vec3d start = player.func_174824_e(1.0f);
                    Vec3d vec31 = player.func_70676_i(1.0f);
                    float dist = 20.0f;
                    Vec3d end = start.func_72441_c(vec31.field_72450_a * (double)dist, vec31.field_72448_b * (double)dist, vec31.field_72449_c * (double)dist);
                    RayTraceContext context = new RayTraceContext(start, end, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)player);
                    BlockRayTraceResult result = player.func_130014_f_().func_217299_a(context);
                    Vec3d vec3d = hitVec = result == null ? null : result.func_216347_e();
                    if (MultipartHelper.removePart((MultipartTE)tileEntity, state, player, hitVec)) {
                        world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                    }
                }
                event.setCanceled(true);
            }
        }
    }
}

