/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.lib.McJtyLib;
import mcjty.lib.network.NetworkTools;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSetGuiStyle {
    private String style;

    public PacketSetGuiStyle(ByteBuf buf) {
        this.style = NetworkTools.readString(buf);
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writeString(buf, this.style);
    }

    public PacketSetGuiStyle(String style) {
        this.style = style;
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> PacketSetGuiStyle.handle(this, (NetworkEvent.Context)ctx.get()));
        ctx.get().setPacketHandled(true);
    }

    private static void handle(PacketSetGuiStyle message, NetworkEvent.Context ctx) {
        ServerPlayerEntity playerEntity = ctx.getSender();
        McJtyLib.getPreferencesProperties((PlayerEntity)playerEntity).ifPresent(p -> p.setStyle(message.style));
    }
}

