/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.lib.network.ICommandHandler;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.PacketDataFromServer;
import mcjty.lib.network.PacketHandler;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class PacketRequestDataFromServer {
    protected BlockPos pos;
    protected String command;
    protected TypedMap params;
    private String modid;

    public PacketRequestDataFromServer(PacketBuffer buf) {
        this.pos = NetworkTools.readPos((ByteBuf)buf);
        this.command = NetworkTools.readString((ByteBuf)buf);
        this.params = TypedMapTools.readArguments(buf);
        this.modid = NetworkTools.readString((ByteBuf)buf);
    }

    public void toBytes(PacketBuffer buf) {
        NetworkTools.writePos((ByteBuf)buf, this.pos);
        NetworkTools.writeString((ByteBuf)buf, this.command);
        TypedMapTools.writeArguments(buf, this.params);
        NetworkTools.writeString((ByteBuf)buf, this.modid);
    }

    public PacketRequestDataFromServer(String modid, BlockPos pos, String command, TypedMap params) {
        this.pos = pos;
        this.command = command;
        this.params = params;
        this.modid = modid;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            TileEntity te = ctx.getSender().func_130014_f_().func_175625_s(this.pos);
            if (!(te instanceof ICommandHandler)) {
                Logging.log("createStartScanPacket: TileEntity is not a CommandHandler!");
                return;
            }
            ICommandHandler commandHandler = (ICommandHandler)te;
            TypedMap result = commandHandler.executeWithResult(this.command, this.params);
            if (result == null) {
                Logging.log("Command " + this.command + " was not handled!");
                return;
            }
            this.sendReplyToClient(this, result, (PlayerEntity)ctx.getSender());
        });
        ctx.setPacketHandled(true);
    }

    private void sendReplyToClient(PacketRequestDataFromServer message, TypedMap result, PlayerEntity player) {
        SimpleChannel wrapper = PacketHandler.modNetworking.get(message.modid);
        PacketDataFromServer msg = new PacketDataFromServer(message.pos, message.command, result);
        wrapper.sendTo((Object)msg, ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
    }
}

