/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui.widgets;

import java.util.ArrayList;
import java.util.List;
import mcjty.lib.gui.GuiParser;
import mcjty.lib.gui.events.ButtonEvent;
import mcjty.lib.gui.widgets.AbstractLabel;
import mcjty.lib.gui.widgets.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;

public class Button
extends AbstractLabel<Button> {
    public static final String TYPE_BUTTON = "button";
    private List<ButtonEvent> buttonEvents = null;
    private boolean pressed = false;

    public Button(Minecraft mc, Screen gui) {
        super(mc, gui);
    }

    @Override
    public void draw(int x, int y) {
        if (!this.visible) {
            return;
        }
        int xx = x + this.bounds.x;
        int yy = y + this.bounds.y;
        if (this.isEnabledAndVisible()) {
            if (this.pressed) {
                this.drawStyledBoxSelected(this.window, xx, yy, xx + this.bounds.width - 1, yy + this.bounds.height - 1);
            } else if (this.isHovering()) {
                this.drawStyledBoxHovering(this.window, xx, yy, xx + this.bounds.width - 1, yy + this.bounds.height - 1);
            } else {
                this.drawStyledBoxNormal(this.window, xx, yy, xx + this.bounds.width - 1, yy + this.bounds.height - 1);
            }
        } else {
            this.drawStyledBoxDisabled(this.window, xx, yy, xx + this.bounds.width - 1, yy + this.bounds.height - 1);
        }
        super.drawOffset(x, y, 0, 1);
    }

    @Override
    public Widget<?> mouseClick(int x, int y, int button) {
        if (this.isEnabledAndVisible()) {
            this.pressed = true;
            return this;
        }
        return null;
    }

    @Override
    public void mouseRelease(int x, int y, int button) {
        super.mouseRelease(x, y, button);
        if (this.pressed) {
            this.pressed = false;
            if (this.isEnabledAndVisible()) {
                this.fireButtonEvents();
            }
        }
    }

    public Button addButtonEvent(ButtonEvent event) {
        if (this.buttonEvents == null) {
            this.buttonEvents = new ArrayList<ButtonEvent>();
        }
        this.buttonEvents.add(event);
        return this;
    }

    public void removeButtonEvent(ButtonEvent event) {
        if (this.buttonEvents != null) {
            this.buttonEvents.remove(event);
        }
    }

    private void fireButtonEvents() {
        this.fireChannelEvents();
        if (this.buttonEvents != null) {
            for (ButtonEvent event : this.buttonEvents) {
                event.buttonClicked(this);
            }
        }
    }

    @Override
    public GuiParser.GuiCommand createGuiCommand() {
        return new GuiParser.GuiCommand(TYPE_BUTTON);
    }
}

