/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.world.structure.tech;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.kaneka.planttech2.registries.ModStructures;
import net.kaneka.planttech2.world.structure.tech.TechVillageConfig;
import net.kaneka.planttech2.world.structure.tech.TechVillagePieces;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.MarginedStructureStart;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class TechVillageStructure
extends Structure<TechVillageConfig> {
    public TechVillageStructure(Function<Dynamic<?>, ? extends TechVillageConfig> function) {
        super(function);
    }

    protected int getSeedModifier() {
        return 987654321;
    }

    protected ChunkPos func_211744_a(ChunkGenerator<?> chunkGenerator, Random random, int x, int z, int spacingOffsetsX, int spacingOffsetsZ) {
        int i = chunkGenerator.func_201496_a_().func_202173_a();
        int j = chunkGenerator.func_201496_a_().func_211729_b();
        int k = x + i * spacingOffsetsX;
        int l = z + i * spacingOffsetsZ;
        int i1 = k < 0 ? k - i + 1 : k;
        int j1 = l < 0 ? l - i + 1 : l;
        int k1 = i1 / i;
        int l1 = j1 / i;
        ((SharedSeedRandom)random).func_202427_a(chunkGenerator.func_202089_c(), k1, l1, this.getSeedModifier());
        k1 *= i;
        l1 *= i;
        return new ChunkPos(k1 += random.nextInt(i - j), l1 += random.nextInt(i - j));
    }

    public boolean func_202372_a(ChunkGenerator<?> chunkGen, Random rand, int chunkPosX, int chunkPosZ) {
        ChunkPos chunkpos = this.func_211744_a(chunkGen, rand, chunkPosX, chunkPosZ, 0, 0);
        if (chunkPosX == chunkpos.field_77276_a && chunkPosZ == chunkpos.field_77275_b) {
            Biome biome = chunkGen.func_202090_b().func_222364_a(new BlockPos((chunkPosX << 4) + 9, 0, (chunkPosZ << 4) + 9));
            return chunkGen.func_202094_a(biome, ModStructures.TECHVILLAGE);
        }
        return false;
    }

    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    public String func_143025_a() {
        return "techvillage";
    }

    public int func_202367_b() {
        return 10;
    }

    public static class Start
    extends MarginedStructureStart {
        public Start(Structure<?> structure, int chunkX, int chunkZ, Biome biome, MutableBoundingBox mutableBB, int reference, long seed) {
            super(structure, chunkX, chunkZ, biome, mutableBB, reference, seed);
        }

        public void func_214625_a(ChunkGenerator<?> generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn) {
            BlockPos blockpos = new BlockPos(chunkX * 16, 90, chunkZ * 16);
            TechVillagePieces.init(generator, templateManagerIn, blockpos, this.field_75075_a, this.field_214631_d);
            this.func_202500_a();
        }
    }
}

