/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.world.planttopia.biomes.layer;

import com.google.common.collect.ImmutableList;
import java.util.function.LongFunction;
import net.kaneka.planttech2.world.planttopia.PlantTopiaGenSettings;
import net.kaneka.planttech2.world.planttopia.biomes.layer.PlantTopiaRareBiomeLayer;
import net.kaneka.planttech2.world.planttopia.biomes.layer.PlantTopiaRiverLayer;
import net.kaneka.planttech2.world.planttopia.biomes.layer.PlantTopiaRiverMixLayer;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.DeepOceanLayer;
import net.minecraft.world.gen.layer.IslandLayer;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.RemoveTooMuchOceanLayer;
import net.minecraft.world.gen.layer.SmoothLayer;
import net.minecraft.world.gen.layer.StartRiverLayer;
import net.minecraft.world.gen.layer.VoroniZoomLayer;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.minecraft.world.gen.layer.traits.IAreaTransformer1;

public class PlantTopiaLayerUtil {
    protected static final int WARM_OCEAN = Registry.field_212624_m.func_148757_b((Object)Biomes.field_203614_T);
    protected static final int LUKEWARM_OCEAN = Registry.field_212624_m.func_148757_b((Object)Biomes.field_203615_U);
    protected static final int OCEAN = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76771_b);
    protected static final int COLD_OCEAN = Registry.field_212624_m.func_148757_b((Object)Biomes.field_203616_V);
    protected static final int FROZEN_OCEAN = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76776_l);
    protected static final int DEEP_WARM_OCEAN = Registry.field_212624_m.func_148757_b((Object)Biomes.field_203617_W);
    protected static final int DEEP_LUKEWARM_OCEAN = Registry.field_212624_m.func_148757_b((Object)Biomes.field_203618_X);
    protected static final int DEEP_OCEAN = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150575_M);
    protected static final int DEEP_COLD_OCEAN = Registry.field_212624_m.func_148757_b((Object)Biomes.field_203619_Y);
    protected static final int DEEP_FROZEN_OCEAN = Registry.field_212624_m.func_148757_b((Object)Biomes.field_203620_Z);

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> repeat(long seed, IAreaTransformer1 parent, IAreaFactory<T> p_202829_3_, int count, LongFunction<C> contextFactory) {
        IAreaFactory iareafactory = p_202829_3_;
        for (int i = 0; i < count; ++i) {
            iareafactory = parent.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(seed + (long)i), iareafactory);
        }
        return iareafactory;
    }

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> ImmutableList<IAreaFactory<T>> buildOverworldProcedure(WorldType worldTypeIn, PlantTopiaGenSettings settings, LongFunction<C> contextFactory) {
        int i;
        IAreaFactory<T> iareafactory = IslandLayer.INSTANCE.func_202823_a((IExtendedNoiseRandom)contextFactory.apply(1L));
        iareafactory = ZoomLayer.FUZZY.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2000L), (IAreaFactory)iareafactory);
        iareafactory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2001L), (IAreaFactory)iareafactory);
        iareafactory = RemoveTooMuchOceanLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2L), (IAreaFactory)iareafactory);
        iareafactory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2002L), (IAreaFactory)iareafactory);
        iareafactory = DeepOceanLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(4L), (IAreaFactory)iareafactory);
        iareafactory = PlantTopiaLayerUtil.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, iareafactory, 0, contextFactory);
        int j = i = 8;
        if (settings != null) {
            j = settings.func_202198_k();
        }
        i = 3;
        IAreaFactory lvt_7_1_ = PlantTopiaLayerUtil.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, iareafactory, 0, contextFactory);
        lvt_7_1_ = StartRiverLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(100L), lvt_7_1_);
        IAreaFactory lvt_8_1_ = worldTypeIn.getBiomeLayer(iareafactory, (OverworldGenSettings)settings, contextFactory);
        lvt_7_1_ = PlantTopiaLayerUtil.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, lvt_7_1_, 2, contextFactory);
        lvt_7_1_ = PlantTopiaLayerUtil.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, lvt_7_1_, j, contextFactory);
        lvt_7_1_ = PlantTopiaRiverLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1L), lvt_7_1_);
        lvt_7_1_ = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000L), lvt_7_1_);
        lvt_8_1_ = PlantTopiaRareBiomeLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000L), lvt_8_1_);
        for (int k = 0; k < i; ++k) {
            lvt_8_1_ = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000 + k), lvt_8_1_);
            if (k != 1 && i != 1) continue;
            lvt_8_1_ = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000L), lvt_8_1_);
        }
        lvt_8_1_ = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000L), lvt_8_1_);
        lvt_8_1_ = PlantTopiaRiverMixLayer.INSTANCE.func_202707_a((IExtendedNoiseRandom)contextFactory.apply(100L), lvt_8_1_, lvt_7_1_);
        IAreaFactory iareafactory5 = VoroniZoomLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(10L), lvt_8_1_);
        return ImmutableList.of((Object)lvt_8_1_, (Object)iareafactory5, (Object)lvt_8_1_);
    }

    public static Layer[] buildOverworldProcedure(long seed, WorldType typeIn, PlantTopiaGenSettings settings) {
        int[] aint = new int[1];
        ImmutableList immutablelist = PlantTopiaLayerUtil.buildOverworldProcedure(typeIn, settings, (long p_202825_3_) -> {
            aint[0] = aint[0] + 1;
            return new LazyAreaLayerContext(1, (long)aint[0], seed);
        });
        Layer genlayer = new Layer((IAreaFactory)immutablelist.get(0));
        Layer genlayer1 = new Layer((IAreaFactory)immutablelist.get(1));
        Layer genlayer2 = new Layer((IAreaFactory)immutablelist.get(2));
        return new Layer[]{genlayer, genlayer1, genlayer2};
    }

    public static boolean isOcean(int biomeIn) {
        return biomeIn == WARM_OCEAN || biomeIn == LUKEWARM_OCEAN || biomeIn == OCEAN || biomeIn == COLD_OCEAN || biomeIn == FROZEN_OCEAN || biomeIn == DEEP_WARM_OCEAN || biomeIn == DEEP_LUKEWARM_OCEAN || biomeIn == DEEP_OCEAN || biomeIn == DEEP_COLD_OCEAN || biomeIn == DEEP_FROZEN_OCEAN;
    }
}

