/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items;

import java.util.List;
import net.kaneka.planttech2.items.BaseItem;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class CreditCardItem
extends BaseItem {
    public CreditCardItem(String name, Item.Properties property) {
        super(name, property);
    }

    public static boolean hasCredits(ItemStack stack) {
        CompoundNBT nbt = CreditCardItem.getNBT(stack);
        return nbt.func_74764_b("credits");
    }

    public static int getCredits(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof CreditCardItem && CreditCardItem.hasCredits(stack)) {
            return CreditCardItem.getNBT(stack).func_74762_e("credits");
        }
        return 0;
    }

    public static CompoundNBT getNBT(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null) {
            return nbt;
        }
        return new CompoundNBT();
    }

    public static int addCredits(ItemStack stack, int amount) {
        int newValue = CreditCardItem.getCredits(stack) + amount;
        CreditCardItem.setCredits(stack, newValue);
        return newValue;
    }

    public static int shrinkCredits(ItemStack stack, int amount) {
        int newValue = Math.max(CreditCardItem.getCredits(stack) - amount, 0);
        CreditCardItem.setCredits(stack, newValue);
        return newValue;
    }

    public static void setCredits(ItemStack stack, int amount) {
        CompoundNBT nbt = CreditCardItem.getNBT(stack);
        nbt.func_74768_a("credits", amount);
        stack.func_77982_d(nbt);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent("Plantcredits: " + CreditCardItem.getCredits(stack)));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }
}

