/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.patch;

import com.google.common.base.Charsets;
import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.response.MinecraftTexturesPayload;
import com.mojang.util.UUIDTypeAdapter;
import com.therandomlabs.randompatches.RPConfig;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import org.apache.commons.codec.binary.Base64;

public final class CompoundNBTPatch {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).create();

    private CompoundNBTPatch() {
    }

    public static boolean areTagMapsEqual(Map<String, INBT> tagMap1, Map<String, INBT> tagMap2) {
        GameProfile profile2;
        if (tagMap1.equals(tagMap2)) {
            return true;
        }
        INBT skullOwner1 = tagMap1.get("SkullOwner");
        if (!(skullOwner1 instanceof CompoundNBT)) {
            return false;
        }
        INBT skullOwner2 = tagMap2.get("SkullOwner");
        if (!(skullOwner2 instanceof CompoundNBT)) {
            return false;
        }
        GameProfile profile1 = NBTUtil.func_152459_a((CompoundNBT)((CompoundNBT)skullOwner1));
        if (!profile1.equals((Object)(profile2 = NBTUtil.func_152459_a((CompoundNBT)((CompoundNBT)skullOwner2))))) {
            return false;
        }
        if (!RPConfig.Misc.skullStackingRequiresSameTextures) {
            return true;
        }
        MinecraftProfileTexture texture1 = CompoundNBTPatch.getSkin(profile1);
        MinecraftProfileTexture texture2 = CompoundNBTPatch.getSkin(profile2);
        return texture1 != null && texture2 != null && texture1.getUrl().equals(texture2.getUrl());
    }

    public static MinecraftTexturesPayload getTextures(GameProfile profile) {
        Property textureProperty = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
        if (textureProperty == null) {
            return null;
        }
        String json = new String(Base64.decodeBase64((String)textureProperty.getValue()), Charsets.UTF_8);
        return (MinecraftTexturesPayload)GSON.fromJson(json, MinecraftTexturesPayload.class);
    }

    public static MinecraftProfileTexture getSkin(GameProfile profile) {
        MinecraftTexturesPayload payload = CompoundNBTPatch.getTextures(profile);
        return payload == null ? null : (MinecraftProfileTexture)payload.getTextures().get(MinecraftProfileTexture.Type.SKIN);
    }
}

