/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomlib.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.google.common.collect.Lists;
import com.therandomlabs.randomlib.TRLUtils;
import com.therandomlabs.randomlib.config.Config;
import com.therandomlabs.randomlib.config.ConfigData;
import com.therandomlabs.randomlib.config.ConfigException;
import com.therandomlabs.randomlib.config.TRLCategory;
import com.therandomlabs.randomlib.config.TRLProperty;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraftforge.forgespi.language.MavenVersionAdapter;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.versioning.VersionRange;

public final class ConfigManager {
    private static final Map<Class<?>, ConfigData> CONFIGS = new HashMap();
    private static final Map<String, List<ConfigData>> MODID_TO_CONFIGS = new HashMap<String, List<ConfigData>>();

    private ConfigManager() {
    }

    public static void register(Class<?> clazz) {
        Config config = clazz.getAnnotation(Config.class);
        if (config == null) {
            throw new IllegalArgumentException(clazz.getName() + " is not a configuration class");
        }
        String modid = config.modid();
        Object[] comment = config.comment();
        if (StringUtils.join((Object[])comment).trim().isEmpty()) {
            throw new IllegalArgumentException("Configuration comment may not be empty");
        }
        String pathData = config.path();
        String pathString = "config/" + (pathData.isEmpty() ? modid : config.path()) + ".toml";
        Path path = Paths.get(pathString, new String[0]).toAbsolutePath();
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new ConfigException("Failed to create configuration directory", ex);
        }
        ArrayList<TRLCategory> categories = new ArrayList<TRLCategory>();
        ConfigManager.loadCategories("", modid + ".config.", "", clazz, categories);
        ConfigData data = new ConfigData((String[])comment, clazz, pathString, path, categories);
        CONFIGS.put(clazz, data);
        MODID_TO_CONFIGS.computeIfAbsent(modid, id -> new ArrayList()).add(data);
        ConfigManager.reloadFromDisk(clazz);
    }

    public static void reloadFromDisk(Class<?> clazz) {
        ConfigData data = CONFIGS.get(clazz);
        try {
            data.config.load();
        }
        catch (ParsingException ex) {
            data.config.entrySet().clear();
        }
        ConfigManager.reloadFromConfig(clazz);
    }

    public static void reloadFromConfig(Class<?> clazz) {
        ConfigData data = CONFIGS.get(clazz);
        for (TRLCategory category : data.categories) {
            for (TRLProperty property : category.properties) {
                if (!property.exists(data.config)) continue;
                try {
                    if (property.adapter.shouldLoad()) {
                        Object delayedLoad = data.delayedLoad.get(property.fullyQualifiedName);
                        if (delayedLoad != null) {
                            property.reloadDefault();
                            data.config.set(property.fullyQualifiedName, delayedLoad);
                            data.delayedLoad.remove(property.fullyQualifiedName);
                        }
                        property.deserialize(data.config);
                        continue;
                    }
                    data.delayedLoad.put(property.fullyQualifiedName, data.config.get(property.fullyQualifiedName));
                }
                catch (Exception ex) {
                    TRLUtils.crashReport("Failed to deserialize configuration property " + property.fullyQualifiedName, ex);
                }
            }
        }
        ConfigManager.writeToDisk(clazz);
    }

    public static void writeToDisk(Class<?> clazz) {
        ConfigData data = CONFIGS.get(clazz);
        ArrayList subConfigs = Lists.newArrayList((Object[])new CommentedConfig[]{data.config});
        while (!subConfigs.isEmpty()) {
            int size = subConfigs.size();
            for (int i = 0; i < size; ++i) {
                for (CommentedConfig.Entry entry : ((CommentedConfig)subConfigs.get(i)).entrySet()) {
                    entry.removeComment();
                    Object raw = entry.getRawValue();
                    if (!(raw instanceof CommentedConfig)) continue;
                    subConfigs.add((CommentedConfig)raw);
                }
            }
            subConfigs.subList(0, size).clear();
        }
        for (TRLCategory category : data.categories) {
            category.initialize(data.config);
            category.onReload(false);
            if (TRLUtils.IS_CLIENT) {
                category.onReload(true);
            }
            for (TRLProperty property : category.properties) {
                try {
                    property.get(data.config);
                    Object delayedLoad = data.delayedLoad.get(property.fullyQualifiedName);
                    if (delayedLoad == null) continue;
                    data.config.set(property.fullyQualifiedName, delayedLoad);
                }
                catch (Exception ex) {
                    TRLUtils.crashReport("Failed to serialize configuration property " + property.fullyQualifiedName, ex);
                }
            }
        }
        subConfigs.add(data.config);
        while (!subConfigs.isEmpty()) {
            int size = subConfigs.size();
            for (int i = 0; i < size; ++i) {
                CommentedConfig subConfig = (CommentedConfig)subConfigs.get(i);
                HashSet<String> toRemove = new HashSet<String>();
                for (CommentedConfig.Entry entry : subConfig.entrySet()) {
                    if (entry.getComment() == null) {
                        toRemove.add(entry.getKey());
                        continue;
                    }
                    Object raw = entry.getRawValue();
                    if (!(raw instanceof CommentedConfig)) continue;
                    subConfigs.add((CommentedConfig)raw);
                }
                toRemove.forEach(arg_0 -> ((CommentedConfig)subConfig).remove(arg_0));
            }
            subConfigs.subList(0, size).clear();
        }
        data.config.save();
        try {
            ArrayList<String> lines = new ArrayList<String>(Files.readAllLines(data.path));
            lines.addAll(0, data.comment);
            Files.write(data.path, lines, new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new ConfigException("Failed to write config", ex);
        }
    }

    public static CommentedFileConfig get(Class<?> clazz) {
        return ConfigManager.CONFIGS.get(clazz).config;
    }

    public static String getPathString(Class<?> clazz) {
        return ConfigManager.CONFIGS.get(clazz).pathString;
    }

    public static Path getPath(Class<?> clazz) {
        return ConfigManager.CONFIGS.get(clazz).path;
    }

    private static void loadCategories(String fullyQualifiedNamePrefix, String languageKeyPrefix, String parentCategory, Class<?> clazz, List<TRLCategory> categories) {
        for (Field field : clazz.getDeclaredFields()) {
            Config.Category categoryData = field.getAnnotation(Config.Category.class);
            if (categoryData == null) continue;
            String comment = " " + StringUtils.join((Object[])categoryData.value(), (String)"\n ");
            if (comment.trim().isEmpty()) {
                throw new IllegalArgumentException("Category comment may not be empty");
            }
            String name = field.getName();
            int modifiers = field.getModifiers();
            if (!(Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers))) {
                throw new IllegalArgumentException(name + " is not public static final");
            }
            if (!ConfigManager.testVersionRange(field)) continue;
            Class<?> categoryClass = field.getType();
            String categoryName = parentCategory + name;
            TRLCategory category = new TRLCategory(fullyQualifiedNamePrefix, languageKeyPrefix, categoryClass, comment, categoryName);
            ConfigManager.loadCategory(category);
            categories.add(category);
            ConfigManager.loadCategories(fullyQualifiedNamePrefix, languageKeyPrefix, categoryName + ".", categoryClass, categories);
        }
    }

    private static void loadCategory(TRLCategory category) {
        for (Field field : category.clazz.getDeclaredFields()) {
            Config.Property propertyData = field.getAnnotation(Config.Property.class);
            if (propertyData == null) continue;
            String comment = " " + StringUtils.join((Object[])propertyData.value(), (String)"\n ");
            if (comment.trim().isEmpty()) {
                throw new IllegalArgumentException("Property comment may not be empty");
            }
            String name = field.getName();
            int modifiers = field.getModifiers();
            if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) {
                throw new IllegalArgumentException(name + " is not public static non-final");
            }
            if (!ConfigManager.testVersionRange(field)) continue;
            Config.Previous previousData = field.getAnnotation(Config.Previous.class);
            String previous = previousData == null ? null : previousData.value();
            try {
                category.properties.add(new TRLProperty(category, name, field, comment, previous));
            }
            catch (RuntimeException ex) {
                throw new ConfigException(name, ex);
            }
        }
    }

    private static boolean testVersionRange(Field field) {
        Config.MinForgeBuild minForgeBuild;
        Config.MCVersion mcVersion = field.getAnnotation(Config.MCVersion.class);
        if (mcVersion != null) {
            String versionRange = mcVersion.value().trim();
            if (versionRange.isEmpty()) {
                throw new IllegalArgumentException("Version range must not be empty");
            }
            VersionRange range = MavenVersionAdapter.createFromVersionSpec((String)versionRange);
            if (!range.containsVersion(TRLUtils.MC_ARTIFACT_VERSION)) {
                return false;
            }
        }
        if ((minForgeBuild = field.getAnnotation(Config.MinForgeBuild.class)) == null) {
            return true;
        }
        int forgeBuild = minForgeBuild.value();
        if (forgeBuild < 1) {
            throw new IllegalArgumentException("Invalid Forge build: " + forgeBuild);
        }
        return TRLUtils.FORGE_BUILD >= forgeBuild;
    }
}

