/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.UnmodifiableIterator;
import cpw.mods.inventorysorter.ContainerContext;
import cpw.mods.inventorysorter.InventoryHandler;
import cpw.mods.inventorysorter.InventorySorter;
import cpw.mods.inventorysorter.ItemStackHolder;
import java.util.function.Consumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.util.Supplier;

public enum SortingHandler implements Consumer<ContainerContext>
{
    INSTANCE;


    @Override
    public void accept(ContainerContext context) {
        if (context == null) {
            throw new NullPointerException("WHUT");
        }
        if (context.slotMapping == null) {
            return;
        }
        Multiset<ItemStackHolder> itemcounts = InventoryHandler.INSTANCE.getInventoryContent(context);
        if (context.slot.field_75224_c instanceof CraftingInventory) {
            this.distributeInventory(context, itemcounts);
        } else if (!context.slotMapping.markAsHeterogeneous) {
            this.compactInventory(context, itemcounts);
        }
    }

    private void distributeInventory(ContainerContext context, Multiset<ItemStackHolder> itemcounts) {
    }

    private void compactInventory(ContainerContext context, Multiset<ItemStackHolder> itemcounts) {
        UnmodifiableIterator itemsIterator;
        ResourceLocation containerClass;
        InventorySorter.INSTANCE.lastContainerType = containerClass = context.player.field_71070_bA.func_216957_a().getRegistryName();
        if (InventorySorter.INSTANCE.containerblacklist.contains(containerClass)) {
            InventorySorter.INSTANCE.debugLog("Container {} blacklisted", () -> new String[]{containerClass.toString()});
            return;
        }
        InventorySorter.INSTANCE.debugLog("Container \"{}\" being sorted", () -> new String[]{containerClass.toString()});
        try {
            itemsIterator = Multisets.copyHighestCountFirst(itemcounts).entrySet().iterator();
        }
        catch (Exception e) {
            InventorySorter.LOGGER.warn("Weird, the sorting didn't quite work!", (Throwable)e);
            return;
        }
        int slotLow = context.slotMapping.begin;
        int slotHigh = context.slotMapping.end + 1;
        Multiset.Entry stackHolder = itemsIterator.hasNext() ? (Multiset.Entry)itemsIterator.next() : null;
        int itemCount = stackHolder != null ? stackHolder.getCount() : 0;
        for (int i = slotLow; i < slotHigh; ++i) {
            Slot slot = context.player.field_71070_bA.func_75139_a(i);
            if (!slot.func_82869_a((PlayerEntity)context.player) && slot.func_75216_d()) {
                InventorySorter.LOGGER.log(Level.DEBUG, "Slot {} of container {} disallows canTakeStack", new Supplier[]{() -> slot.field_75222_d, () -> containerClass});
                continue;
            }
            slot.func_75215_d(ItemStack.field_190927_a);
            ItemStack target = ItemStack.field_190927_a;
            if (itemCount > 0 && stackHolder != null) {
                target.func_190920_e(itemCount > (target = ((ItemStackHolder)stackHolder.getElement()).is.func_77946_l()).func_77976_d() ? target.func_77976_d() : itemCount);
            }
            if (!target.func_190926_b() && !slot.func_75214_a(target)) {
                ItemStack trg = target;
                InventorySorter.LOGGER.log(Level.DEBUG, "Item {} is not valid in slot {} of container {}", new Supplier[]{() -> trg, () -> slot.field_75222_d, () -> containerClass});
                continue;
            }
            slot.func_75215_d(target.func_190926_b() ? ItemStack.field_190927_a : target);
            if ((itemCount -= !target.func_190926_b() ? target.func_190916_E() : 0) != 0) continue;
            stackHolder = itemsIterator.hasNext() ? (Multiset.Entry)itemsIterator.next() : null;
            itemCount = stackHolder != null ? stackHolder.getCount() : 0;
        }
    }
}

