/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.block.module;

import com.buuz135.portality.block.module.BlockCapabilityModule;
import com.buuz135.portality.tile.TileEntityEnergyModule;
import com.hrznstudio.titanium.api.IFactory;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class BlockCapabilityEnergyModule
extends BlockCapabilityModule<IEnergyStorage, TileEntityEnergyModule> {
    public BlockCapabilityEnergyModule() {
        super("module_energy", TileEntityEnergyModule.class);
    }

    @Override
    public Capability<IEnergyStorage> getCapability() {
        return CapabilityEnergy.ENERGY;
    }

    @Override
    void internalWork(World current, BlockPos myself, World otherWorld, List<BlockPos> compatibleBlockPos) {
        current.func_175625_s(myself).getCapability(this.getCapability()).ifPresent(storage -> {
            for (BlockPos pos : compatibleBlockPos) {
                TileEntity entity = otherWorld.func_175625_s(pos);
                if (entity == null) continue;
                entity.getCapability(this.getCapability()).ifPresent(otherStorage -> {
                    int energy = otherStorage.receiveEnergy(Math.min(storage.getEnergyStored(), 5000), false);
                    storage.extractEnergy(energy, false);
                    if (energy > 0) {
                        return;
                    }
                });
            }
        });
    }

    @Override
    public IFactory<TileEntityEnergyModule> getTileEntityFactory() {
        return TileEntityEnergyModule::new;
    }

    @Override
    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityEnergyModule();
    }
}

