/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.powercell.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftoolspower.modules.powercell.blocks.PowerCellBlock;
import mcjty.rftoolspower.modules.powercell.blocks.PowerCellTileEntity;
import mcjty.rftoolspower.modules.powercell.data.SideType;
import mcjty.rftoolspower.modules.powercell.data.Tier;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;

public class PowerCellBakedModel
implements IDynamicBakedModel {
    private VertexFormat format;
    private static TextureAtlasSprite inputMask;
    private static TextureAtlasSprite outputMask;

    private static TextureAtlasSprite getInputMask() {
        if (inputMask == null) {
            inputMask = Minecraft.func_71410_x().func_147117_R().func_110572_b("rftoolspower:block/inputmask");
        }
        return inputMask;
    }

    private static TextureAtlasSprite getOutputMask() {
        if (outputMask == null) {
            outputMask = Minecraft.func_71410_x().func_147117_R().func_110572_b("rftoolspower:block/outputmask");
        }
        return outputMask;
    }

    private static TextureAtlasSprite getSideTexture(boolean upper, boolean lower, int tier) {
        String s = "rftoolspower:block/cell";
        s = upper && lower ? s + "middle_t" : (upper ? s + "lower_t" : (lower ? s + "upper_t" : s + "both_t"));
        s = s + tier;
        return Minecraft.func_71410_x().func_147117_R().func_110572_b(s);
    }

    private static TextureAtlasSprite getTopTexture() {
        String name = "rftoolspower:block/cellhoriz_t1";
        return Minecraft.func_71410_x().func_147117_R().func_110572_b(name);
    }

    public PowerCellBakedModel(VertexFormat format) {
        this.format = format;
    }

    private void putVertex(UnpackedBakedQuad.Builder builder, Vec3d normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite, float color) {
        block6: for (int e = 0; e < this.format.func_177345_h(); ++e) {
            switch (this.format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    builder.put(e, new float[]{(float)x, (float)y, (float)z, 1.0f});
                    continue block6;
                }
                case COLOR: {
                    builder.put(e, new float[]{color, color, color, 1.0f});
                    continue block6;
                }
                case UV: {
                    if (this.format.func_177348_c(e).func_177369_e() == 0) {
                        u = sprite.func_94214_a((double)u);
                        v = sprite.func_94207_b((double)v);
                        builder.put(e, new float[]{u, v, 0.0f, 1.0f});
                        continue block6;
                    }
                }
                case NORMAL: {
                    builder.put(e, new float[]{(float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c, 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    private BakedQuad createQuad(Vec3d v1, Vec3d v2, Vec3d v3, Vec3d v4, TextureAtlasSprite sprite, float hilight) {
        Vec3d normal = v3.func_178788_d(v2).func_72431_c(v1.func_178788_d(v2)).func_72432_b();
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this.format);
        builder.setTexture(sprite);
        this.putVertex(builder, normal, v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, 0.0f, 0.0f, sprite, hilight);
        this.putVertex(builder, normal, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, 0.0f, 16.0f, sprite, hilight);
        this.putVertex(builder, normal, v3.field_72450_a, v3.field_72448_b, v3.field_72449_c, 16.0f, 16.0f, sprite, hilight);
        this.putVertex(builder, normal, v4.field_72450_a, v4.field_72448_b, v4.field_72449_c, 16.0f, 0.0f, sprite, hilight);
        return builder.build();
    }

    private static Vec3d v(double x, double y, double z) {
        return new Vec3d(x, y, z);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData data) {
        if (side != null) {
            return Collections.emptyList();
        }
        boolean upper = Boolean.TRUE.equals(state.func_177229_b((IProperty)PowerCellBlock.UPPER));
        boolean lower = Boolean.TRUE.equals(state.func_177229_b((IProperty)PowerCellBlock.LOWER));
        SideType north = (SideType)((Object)data.getData(PowerCellTileEntity.NORTH));
        SideType south = (SideType)((Object)data.getData(PowerCellTileEntity.SOUTH));
        SideType west = (SideType)((Object)data.getData(PowerCellTileEntity.WEST));
        SideType east = (SideType)((Object)data.getData(PowerCellTileEntity.EAST));
        SideType up = (SideType)((Object)data.getData(PowerCellTileEntity.UP));
        SideType down = (SideType)((Object)data.getData(PowerCellTileEntity.DOWN));
        Tier tier = (Tier)((Object)data.getData(PowerCellTileEntity.TIER));
        if (tier == null) {
            return Collections.emptyList();
        }
        int t = tier.ordinal() + 1;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        float hilight = 1.0f;
        float o = 0.25f;
        quads.add(this.createQuad(PowerCellBakedModel.v(0.0, 1.0, 0.0), PowerCellBakedModel.v(0.0, 1.0, 1.0), PowerCellBakedModel.v(1.0, 1.0, 1.0), PowerCellBakedModel.v(1.0, 1.0, 0.0), PowerCellBakedModel.getTopTexture(), hilight));
        if (up.isInput()) {
            quads.add(this.createQuad(PowerCellBakedModel.v(o, 1.02, o), PowerCellBakedModel.v(o, 1.02, 1.0f - o), PowerCellBakedModel.v(1.0f - o, 1.02, 1.0f - o), PowerCellBakedModel.v(1.0f - o, 1.02, o), PowerCellBakedModel.getInputMask(), hilight));
        }
        if (up.isOutput()) {
            quads.add(this.createQuad(PowerCellBakedModel.v(o, 1.02, o), PowerCellBakedModel.v(o, 1.02, 1.0f - o), PowerCellBakedModel.v(1.0f - o, 1.02, 1.0f - o), PowerCellBakedModel.v(1.0f - o, 1.02, o), PowerCellBakedModel.getOutputMask(), hilight));
        }
        quads.add(this.createQuad(PowerCellBakedModel.v(0.0, 0.0, 0.0), PowerCellBakedModel.v(1.0, 0.0, 0.0), PowerCellBakedModel.v(1.0, 0.0, 1.0), PowerCellBakedModel.v(0.0, 0.0, 1.0), PowerCellBakedModel.getTopTexture(), hilight));
        if (down.isInput()) {
            quads.add(this.createQuad(PowerCellBakedModel.v(o, -0.02, o), PowerCellBakedModel.v(1.0f - o, -0.02, o), PowerCellBakedModel.v(1.0f - o, -0.02, 1.0f - o), PowerCellBakedModel.v(o, -0.02, 1.0f - o), PowerCellBakedModel.getInputMask(), hilight));
        }
        if (down.isOutput()) {
            quads.add(this.createQuad(PowerCellBakedModel.v(o, -0.02, o), PowerCellBakedModel.v(1.0f - o, -0.02, o), PowerCellBakedModel.v(1.0f - o, -0.02, 1.0f - o), PowerCellBakedModel.v(o, -0.02, 1.0f - o), PowerCellBakedModel.getOutputMask(), hilight));
        }
        quads.add(this.createQuad(PowerCellBakedModel.v(1.0, 1.0, 1.0), PowerCellBakedModel.v(1.0, 0.0, 1.0), PowerCellBakedModel.v(1.0, 0.0, 0.0), PowerCellBakedModel.v(1.0, 1.0, 0.0), PowerCellBakedModel.getSideTexture(upper, lower, t), hilight));
        if (east.isInput()) {
            quads.add(this.createQuad(PowerCellBakedModel.v(1.02, 1.0f - o, 1.0f - o), PowerCellBakedModel.v(1.02, o, 1.0f - o), PowerCellBakedModel.v(1.02, o, o), PowerCellBakedModel.v(1.02, 1.0f - o, o), PowerCellBakedModel.getInputMask(), hilight));
        }
        if (east.isOutput()) {
            quads.add(this.createQuad(PowerCellBakedModel.v(1.02, 1.0f - o, 1.0f - o), PowerCellBakedModel.v(1.02, o, 1.0f - o), PowerCellBakedModel.v(1.02, o, o), PowerCellBakedModel.v(1.02, 1.0f - o, o), PowerCellBakedModel.getOutputMask(), hilight));
        }
        quads.add(this.createQuad(PowerCellBakedModel.v(0.0, 1.0, 0.0), PowerCellBakedModel.v(0.0, 0.0, 0.0), PowerCellBakedModel.v(0.0, 0.0, 1.0), PowerCellBakedModel.v(0.0, 1.0, 1.0), PowerCellBakedModel.getSideTexture(upper, lower, t), hilight));
        if (west.isInput()) {
            quads.add(this.createQuad(PowerCellBakedModel.v(-0.02, 1.0f - o, o), PowerCellBakedModel.v(-0.02, o, o), PowerCellBakedModel.v(-0.02, o, 1.0f - o), PowerCellBakedModel.v(-0.02, 1.0f - o, 1.0f - o), PowerCellBakedModel.getInputMask(), hilight));
        }
        if (west.isOutput()) {
            quads.add(this.createQuad(PowerCellBakedModel.v(-0.02, 1.0f - o, o), PowerCellBakedModel.v(-0.02, o, o), PowerCellBakedModel.v(-0.02, o, 1.0f - o), PowerCellBakedModel.v(-0.02, 1.0f - o, 1.0f - o), PowerCellBakedModel.getOutputMask(), hilight));
        }
        quads.add(this.createQuad(PowerCellBakedModel.v(1.0, 1.0, 0.0), PowerCellBakedModel.v(1.0, 0.0, 0.0), PowerCellBakedModel.v(0.0, 0.0, 0.0), PowerCellBakedModel.v(0.0, 1.0, 0.0), PowerCellBakedModel.getSideTexture(upper, lower, t), hilight));
        if (north.isInput()) {
            quads.add(this.createQuad(PowerCellBakedModel.v(1.0f - o, 1.0f - o, -0.02), PowerCellBakedModel.v(1.0f - o, o, -0.02), PowerCellBakedModel.v(o, o, -0.02), PowerCellBakedModel.v(o, 1.0f - o, -0.02), PowerCellBakedModel.getInputMask(), hilight));
        }
        if (north.isOutput()) {
            quads.add(this.createQuad(PowerCellBakedModel.v(1.0f - o, 1.0f - o, -0.02), PowerCellBakedModel.v(1.0f - o, o, -0.02), PowerCellBakedModel.v(o, o, -0.02), PowerCellBakedModel.v(o, 1.0f - o, -0.02), PowerCellBakedModel.getOutputMask(), hilight));
        }
        quads.add(this.createQuad(PowerCellBakedModel.v(0.0, 1.0, 1.0), PowerCellBakedModel.v(0.0, 0.0, 1.0), PowerCellBakedModel.v(1.0, 0.0, 1.0), PowerCellBakedModel.v(1.0, 1.0, 1.0), PowerCellBakedModel.getSideTexture(upper, lower, t), hilight));
        if (south.isInput()) {
            quads.add(this.createQuad(PowerCellBakedModel.v(o, 1.0f - o, 1.02), PowerCellBakedModel.v(o, o, 1.02), PowerCellBakedModel.v(1.0f - o, o, 1.02), PowerCellBakedModel.v(1.0f - o, 1.0f - o, 1.02), PowerCellBakedModel.getInputMask(), hilight));
        }
        if (south.isOutput()) {
            quads.add(this.createQuad(PowerCellBakedModel.v(o, 1.0f - o, 1.02), PowerCellBakedModel.v(o, o, 1.02), PowerCellBakedModel.v(1.0f - o, o, 1.02), PowerCellBakedModel.v(1.0f - o, 1.0f - o, 1.02), PowerCellBakedModel.getOutputMask(), hilight));
        }
        return quads;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return PowerCellBakedModel.getSideTexture(false, false, 1);
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

