/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.informationscreen.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolspower.blocks.ModBlocks;
import mcjty.rftoolspower.modules.informationscreen.blocks.InformationScreenBlock;
import mcjty.rftoolspower.modules.powercell.blocks.PowerCellTileEntity;
import mcjty.rftoolspower.modules.powercell.data.PowerCellNetwork;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public class InformationScreenTileEntity
extends GenericTileEntity
implements ITickableTileEntity {
    public static final String REGNAME = "information_screen";
    private int mode = 0;
    private int cnt = 0;
    private long lastExtracted = 0L;
    private long lastInserted = 0L;
    private long rfExtractPerTick = 0L;
    private long rfInsertedPerTick = 0L;
    private long lastHudTime = 0L;
    private EnergyTools.EnergyLevel clientPower;
    private long roughMaxRfPerTick = 0L;

    public InformationScreenTileEntity() {
        super(ModBlocks.TYPE_INFORMATION_SCREEN);
    }

    public Direction getBlockOrientation() {
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() instanceof InformationScreenBlock) {
            return OrientationTools.getOrientationHoriz((BlockState)state);
        }
        return null;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            --this.cnt;
            if (this.cnt <= 0) {
                this.cnt = 10;
                BlockPos offset = this.func_174877_v().func_177972_a(this.getBlockOrientation().func_176734_d());
                TileEntity te = this.field_145850_b.func_175625_s(offset);
                if (te instanceof PowerCellTileEntity) {
                    PowerCellTileEntity powercell = (PowerCellTileEntity)te;
                    PowerCellNetwork network = powercell.getNetwork();
                    if (network != null) {
                        long newExtracted = network.getExtracted();
                        long newInserted = network.getInserted();
                        this.rfExtractPerTick = (newExtracted - this.lastExtracted) / 10L;
                        this.rfInsertedPerTick = (newInserted - this.lastInserted) / 10L;
                        this.lastExtracted = newExtracted;
                        this.lastInserted = newInserted;
                    }
                } else {
                    this.rfExtractPerTick = -1L;
                    this.rfInsertedPerTick = -1L;
                }
            }
        }
    }

    public void toggleMode() {
        ++this.mode;
        if (this.mode > 2) {
            this.mode = 0;
        }
        this.markDirtyClient();
    }

    public int getMode() {
        return this.mode;
    }

    public void func_145839_a(CompoundNBT tagCompound) {
        super.func_145839_a(tagCompound);
        this.mode = tagCompound.func_74771_c("mode");
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        tagCompound.func_74774_a("mode", (byte)this.mode);
        return super.func_189515_b(tagCompound);
    }

    public void setClientPower(EnergyTools.EnergyLevel power, long rfInsertedPerTick, long rfExtractPerTick, long roughMaxRfPerTick) {
        this.clientPower = power;
        this.rfInsertedPerTick = rfInsertedPerTick;
        this.rfExtractPerTick = rfExtractPerTick;
        this.roughMaxRfPerTick = roughMaxRfPerTick;
    }

    public EnergyTools.EnergyLevel getClientPower() {
        return this.clientPower;
    }

    public long calculateRoughMaxRfPerTick() {
        BlockPos offset = this.func_174877_v().func_177972_a(this.getBlockOrientation().func_176734_d());
        TileEntity te = this.field_145850_b.func_175625_s(offset);
        if (te instanceof PowerCellTileEntity) {
            PowerCellTileEntity powercell = (PowerCellTileEntity)te;
            return powercell.getRfPerTickPerSide() * 2L;
        }
        return -1L;
    }

    public long getRoughMaxRfPerTick() {
        return this.roughMaxRfPerTick;
    }

    public long getLastUpdateTime() {
        return this.lastHudTime;
    }

    public void setLastUpdateTime(long t) {
        this.lastHudTime = t;
    }

    public long getRfExtractPerTick() {
        return this.rfExtractPerTick;
    }

    public long getRfInsertedPerTick() {
        return this.rfInsertedPerTick;
    }

    public EnergyTools.EnergyLevel getPower() {
        BlockPos offset = this.func_174877_v().func_177972_a(this.getBlockOrientation().func_176734_d());
        TileEntity te = this.field_145850_b.func_175625_s(offset);
        if (te instanceof PowerCellTileEntity) {
            PowerCellTileEntity powercell = (PowerCellTileEntity)te;
            PowerCellNetwork network = powercell.getNetwork();
            if (network != null) {
                long energy = network.getEnergy();
                long maxEnergy = network.getMaxEnergy();
                return new EnergyTools.EnergyLevel(energy, maxEnergy);
            }
        } else if (EnergyTools.isEnergyTE((TileEntity)te, (Direction)this.getBlockOrientation())) {
            return EnergyTools.getEnergyLevelMulti((TileEntity)te, (Direction)this.getBlockOrientation());
        }
        return null;
    }
}

