/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.generator.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.information.CapabilityPowerInformation;
import mcjty.lib.api.information.IPowerInformation;
import mcjty.lib.api.infusable.CapabilityInfusable;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.container.NoDirectionItemHander;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.OrientationTools;
import mcjty.lib.varia.RedstoneMode;
import mcjty.rftoolspower.blocks.ModBlocks;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.config.CoalGeneratorConfig;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CoalGeneratorTileEntity
extends GenericTileEntity
implements ITickableTileEntity {
    public static final String REGNAME = "coalgenerator";
    public static final String CMD_RSMODE = "coalgen.setRsMode";
    public static final int SLOT_COALINPUT = 0;
    public static final int SLOT_CHARGEITEM = 1;
    public static final ContainerFactory CONTAINER_FACTORY = new ContainerFactory(2){

        protected void setup() {
            this.slot(SlotDefinition.specific((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151044_h), new ItemStack((IItemProvider)Items.field_196155_l), new ItemStack((IItemProvider)Blocks.field_150402_ci)}), "container", 0, 82, 24);
            this.slot(SlotDefinition.specific(stack -> EnergyTools.isEnergyItem((ItemStack)stack)), "container", 1, 118, 24);
            this.playerSlots(10, 70);
        }
    };
    private LazyOptional<NoDirectionItemHander> itemHandler = LazyOptional.of(() -> new NoDirectionItemHander((GenericTileEntity)this, CONTAINER_FACTORY));
    private LazyOptional<GenericEnergyStorage> energyHandler = LazyOptional.of(() -> new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)CoalGeneratorConfig.MAXENERGY.get()).intValue(), 0L));
    private LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Crafter").containerSupplier((windowId, player) -> new GenericContainer(ModBlocks.CONTAINER_COALGENERATOR, windowId.intValue(), CONTAINER_FACTORY, this.func_174877_v(), (GenericTileEntity)this)).itemHandler(this.itemHandler).energyHandler(this.energyHandler));
    private LazyOptional<IInfusable> infusableHandler = LazyOptional.of(() -> new DefaultInfusable((TileEntity)this));
    private LazyOptional<IPowerInformation> powerInfoHandler = LazyOptional.of(() -> this.createPowerInfo());
    private int burning;

    public CoalGeneratorTileEntity() {
        super(ModBlocks.TYPE_COALGENERATOR);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(REGNAME, new BlockBuilder().tileEntitySupplier(CoalGeneratorTileEntity::new).topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).infusable().info("message.rftoolspower.shiftmessage").infoExtended("message.rftoolspower.coalgenerator").infoExtendedParameter(stack -> Long.toString(((Integer)CoalGeneratorConfig.RFPERTICK.get()).intValue()))){

            protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
                super.func_206840_a(builder);
                builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208190_q});
            }

            public boolean canRenderInLayer(BlockState state, BlockRenderLayer layer) {
                return layer == BlockRenderLayer.SOLID || layer == BlockRenderLayer.CUTOUT;
            }
        };
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    public void setPowerInput(int powered) {
        boolean changed = this.powerLevel != powered;
        super.setPowerInput(powered);
        if (changed) {
            this.markDirtyClient();
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.itemHandler.ifPresent(itemHandler -> this.energyHandler.ifPresent(energy -> {
                this.markDirtyQuick();
                this.handleChargingItem((IItemHandler)itemHandler, (GenericEnergyStorage)energy);
                this.handleSendingEnergy((GenericEnergyStorage)energy);
                if (!this.isMachineEnabled()) {
                    return;
                }
                if (this.burning > 0) {
                    --this.burning;
                    long rf = this.getRfPerTick();
                    energy.produceEnergy(rf);
                } else if (!itemHandler.getStackInSlot(0).func_190926_b()) {
                    ItemStack extracted = itemHandler.extractItem(0, 1, false);
                    this.burning = (Integer)CoalGeneratorConfig.TICKSPERCOAL.get();
                    if (extracted.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150402_ci)) {
                        this.burning *= 9;
                    }
                    float factor = ((Float)this.infusableHandler.map(inf -> Float.valueOf(inf.getInfusedFactor())).orElse((Object)Float.valueOf(0.0f))).floatValue();
                    this.burning += (int)((float)this.burning * factor / 2.0f);
                }
            }));
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (((Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208190_q)).booleanValue() != this.isWorking()) {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(this.isWorking())), 3);
            }
        }
    }

    public long getRfPerTick() {
        long rf = ((Integer)CoalGeneratorConfig.RFPERTICK.get()).intValue();
        float factor = ((Float)this.infusableHandler.map(inf -> Float.valueOf(inf.getInfusedFactor())).orElse((Object)Float.valueOf(0.0f))).floatValue();
        rf += (long)((float)rf * factor);
        return rf;
    }

    public boolean isWorking() {
        return this.burning > 0 && this.isMachineEnabled();
    }

    private void handleChargingItem(IItemHandler handler, GenericEnergyStorage storage) {
        ItemStack stack = handler.getStackInSlot(1);
        if (!stack.func_190926_b()) {
            long storedPower = storage.getEnergy();
            long rfToGive = Math.min((long)((Integer)CoalGeneratorConfig.CHARGEITEMPERTICK.get()).intValue(), storedPower);
            long received = EnergyTools.receiveEnergy((ItemStack)stack, (long)rfToGive);
            storage.consumeEnergy(received);
        }
    }

    private void handleSendingEnergy(GenericEnergyStorage storage) {
        long storedPower = storage.getEnergy();
        for (Direction facing : OrientationTools.DIRECTION_VALUES) {
            Direction opposite;
            BlockPos p = this.field_174879_c.func_177972_a(facing);
            TileEntity te = this.field_145850_b.func_175625_s(p);
            if (!EnergyTools.isEnergyTE((TileEntity)te, (Direction)(opposite = facing.func_176734_d()))) continue;
            long rfToGive = Math.min((long)((Integer)CoalGeneratorConfig.SENDPERTICK.get()).intValue(), storedPower);
            long received = EnergyTools.receiveEnergy((TileEntity)te, (Direction)opposite, (long)rfToGive);
            storage.consumeEnergy(received);
            storedPower = storage.getEnergy();
            if (storedPower <= 0L) break;
        }
    }

    public void func_145839_a(CompoundNBT tagCompound) {
        super.func_145839_a(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.burning = info.func_74762_e("burning");
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        CompoundNBT infoTag = this.getOrCreateInfo(tagCompound);
        infoTag.func_74768_a("burning", this.burning);
        return tagCompound;
    }

    public boolean execute(PlayerEntity playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_RSMODE.equals(command)) {
            this.setRSMode(RedstoneMode.values()[(Integer)params.get(ImageChoiceLabel.PARAM_CHOICE_IDX)]);
            return true;
        }
        return false;
    }

    private IPowerInformation createPowerInfo() {
        return new IPowerInformation(){

            public long getEnergyDiffPerTick() {
                return CoalGeneratorTileEntity.this.burning > 0 ? CoalGeneratorTileEntity.this.getRfPerTick() : 0L;
            }

            @Nullable
            public String getEnergyUnitName() {
                return "RF";
            }

            public boolean isMachineActive() {
                return CoalGeneratorTileEntity.this.isMachineEnabled();
            }

            public boolean isMachineRunning() {
                return CoalGeneratorTileEntity.this.isMachineEnabled();
            }

            @Nullable
            public String getMachineStatus() {
                return CoalGeneratorTileEntity.this.burning > 0 ? "generating power" : "idle";
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyHandler.cast();
        }
        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        if (cap == CapabilityInfusable.INFUSABLE_CAPABILITY) {
            return this.infusableHandler.cast();
        }
        if (cap == CapabilityPowerInformation.POWER_INFORMATION_CAPABILITY) {
            return this.powerInfoHandler.cast();
        }
        return super.getCapability(cap, facing);
    }
}

