/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.render;

import com.mojang.blaze3d.platform.GlStateManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.entity.model.GenericHeadModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.tileentity.TileEntityWritableGrave;

@OnlyIn(value=Dist.CLIENT)
public class RenderWritableGrave<T extends TileEntityWritableGrave>
extends TileEntityRenderer<T> {
    private static final ResourceLocation TEXTURE_SKELETON_HEAD = new ResourceLocation("minecraft", "textures/entity/skeleton/skeleton.png");
    private final GenericHeadModel skeletonHead = new GenericHeadModel(0, 0, 64, 32);

    public void render(T te, double x, double y, double z, float partialTicks, int destroyStage) {
        int rotationIndex;
        float modY;
        float value;
        boolean renderHalloween;
        if (te == null || te.func_145831_w() == null) {
            return;
        }
        boolean bl = renderHalloween = ConfigTombstone.client.graveSkinRule.get() == ConfigTombstone.Client.GraveSkinRule.FORCE_HALLOWEEN || Helper.isDateAroundHalloween() && ConfigTombstone.client.graveSkinRule.get() != ConfigTombstone.Client.GraveSkinRule.FORCE_NORMAL;
        if (!((TileEntityWritableGrave)((Object)te)).hasOwner() && !renderHalloween) {
            return;
        }
        BlockState knownState = te.func_145831_w().func_180495_p(te.func_174877_v());
        if (!(knownState.func_177230_c() instanceof BlockGraveBase)) {
            return;
        }
        Direction facing = (Direction)knownState.func_177229_b((IProperty)BlockGraveBase.FACING);
        BlockGraveBase grave = (BlockGraveBase)knownState.func_177230_c();
        if (renderHalloween) {
            GlStateManager.enableRescaleNormal();
            GlStateManager.pushMatrix();
            GlStateManager.disableCull();
            GlStateManager.enableAlphaTest();
            float modX = 0.5f;
            float modY2 = 0.07f;
            float modZ = 0.5f;
            switch (grave.getGraveType()) {
                case GRAVE_NORMAL: {
                    modY2 += 0.35f;
                    break;
                }
                case GRAVE_CROSS: {
                    if (facing == Direction.SOUTH) {
                        modZ -= 0.3f;
                        modX -= 0.4f;
                        break;
                    }
                    if (facing == Direction.WEST) {
                        modX += 0.3f;
                        modZ -= 0.4f;
                        break;
                    }
                    if (facing == Direction.EAST) {
                        modX -= 0.3f;
                        modZ += 0.4f;
                        break;
                    }
                    modZ += 0.3f;
                    modX += 0.4f;
                    break;
                }
                case TOMBSTONE: {
                    modY2 += 0.6f;
                    break;
                }
                case SUBARAKI_GRAVE: {
                    modY2 += 0.37f;
                    if (facing == Direction.SOUTH) {
                        modX += 0.2f;
                        modZ += 0.2f;
                        break;
                    }
                    if (facing == Direction.WEST) {
                        modX -= 0.2f;
                        modZ += 0.2f;
                        break;
                    }
                    if (facing == Direction.EAST) {
                        modX += 0.2f;
                        modZ -= 0.2f;
                        break;
                    }
                    modX -= 0.2f;
                    modZ -= 0.2f;
                    break;
                }
                default: {
                    modY2 += 0.1f;
                }
            }
            this.func_147499_a(TEXTURE_SKELETON_HEAD);
            GlStateManager.translatef((float)((float)x + modX), (float)((float)y + modY2), (float)((float)z + modZ));
            GlStateManager.rotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.rotatef((float)facing.func_185119_l(), (float)0.0f, (float)1.0f, (float)0.0f);
            if (grave.getGraveType() == GraveModel.GRAVE_NORMAL || grave.getGraveType() == GraveModel.GRAVE_SIMPLE) {
                GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.scalef((float)0.2f, (float)0.2f, (float)0.2f);
                Minecraft.func_71410_x().func_175599_af().func_181564_a(new ItemStack((IItemProvider)(Helper.isNight(te.func_145831_w()) ? Blocks.field_196628_cT : Blocks.field_150423_aK)), ItemCameraTransforms.TransformType.NONE);
            } else {
                this.skeletonHead.func_217104_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.015625f);
            }
            GlStateManager.popMatrix();
        }
        if (!((TileEntityWritableGrave)((Object)te)).hasOwner()) {
            return;
        }
        float modX = 0.5f;
        float modZ = 0.5f;
        switch (grave.getGraveType()) {
            case GRAVE_CROSS: {
                value = 0.25f;
                modY = 0.06375f;
                break;
            }
            case GRAVE_NORMAL: {
                value = 0.12625f;
                modY = 0.5f;
                break;
            }
            case TOMBSTONE: {
                value = 0.56375f;
                modY = 0.25f;
                break;
            }
            case SUBARAKI_GRAVE: {
                value = 0.64f;
                modY = 0.65f;
                break;
            }
            default: {
                value = 0.18875f;
                modY = 0.4f;
            }
        }
        boolean is_cross = grave.getGraveType() == GraveModel.GRAVE_CROSS;
        switch (facing) {
            case SOUTH: {
                rotationIndex = 0;
                if (is_cross) {
                    modZ = 1.0f - value;
                    break;
                }
                modZ = value;
                break;
            }
            case WEST: {
                rotationIndex = -1;
                if (is_cross) {
                    modX = value;
                    break;
                }
                modX = 1.0f - value;
                break;
            }
            case EAST: {
                rotationIndex = 1;
                if (is_cross) {
                    modX = 1.0f - value;
                    break;
                }
                modX = value;
                break;
            }
            default: {
                rotationIndex = 2;
                modZ = is_cross ? value : 1.0f - value;
            }
        }
        GlStateManager.enableRescaleNormal();
        GlStateManager.pushMatrix();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.disableLighting();
        GlStateManager.translatef((float)((float)x + modX), (float)((float)y + modY), (float)((float)z + modZ));
        GlStateManager.rotatef((float)(90.0f * (float)rotationIndex), (float)0.0f, (float)1.0f, (float)0.0f);
        if (is_cross) {
            GlStateManager.rotatef((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
        }
        GlStateManager.depthMask((boolean)false);
        FontRenderer fontRender = this.func_147498_b();
        GlStateManager.pushMatrix();
        float scale = 0.007f;
        GlStateManager.scalef((float)scale, (float)(-scale), (float)scale);
        this.showString(TextFormatting.BOLD + LangKey.MESSAGE_RIP.getClientTranslation(new Object[0]), fontRender, 0, (Integer)ConfigTombstone.client.textColorRIP.get() + -16777216);
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        scale = 0.005f;
        GlStateManager.scalef((float)scale, (float)(-scale), (float)scale);
        this.showString(TextFormatting.BOLD + ((TileEntityWritableGrave)((Object)te)).getOwnerName(), fontRender, 11, (Integer)ConfigTombstone.client.textColorOwner.get() + -16777216);
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        scale = (Boolean)ConfigTombstone.client.dateInMCTime.get() != false ? 0.005f : 0.004f;
        GlStateManager.scalef((float)scale, (float)(-scale), (float)scale);
        int textColorDeathDate = (Integer)ConfigTombstone.client.textColorDeathDate.get() + -16777216;
        this.showString(TextFormatting.BOLD + LangKey.MESSAGE_DIED_ON.getClientTranslation(new Object[0]), fontRender, 26, textColorDeathDate);
        if (((Boolean)ConfigTombstone.client.dateInMCTime.get()).booleanValue()) {
            long days = ((TileEntityWritableGrave)((Object)te)).countTicks / 24000;
            String dateString = LangKey.MESSAGE_DAY.getClientTranslation(days);
            this.showString(TextFormatting.BOLD + dateString, fontRender, 36, textColorDeathDate);
        } else {
            Date date = new Date(((TileEntityWritableGrave)((Object)te)).getOwnerDeathTime());
            String dateString = new SimpleDateFormat("dd/MM/yyyy").format(date);
            String timeString = LangKey.MESSAGE_AT.getClientTranslation(new Object[0]) + " " + new SimpleDateFormat("HH:mm:ss").format(date);
            this.showString(TextFormatting.BOLD + dateString, fontRender, 36, textColorDeathDate);
            this.showString(TextFormatting.BOLD + timeString, fontRender, 46, textColorDeathDate);
        }
        GlStateManager.popMatrix();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.popMatrix();
        GlStateManager.enableLighting();
    }

    private void showString(String content, FontRenderer fontRenderer, int posY, int color) {
        fontRenderer.func_211126_b(content, (float)(-fontRenderer.func_78256_a(content)) / 2.0f, (float)(posY - 30), color);
    }
}

