/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemGeneric;

public class ItemLollipop
extends ItemGeneric {
    private final ModelColor color;

    public ItemLollipop(ModelColor color) {
        super("lollipop", new Item.Properties().func_200916_a(null).func_200917_a(64).func_221540_a(new Food.Builder().func_221456_a(2).func_221454_a(2.0f).func_221455_b().func_221453_d()));
        this.color = color;
    }

    @Override
    public String getSimpleName() {
        return this.name + "_" + this.color.ordinal();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip(world, stack)) {
            list.add(LangKey.makeTranslationWithStyle(StyleType.TOOLTIP_DESC, this.func_77667_c(stack) + ".desc", new Object[0]));
        } else {
            list.add(LangKey.TOOLTIP_MORE_INFO.getTranslationWithStyle(StyleType.TOOLTIP_DESC));
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entity) {
        super.func_77654_b(stack, world, entity);
        if (entity instanceof ServerPlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            Helper.addRandomEffect(player, 12000, true);
        }
        return stack;
    }

    @Override
    public String func_77658_a() {
        return "tombstone.item." + this.name;
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    public static enum ModelColor {
        YELLOW,
        PURPLE,
        GREEN,
        MAGENTA,
        RED;

    }
}

