/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ISmartVariant;
import net.minecraftforge.common.model.IModelState;

@OnlyIn(value=Dist.CLIENT)
public class Variant
implements ISprite,
ISmartVariant {
    private final ResourceLocation field_188050_a;
    private final ModelRotation field_188051_b;
    private final boolean field_188052_c;
    private final int field_188053_d;

    public Variant(ResourceLocation modelLocationIn, ModelRotation rotationIn, boolean uvLockIn, int weightIn) {
        this.field_188050_a = modelLocationIn;
        this.field_188051_b = rotationIn;
        this.field_188052_c = uvLockIn;
        this.field_188053_d = weightIn;
    }

    public ResourceLocation func_188046_a() {
        return this.field_188050_a;
    }

    @Override
    @Deprecated
    public ModelRotation func_188048_b() {
        return this.field_188051_b;
    }

    @Override
    public IModelState getState() {
        return this.field_188051_b;
    }

    @Override
    public boolean func_188049_c() {
        return this.field_188052_c;
    }

    public int func_188047_d() {
        return this.field_188053_d;
    }

    public String toString() {
        return "Variant{modelLocation=" + this.field_188050_a + ", rotation=" + this.field_188051_b + ", uvLock=" + this.field_188052_c + ", weight=" + this.field_188053_d + '}';
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof Variant)) {
            return false;
        }
        Variant variant = (Variant)p_equals_1_;
        return this.field_188050_a.equals((Object)variant.field_188050_a) && this.field_188051_b == variant.field_188051_b && this.field_188052_c == variant.field_188052_c && this.field_188053_d == variant.field_188053_d;
    }

    public int hashCode() {
        int i = this.field_188050_a.hashCode();
        i = 31 * i + this.field_188051_b.hashCode();
        i = 31 * i + Boolean.valueOf(this.field_188052_c).hashCode();
        i = 31 * i + this.field_188053_d;
        return i;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Deserializer
    implements JsonDeserializer<Variant> {
        public Variant deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            JsonObject jsonobject = p_deserialize_1_.getAsJsonObject();
            ResourceLocation resourcelocation = this.func_188043_b(jsonobject);
            ModelRotation modelrotation = this.func_188042_a(jsonobject);
            boolean flag = this.func_188044_d(jsonobject);
            int i = this.func_188045_c(jsonobject);
            return new Variant(resourcelocation, modelrotation, flag, i);
        }

        private boolean func_188044_d(JsonObject json) {
            return JSONUtils.func_151209_a((JsonObject)json, (String)"uvlock", (boolean)false);
        }

        protected ModelRotation func_188042_a(JsonObject json) {
            int j;
            int i = JSONUtils.func_151208_a((JsonObject)json, (String)"x", (int)0);
            ModelRotation modelrotation = ModelRotation.func_177524_a(i, j = JSONUtils.func_151208_a((JsonObject)json, (String)"y", (int)0));
            if (modelrotation == null) {
                throw new JsonParseException("Invalid BlockModelRotation x: " + i + ", y: " + j);
            }
            return modelrotation;
        }

        protected ResourceLocation func_188043_b(JsonObject json) {
            return new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"model"));
        }

        protected int func_188045_c(JsonObject json) {
            int i = JSONUtils.func_151208_a((JsonObject)json, (String)"weight", (int)1);
            if (i < 1) {
                throw new JsonParseException("Invalid weight " + i + " found, expected integer >= 1");
            }
            return i;
        }
    }
}

