/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;

@OnlyIn(value=Dist.CLIENT)
public abstract class ArmorLayer<T extends LivingEntity, M extends BipedModel<T>, A extends BipedModel<T>>
extends LayerRenderer<T, M> {
    protected static final ResourceLocation field_177188_b = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    protected final A field_177189_c;
    protected final A field_177186_d;
    private float field_177187_e = 1.0f;
    private float field_177184_f = 1.0f;
    private float field_177185_g = 1.0f;
    private float field_177192_h = 1.0f;
    private boolean field_177193_i;
    private static final Map<String, ResourceLocation> field_177191_j = Maps.newHashMap();

    protected ArmorLayer(IEntityRenderer<T, M> p_i50951_1_, A p_i50951_2_, A p_i50951_3_) {
        super(p_i50951_1_);
        this.field_177189_c = p_i50951_2_;
        this.field_177186_d = p_i50951_3_;
    }

    public void func_212842_a_(T entityIn, float p_212842_2_, float p_212842_3_, float p_212842_4_, float p_212842_5_, float p_212842_6_, float p_212842_7_, float p_212842_8_) {
        this.func_188361_a(entityIn, p_212842_2_, p_212842_3_, p_212842_4_, p_212842_5_, p_212842_6_, p_212842_7_, p_212842_8_, EquipmentSlotType.CHEST);
        this.func_188361_a(entityIn, p_212842_2_, p_212842_3_, p_212842_4_, p_212842_5_, p_212842_6_, p_212842_7_, p_212842_8_, EquipmentSlotType.LEGS);
        this.func_188361_a(entityIn, p_212842_2_, p_212842_3_, p_212842_4_, p_212842_5_, p_212842_6_, p_212842_7_, p_212842_8_, EquipmentSlotType.FEET);
        this.func_188361_a(entityIn, p_212842_2_, p_212842_3_, p_212842_4_, p_212842_5_, p_212842_6_, p_212842_7_, p_212842_8_, EquipmentSlotType.HEAD);
    }

    public boolean func_177142_b() {
        return false;
    }

    private void func_188361_a(T entityLivingBaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale, EquipmentSlotType slotIn) {
        ArmorItem armoritem;
        ItemStack itemstack = ((LivingEntity)((Object)entityLivingBaseIn)).func_184582_a(slotIn);
        if (itemstack.func_77973_b() instanceof ArmorItem && (armoritem = (ArmorItem)itemstack.func_77973_b()).func_185083_B_() == slotIn) {
            A a = this.func_215337_a(slotIn);
            a = this.getArmorModelHook((LivingEntity)((Object)entityLivingBaseIn), itemstack, slotIn, a);
            ((BipedModel)this.func_215332_c()).func_217148_a(a);
            a.func_212843_a_(entityLivingBaseIn, limbSwing, limbSwingAmount, partialTicks);
            this.func_188359_a(a, slotIn);
            boolean flag = this.func_188363_b(slotIn);
            this.func_215333_a(this.getArmorResource((Entity)((Object)entityLivingBaseIn), itemstack, slotIn, null));
            if (armoritem instanceof IDyeableArmorItem) {
                int i = ((IDyeableArmorItem)armoritem).func_200886_f(itemstack);
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                GlStateManager.color4f((float)(this.field_177184_f * f), (float)(this.field_177185_g * f1), (float)(this.field_177192_h * f2), (float)this.field_177187_e);
                a.func_78088_a(entityLivingBaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                this.func_215333_a(this.getArmorResource((Entity)((Object)entityLivingBaseIn), itemstack, slotIn, "overlay"));
            }
            GlStateManager.color4f((float)this.field_177184_f, (float)this.field_177185_g, (float)this.field_177192_h, (float)this.field_177187_e);
            a.func_78088_a(entityLivingBaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            if (!this.field_177193_i && itemstack.func_77962_s()) {
                ArmorLayer.func_215338_a(arg_0 -> ((ArmorLayer)this).func_215333_a(arg_0), entityLivingBaseIn, a, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
            }
        }
    }

    public A func_215337_a(EquipmentSlotType p_215337_1_) {
        return this.func_188363_b(p_215337_1_) ? this.field_177189_c : this.field_177186_d;
    }

    private boolean func_188363_b(EquipmentSlotType slotIn) {
        return slotIn == EquipmentSlotType.LEGS;
    }

    public static <T extends Entity> void func_215338_a(Consumer<ResourceLocation> p_215338_0_, T p_215338_1_, EntityModel<T> p_215338_2_, float p_215338_3_, float p_215338_4_, float p_215338_5_, float p_215338_6_, float p_215338_7_, float p_215338_8_, float p_215338_9_) {
        float f = (float)p_215338_1_.field_70173_aa + p_215338_5_;
        p_215338_0_.accept(field_177188_b);
        GameRenderer gamerenderer = Minecraft.func_71410_x().field_71460_t;
        gamerenderer.func_191514_d(true);
        GlStateManager.enableBlend();
        GlStateManager.depthFunc((int)514);
        GlStateManager.depthMask((boolean)false);
        float f1 = 0.5f;
        GlStateManager.color4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        for (int i = 0; i < 2; ++i) {
            GlStateManager.disableLighting();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            float f2 = 0.76f;
            GlStateManager.color4f((float)0.38f, (float)0.19f, (float)0.608f, (float)1.0f);
            GlStateManager.matrixMode((int)5890);
            GlStateManager.loadIdentity();
            float f3 = 0.33333334f;
            GlStateManager.scalef((float)0.33333334f, (float)0.33333334f, (float)0.33333334f);
            GlStateManager.rotatef((float)(30.0f - (float)i * 60.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.translatef((float)0.0f, (float)(f * (0.001f + (float)i * 0.003f) * 20.0f), (float)0.0f);
            GlStateManager.matrixMode((int)5888);
            p_215338_2_.func_78088_a(p_215338_1_, p_215338_3_, p_215338_4_, p_215338_6_, p_215338_7_, p_215338_8_, p_215338_9_);
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }
        GlStateManager.matrixMode((int)5890);
        GlStateManager.loadIdentity();
        GlStateManager.matrixMode((int)5888);
        GlStateManager.enableLighting();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.depthFunc((int)515);
        GlStateManager.disableBlend();
        gamerenderer.func_191514_d(false);
    }

    @Deprecated
    private ResourceLocation func_177181_a(ArmorItem armor, boolean p_177181_2_) {
        return this.func_177178_a(armor, p_177181_2_, null);
    }

    @Deprecated
    private ResourceLocation func_177178_a(ArmorItem armor, boolean p_177178_2_, @Nullable String p_177178_3_) {
        String s = "textures/models/armor/" + armor.func_200880_d().func_200897_d() + "_layer_" + (p_177178_2_ ? 2 : 1) + (p_177178_3_ == null ? "" : "_" + p_177178_3_) + ".png";
        return field_177191_j.computeIfAbsent(s, ResourceLocation::new);
    }

    protected A getArmorModelHook(LivingEntity entity, ItemStack itemStack, EquipmentSlotType slot, A model) {
        return model;
    }

    public ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlotType slot, @Nullable String type) {
        ArmorItem item = (ArmorItem)stack.func_77973_b();
        String texture = item.func_200880_d().func_200897_d();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, this.func_188363_b(slot) ? 2 : 1, type == null ? "" : String.format("_%s", type));
        ResourceLocation resourcelocation = field_177191_j.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlotType)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            field_177191_j.put(s1, resourcelocation);
        }
        return resourcelocation;
    }

    protected abstract void func_188359_a(A var1, EquipmentSlotType var2);

    protected abstract void func_177194_a(A var1);
}

