/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.collect.Multimap;
import com.google.common.collect.Queues;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.datafixers.DataFixer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.SocketAddress;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.GameConfiguration;
import net.minecraft.client.GameSettings;
import net.minecraft.client.KeyboardListener;
import net.minecraft.client.MainWindow;
import net.minecraft.client.MinecraftGame;
import net.minecraft.client.MouseHelper;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.gui.LoadingGui;
import net.minecraft.client.gui.ResourceLoadProgressGui;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.advancements.AdvancementsScreen;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.fonts.FontResourceManager;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.ConnectingScreen;
import net.minecraft.client.gui.screen.DeathScreen;
import net.minecraft.client.gui.screen.DirtMessageScreen;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.MemoryErrorScreen;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.SleepInMultiplayerScreen;
import net.minecraft.client.gui.screen.WinGameScreen;
import net.minecraft.client.gui.screen.WorkingScreen;
import net.minecraft.client.gui.screen.WorldLoadProgressScreen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.toasts.ToastGui;
import net.minecraft.client.multiplayer.PlayerController;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.network.login.ClientLoginNetHandler;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.GlDebugTextUtils;
import net.minecraft.client.renderer.IWindowEventListener;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.ScreenSize;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VirtualScreen;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.chunk.ChunkRender;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.PaintingSpriteUploader;
import net.minecraft.client.renderer.texture.PotionSpriteUploader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.ClientResourcePackInfo;
import net.minecraft.client.resources.DownloadingPackFinder;
import net.minecraft.client.resources.FoliageColorReloadListener;
import net.minecraft.client.resources.GrassColorReloadListener;
import net.minecraft.client.resources.LanguageManager;
import net.minecraft.client.resources.LegacyResourcePackWrapper;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.client.settings.AbstractOption;
import net.minecraft.client.settings.AmbientOcclusionStatus;
import net.minecraft.client.settings.CloudOption;
import net.minecraft.client.settings.CreativeSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.tutorial.Tutorial;
import net.minecraft.client.util.IMutableSearchTree;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.SearchTree;
import net.minecraft.client.util.SearchTreeManager;
import net.minecraft.client.util.SearchTreeReloadable;
import net.minecraft.client.util.Splashes;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ChatVisibility;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SkullItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.INetHandler;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.ProtocolType;
import net.minecraft.network.handshake.client.CHandshakePacket;
import net.minecraft.network.login.client.CLoginStartPacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.profiler.DataPoint;
import net.minecraft.profiler.DebugProfiler;
import net.minecraft.profiler.IProfileResult;
import net.minecraft.profiler.IProfiler;
import net.minecraft.profiler.ISnooperInfo;
import net.minecraft.profiler.Snooper;
import net.minecraft.resources.FolderPackFinder;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.Direction;
import net.minecraft.util.FrameTimer;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Session;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Timer;
import net.minecraft.util.Unit;
import net.minecraft.util.Util;
import net.minecraft.util.concurrent.RecursiveEventLoop;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.registry.Bootstrap;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.KeybindTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.listener.ChainedChunkStatusListener;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.chunk.listener.TrackingChunkStatusListener;
import net.minecraft.world.dimension.EndDimension;
import net.minecraft.world.dimension.NetherDimension;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.ForgeIngameGui;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.StartupQuery;
import net.minecraftforge.fml.client.ClientHooks;
import net.minecraftforge.fml.client.ClientModLoader;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class Minecraft
extends RecursiveEventLoop<Runnable>
implements ISnooperInfo,
IWindowEventListener,
AutoCloseable {
    private static final Logger field_147123_G = LogManager.getLogger();
    public static final boolean field_142025_a = Util.func_110647_a() == Util.OS.OSX;
    public static final ResourceLocation field_211502_b = new ResourceLocation("default");
    public static final ResourceLocation field_71464_q = new ResourceLocation("alt");
    private static final CompletableFuture<Unit> field_223714_G = CompletableFuture.completedFuture(Unit.INSTANCE);
    public static byte[] field_71444_a = new byte[0xA00000];
    private static int field_211120_F = -1;
    private final File field_130070_K;
    private final PropertyMap field_181038_N;
    private final ScreenSize field_195556_O;
    private ServerData field_71422_O;
    public TextureManager field_71446_o;
    private static Minecraft field_71432_P;
    private final DataFixer field_184131_U;
    public PlayerController field_71442_b;
    private VirtualScreen field_195557_T;
    public MainWindow field_195558_d;
    private boolean field_71434_R;
    private CrashReport field_71433_S;
    private boolean field_181541_X;
    private final Timer field_71428_T = new Timer(20.0f, 0L);
    private final Snooper field_71427_U = new Snooper("client", (ISnooperInfo)this, Util.func_211177_b());
    public ClientWorld field_71441_e;
    public WorldRenderer field_71438_f;
    private EntityRendererManager field_175616_W;
    private ItemRenderer field_175621_X;
    private FirstPersonRenderer field_175620_Y;
    public ClientPlayerEntity field_71439_g;
    @Nullable
    public Entity field_175622_Z;
    @Nullable
    public Entity field_147125_j;
    public ParticleManager field_71452_i;
    private final SearchTreeManager field_193995_ae = new SearchTreeManager();
    private final Session field_71449_j;
    private boolean field_71445_n;
    private float field_193996_ah;
    public FontRenderer field_71466_p;
    @Nullable
    public Screen field_71462_r;
    @Nullable
    public LoadingGui field_213279_p;
    public GameRenderer field_71460_t;
    public DebugRenderer field_184132_p;
    protected int field_71429_W;
    @Nullable
    private IntegratedServer field_71437_Z;
    private final AtomicReference<TrackingChunkStatusListener> field_213277_ad = new AtomicReference();
    public IngameGui field_71456_v;
    public boolean field_71454_w;
    public RayTraceResult field_71476_x;
    public GameSettings field_71474_y;
    private CreativeSettings field_191950_u;
    public MouseHelper field_71417_B;
    public KeyboardListener field_195559_v;
    public final File field_71412_D;
    private final File field_110446_Y;
    private final String field_110447_Z;
    private final String field_184130_ao;
    private final Proxy field_110453_aa;
    private SaveFormat field_71469_aa;
    private static int field_71470_ab;
    private int field_71467_ac;
    private String field_71475_ae;
    private int field_71477_af;
    public final FrameTimer field_181542_y = new FrameTimer();
    private long field_181543_z = Util.func_211178_c();
    private final boolean field_147129_ai;
    private final boolean field_71459_aj;
    @Nullable
    private NetworkManager field_71453_ak;
    private boolean field_71455_al;
    private final DebugProfiler field_71424_I = new DebugProfiler(() -> this.field_71428_T.field_74280_b);
    private IReloadableResourceManager field_110451_am;
    private final DownloadingPackFinder field_195554_ax;
    private final ResourcePackList<ClientResourcePackInfo> field_110448_aq;
    private LanguageManager field_135017_as;
    private BlockColors field_184127_aH;
    private ItemColors field_184128_aI;
    private Framebuffer field_147124_at;
    private AtlasTexture field_147128_au;
    private SoundHandler field_147127_av;
    private MusicTicker field_147126_aw;
    private FontResourceManager field_211501_aD;
    private Splashes field_213271_aF;
    private final MinecraftSessionService field_152355_az;
    private SkinManager field_152350_aA;
    private final Thread field_152352_aC = Thread.currentThread();
    private ModelManager field_175617_aL;
    private BlockRendererDispatcher field_175618_aM;
    private PaintingSpriteUploader field_213272_aL;
    private PotionSpriteUploader field_213273_aM;
    private final ToastGui field_193034_aS;
    private final MinecraftGame field_213274_aO = new MinecraftGame(this);
    private volatile boolean field_71425_J = true;
    public String field_71426_K = "";
    public boolean field_175612_E = true;
    private long field_71419_L;
    private int field_71420_M;
    private final Tutorial field_193035_aW;
    private boolean field_195555_I;
    private final Queue<Runnable> field_213275_aU = Queues.newConcurrentLinkedQueue();
    private CompletableFuture<Void> field_213276_aV;
    private String field_71465_an = "root";

    public Minecraft(GameConfiguration gameConfig) {
        super("Client");
        this.field_195556_O = gameConfig.field_178743_b;
        field_71432_P = this;
        ForgeHooksClient.invalidateLog4jThreadCache();
        this.field_71412_D = gameConfig.field_178744_c.field_178760_a;
        this.field_110446_Y = gameConfig.field_178744_c.field_178759_c;
        this.field_130070_K = gameConfig.field_178744_c.field_178758_b;
        this.field_110447_Z = gameConfig.field_178741_d.field_178755_b;
        this.field_184130_ao = gameConfig.field_178741_d.field_187053_c;
        this.field_181038_N = gameConfig.field_178745_a.field_181172_c;
        this.field_195554_ax = new DownloadingPackFinder(new File(this.field_71412_D, "server-resource-packs"), gameConfig.field_178744_c.func_187052_a());
        this.field_110448_aq = new ResourcePackList((p_213262_0_, p_213262_1_, p_213262_2_, p_213262_3_, p_213262_4_, p_213262_5_) -> {
            Supplier<IResourcePack> supplier = p_213262_4_.func_198962_b() < SharedConstants.func_215069_a().getPackVersion() ? () -> Minecraft.lambda$null$1((Supplier)p_213262_2_) : p_213262_2_;
            return new ClientResourcePackInfo(p_213262_0_, p_213262_1_, supplier, p_213262_3_, p_213262_4_, p_213262_5_, p_213262_3_.isHidden());
        });
        this.field_110448_aq.func_198982_a((IPackFinder)this.field_195554_ax);
        this.field_110448_aq.func_198982_a((IPackFinder)new FolderPackFinder(this.field_130070_K));
        this.field_110453_aa = gameConfig.field_178745_a.field_178751_c == null ? Proxy.NO_PROXY : gameConfig.field_178745_a.field_178751_c;
        this.field_152355_az = new YggdrasilAuthenticationService(this.field_110453_aa, UUID.randomUUID().toString()).createMinecraftSessionService();
        this.field_71449_j = gameConfig.field_178745_a.field_178752_a;
        field_147123_G.info("Setting user: {}", (Object)this.field_71449_j.func_111285_a());
        this.field_71459_aj = gameConfig.field_178741_d.field_178756_a;
        this.field_147129_ai = Minecraft.func_147122_X();
        this.field_71437_Z = null;
        if (gameConfig.field_178742_e.field_178754_a != null) {
            this.field_71475_ae = gameConfig.field_178742_e.field_178754_a;
            this.field_71477_af = gameConfig.field_178742_e.field_178753_b;
        }
        Bootstrap.func_151354_b();
        Bootstrap.func_218821_c();
        KeybindTextComponent.field_193637_b = KeyBinding::func_193626_b;
        this.field_184131_U = DataFixesManager.func_210901_a();
        this.field_193034_aS = new ToastGui(this);
        this.field_193035_aW = new Tutorial(this);
    }

    public void func_99999_d() {
        this.field_71425_J = true;
        try {
            this.func_71384_a();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Initializing game");
            crashreport.func_85058_a("Initialization");
            this.func_71377_b(this.func_71396_d(crashreport));
            return;
        }
        try {
            boolean flag = false;
            while (this.field_71425_J) {
                if (this.field_71434_R && this.field_71433_S != null) {
                    this.func_71377_b(this.field_71433_S);
                    return;
                }
                try {
                    this.func_195542_b(!flag);
                }
                catch (OutOfMemoryError outofmemoryerror) {
                    if (flag) {
                        throw outofmemoryerror;
                    }
                    this.func_71398_f();
                    this.func_147108_a((Screen)new MemoryErrorScreen());
                    System.gc();
                    field_147123_G.fatal("Out of memory", (Throwable)outofmemoryerror);
                    flag = true;
                }
            }
            return;
        }
        catch (ReportedException reportedexception) {
            this.func_71396_d(reportedexception.func_71575_a());
            this.func_71398_f();
            field_147123_G.fatal("Reported exception thrown!", (Throwable)reportedexception);
            this.func_71377_b(reportedexception.func_71575_a());
        }
        catch (Throwable throwable1) {
            CrashReport crashreport1 = this.func_71396_d(new CrashReport("Unexpected error", throwable1));
            field_147123_G.fatal("Unreported exception thrown!", throwable1);
            this.func_71398_f();
            this.func_71377_b(crashreport1);
        }
        finally {
            this.func_71405_e();
        }
    }

    private void func_71384_a() {
        LongSupplier longsupplier;
        this.field_71474_y = new GameSettings(this, this.field_71412_D);
        this.field_191950_u = new CreativeSettings(this.field_71412_D, this.field_184131_U);
        this.func_71389_H();
        field_147123_G.info("LWJGL Version: {}", (Object)GLX.getLWJGLVersion());
        ScreenSize screensize = this.field_195556_O;
        if (this.field_71474_y.field_92119_C > 0 && this.field_71474_y.field_92118_B > 0) {
            screensize = new ScreenSize(this.field_71474_y.field_92118_B, this.field_71474_y.field_92119_C, screensize.field_216496_c, screensize.field_216497_d, screensize.field_216498_e);
        }
        if ((longsupplier = GLX.initGlfw()) != null) {
            Util.field_211180_a = longsupplier;
        }
        this.field_195557_T = new VirtualScreen(this);
        this.field_195558_d = this.field_195557_T.func_217626_a(screensize, this.field_71474_y.field_198019_u, "Minecraft " + SharedConstants.func_215069_a().getName());
        this.func_213228_a(true);
        try {
            InputStream inputstream = this.func_195541_I().func_195746_a().func_195761_a(ResourcePackType.CLIENT_RESOURCES, new ResourceLocation("icons/icon_16x16.png"));
            InputStream inputstream1 = this.func_195541_I().func_195746_a().func_195761_a(ResourcePackType.CLIENT_RESOURCES, new ResourceLocation("icons/icon_32x32.png"));
            this.field_195558_d.func_216529_a(inputstream, inputstream1);
        }
        catch (IOException ioexception) {
            field_147123_G.error("Couldn't set icon", (Throwable)ioexception);
        }
        this.field_195558_d.func_216526_a(this.field_71474_y.field_74350_i);
        this.field_71417_B = new MouseHelper(this);
        this.field_195559_v = new KeyboardListener(this);
        this.field_195559_v.func_197968_a(this.field_195558_d.func_198092_i());
        GLX.init();
        GlDebugTextUtils.func_209247_b((int)this.field_71474_y.field_209231_W, (boolean)false);
        this.field_147124_at = new Framebuffer(this.field_195558_d.func_198109_k(), this.field_195558_d.func_198091_l(), true, field_142025_a);
        this.field_147124_at.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
        this.field_110451_am = new SimpleReloadableResourceManager(ResourcePackType.CLIENT_RESOURCES, this.field_152352_aC);
        this.field_71474_y.func_198017_a(this.field_110448_aq);
        ClientModLoader.begin((Minecraft)this, this.field_110448_aq, (IReloadableResourceManager)this.field_110451_am, (DownloadingPackFinder)this.field_195554_ax);
        this.field_110448_aq.func_198983_a();
        List<IResourcePack> list = this.field_110448_aq.func_198980_d().stream().map(ResourcePackInfo::func_195796_e).collect(Collectors.toList());
        for (IResourcePack iresourcepack : list) {
            this.field_110451_am.func_199021_a(iresourcepack);
        }
        this.field_135017_as = new LanguageManager(this.field_71474_y.field_74363_ab);
        this.field_110451_am.func_219534_a(this.field_135017_as);
        this.field_135017_as.func_135043_a(list);
        this.field_71446_o = new TextureManager(this.field_110451_am);
        this.field_110451_am.func_219534_a(this.field_71446_o);
        this.func_213226_a();
        this.field_152350_aA = new SkinManager(this.field_71446_o, new File(this.field_110446_Y, "skins"), this.field_152355_az);
        this.field_71469_aa = new SaveFormat(this.field_71412_D.toPath().resolve("saves"), this.field_71412_D.toPath().resolve("backups"), this.field_184131_U);
        this.field_147127_av = new SoundHandler(this.field_110451_am, this.field_71474_y);
        this.field_110451_am.func_219534_a((IFutureReloadListener)this.field_147127_av);
        this.field_213271_aF = new Splashes(this.field_71449_j);
        this.field_110451_am.func_219534_a((IFutureReloadListener)this.field_213271_aF);
        this.field_147126_aw = new MusicTicker(this);
        this.field_211501_aD = new FontResourceManager(this.field_71446_o, this.func_211821_e());
        this.field_110451_am.func_219534_a(this.field_211501_aD.func_216884_a());
        this.field_71466_p = this.field_211501_aD.func_211504_a(field_211502_b);
        if (this.field_71474_y.field_74363_ab != null) {
            this.field_71466_p.func_78275_b(this.field_135017_as.func_135044_b());
        }
        this.field_110451_am.func_219534_a((IFutureReloadListener)new GrassColorReloadListener());
        this.field_110451_am.func_219534_a((IFutureReloadListener)new FoliageColorReloadListener());
        this.field_195558_d.func_198076_a("Startup");
        GlStateManager.enableTexture();
        GlStateManager.shadeModel((int)7425);
        GlStateManager.clearDepth((double)1.0);
        GlStateManager.enableDepthTest();
        GlStateManager.depthFunc((int)515);
        GlStateManager.enableAlphaTest();
        GlStateManager.alphaFunc((int)516, (float)0.1f);
        GlStateManager.cullFace((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.matrixMode((int)5889);
        GlStateManager.loadIdentity();
        GlStateManager.matrixMode((int)5888);
        this.field_195558_d.func_198076_a("Post startup");
        this.field_147128_au = new AtlasTexture("textures");
        this.field_147128_au.func_147633_a(this.field_71474_y.field_151442_I);
        this.field_71446_o.func_110580_a(AtlasTexture.field_110575_b, this.field_147128_au);
        this.field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        this.field_147128_au.func_174937_a(false, this.field_71474_y.field_151442_I > 0);
        this.field_184127_aH = BlockColors.func_186723_a();
        this.field_184128_aI = ItemColors.func_186729_a(this.field_184127_aH);
        this.field_175617_aL = new ModelManager(this.field_147128_au, this.field_184127_aH);
        this.field_110451_am.func_219534_a((IFutureReloadListener)this.field_175617_aL);
        this.field_175621_X = new ItemRenderer(this.field_71446_o, this.field_175617_aL, this.field_184128_aI);
        this.field_175616_W = new EntityRendererManager(this.field_71446_o, this.field_175621_X, this.field_110451_am);
        this.field_175620_Y = new FirstPersonRenderer(this);
        this.field_110451_am.func_219534_a(this.field_175621_X);
        this.field_71460_t = new GameRenderer(this, this.field_110451_am);
        this.field_110451_am.func_219534_a(this.field_71460_t);
        this.field_175618_aM = new BlockRendererDispatcher(this.field_175617_aL.func_174954_c(), this.field_184127_aH);
        this.field_110451_am.func_219534_a(this.field_175618_aM);
        this.field_71438_f = new WorldRenderer(this);
        this.field_110451_am.func_219534_a(this.field_71438_f);
        this.func_193986_ar();
        this.field_110451_am.func_219534_a(this.field_193995_ae);
        GlStateManager.viewport((int)0, (int)0, (int)this.field_195558_d.func_198109_k(), (int)this.field_195558_d.func_198091_l());
        this.field_71452_i = new ParticleManager(this.field_71441_e, this.field_71446_o);
        ModLoader.get().postEvent((Event)new ParticleFactoryRegisterEvent());
        this.field_110451_am.func_219534_a(this.field_71452_i);
        this.field_213272_aL = new PaintingSpriteUploader(this.field_71446_o);
        this.field_110451_am.func_219534_a((IFutureReloadListener)this.field_213272_aL);
        this.field_213273_aM = new PotionSpriteUploader(this.field_71446_o);
        this.field_110451_am.func_219534_a((IFutureReloadListener)this.field_213273_aM);
        this.field_71456_v = new ForgeIngameGui(this);
        this.field_71417_B.func_198029_a(this.field_195558_d.func_198092_i());
        this.field_184132_p = new DebugRenderer(this);
        GLX.setGlfwErrorCallback(this::func_195545_a);
        if (this.field_71474_y.field_74353_u && !this.field_195558_d.func_198113_j()) {
            this.field_195558_d.func_198077_g();
            this.field_71474_y.field_74353_u = this.field_195558_d.func_198113_j();
        }
        this.field_195558_d.func_216523_b(this.field_71474_y.field_74352_v);
        this.field_195558_d.func_224798_d(this.field_71474_y.field_225307_E);
        this.field_195558_d.func_198112_b();
        if (this.field_71475_ae != null) {
            this.func_147108_a((Screen)new ConnectingScreen((Screen)new MainMenuScreen(), this, this.field_71475_ae, this.field_71477_af));
        } else {
            this.func_147108_a(new MainMenuScreen(true));
        }
        ResourceLoadProgressGui.func_212970_a(this);
        this.func_213268_a(new ResourceLoadProgressGui(this, this.field_110451_am.func_219535_a(Util.func_215072_e(), (Executor)((Object)this), field_223714_G), () -> {
            if (SharedConstants.field_206244_b) {
                this.func_213256_aB();
            }
            ClientModLoader.complete();
        }, false));
    }

    public void func_193986_ar() {
        SearchTree searchtree = new SearchTree(p_213242_0_ -> p_213242_0_.func_82840_a(null, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL).stream().map(p_213230_0_ -> TextFormatting.func_110646_a((String)p_213230_0_.getString()).trim()).filter(p_213267_0_ -> !p_213267_0_.isEmpty()), p_213251_0_ -> Stream.of(Registry.field_212630_s.func_177774_c((Object)p_213251_0_.func_77973_b())));
        SearchTreeReloadable searchtreereloadable = new SearchTreeReloadable(p_213235_0_ -> p_213235_0_.func_77973_b().getTags().stream());
        NonNullList nonnulllist = NonNullList.func_191196_a();
        for (Item item : Registry.field_212630_s) {
            item.func_150895_a(ItemGroup.field_78027_g, (NonNullList<ItemStack>)nonnulllist);
        }
        nonnulllist.forEach(p_213232_2_ -> {
            searchtree.func_217872_a((Object)p_213232_2_);
            searchtreereloadable.func_217872_a((Object)p_213232_2_);
        });
        SearchTree searchtree1 = new SearchTree(p_213252_0_ -> p_213252_0_.func_192711_b().stream().flatMap(p_213234_0_ -> p_213234_0_.func_77571_b().func_82840_a(null, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL).stream()).map(p_213264_0_ -> TextFormatting.func_110646_a((String)p_213264_0_.getString()).trim()).filter(p_213238_0_ -> !p_213238_0_.isEmpty()), p_213258_0_ -> p_213258_0_.func_192711_b().stream().map(p_213244_0_ -> Registry.field_212630_s.func_177774_c((Object)p_213244_0_.func_77571_b().func_77973_b())));
        this.field_193995_ae.func_215357_a(SearchTreeManager.field_215359_a, searchtree);
        this.field_193995_ae.func_215357_a(SearchTreeManager.field_215360_b, searchtreereloadable);
        this.field_193995_ae.func_215357_a(SearchTreeManager.field_194012_b, searchtree1);
    }

    private void func_195545_a(int error, long description) {
        this.field_71474_y.field_74352_v = false;
        this.field_71474_y.func_74303_b();
    }

    private static boolean func_147122_X() {
        String[] astring;
        for (String s : astring = new String[]{"sun.arch.data.model", "com.ibm.vm.bitmode", "os.arch"}) {
            String s1 = System.getProperty(s);
            if (s1 == null || !s1.contains("64")) continue;
            return true;
        }
        return false;
    }

    public Framebuffer func_147110_a() {
        return this.field_147124_at;
    }

    public String func_175600_c() {
        return this.field_110447_Z;
    }

    public String func_184123_d() {
        return this.field_184130_ao;
    }

    private void func_71389_H() {
        Thread thread = new Thread("Timer hack thread"){

            @Override
            public void run() {
                while (Minecraft.this.field_71425_J) {
                    try {
                        Thread.sleep(Integer.MAX_VALUE);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(field_147123_G));
        thread.start();
    }

    public void func_71404_a(CrashReport crash) {
        this.field_71434_R = true;
        this.field_71433_S = crash;
    }

    public void func_71377_b(CrashReport crashReportIn) {
        File file1 = new File(Minecraft.func_71410_x().field_71412_D, "crash-reports");
        File file2 = new File(file1, "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-client.txt");
        Bootstrap.func_179870_a(crashReportIn.func_71502_e());
        if (crashReportIn.func_71497_f() != null) {
            Bootstrap.func_179870_a("#@!@# Game crashed! Crash report saved to: #@!@# " + crashReportIn.func_71497_f());
            ServerLifecycleHooks.handleExit((int)-1);
        } else if (crashReportIn.func_147149_a(file2)) {
            Bootstrap.func_179870_a("#@!@# Game crashed! Crash report saved to: #@!@# " + file2.getAbsolutePath());
            System.exit(-1);
        } else {
            Bootstrap.func_179870_a("#@?@# Game crashed! Crash report could not be saved. #@?@#");
            System.exit(-2);
        }
    }

    public boolean func_211821_e() {
        return this.field_71474_y.field_211842_aO;
    }

    @Deprecated
    public CompletableFuture<Void> func_213237_g() {
        if (this.field_213276_aV != null) {
            return this.field_213276_aV;
        }
        CompletableFuture<Void> completablefuture = new CompletableFuture<Void>();
        if (this.field_213279_p instanceof ResourceLoadProgressGui) {
            this.field_213276_aV = completablefuture;
            return completablefuture;
        }
        this.field_110448_aq.func_198983_a();
        List<IResourcePack> list = this.field_110448_aq.func_198980_d().stream().map(ResourcePackInfo::func_195796_e).collect(Collectors.toList());
        this.func_213268_a(new ResourceLoadProgressGui(this, this.field_110451_am.func_219537_a(Util.func_215072_e(), (Executor)((Object)this), field_223714_G, list), () -> {
            this.field_135017_as.func_135043_a(list);
            if (this.field_71438_f != null) {
                this.field_71438_f.func_72712_a();
            }
            completablefuture.complete(null);
        }, true));
        return completablefuture;
    }

    private void func_213256_aB() {
        boolean flag = false;
        BlockModelShapes blockmodelshapes = this.func_175602_ab().func_175023_a();
        IBakedModel ibakedmodel = blockmodelshapes.func_178126_b().func_174951_a();
        for (Object block : Registry.field_212618_g) {
            for (BlockState blockstate : ((Block)((Object)block)).func_176194_O().func_177619_a()) {
                IBakedModel ibakedmodel1;
                if (blockstate.func_185901_i() != BlockRenderType.MODEL || (ibakedmodel1 = blockmodelshapes.func_178125_b(blockstate)) != ibakedmodel) continue;
                field_147123_G.debug("Missing model for: {}", (Object)blockstate);
                flag = true;
            }
        }
        TextureAtlasSprite textureatlassprite1 = ibakedmodel.func_177554_e();
        for (Block block1 : Registry.field_212618_g) {
            for (BlockState blockstate1 : block1.func_176194_O().func_177619_a()) {
                TextureAtlasSprite textureatlassprite = blockmodelshapes.func_178122_a(blockstate1);
                if (blockstate1.func_196958_f() || textureatlassprite != textureatlassprite1) continue;
                field_147123_G.debug("Missing particle icon for: {}", (Object)blockstate1);
                flag = true;
            }
        }
        NonNullList nonnulllist = NonNullList.func_191196_a();
        for (Item item : Registry.field_212630_s) {
            nonnulllist.clear();
            item.func_150895_a(ItemGroup.field_78027_g, (NonNullList<ItemStack>)nonnulllist);
            for (ItemStack itemstack : nonnulllist) {
                String s = itemstack.func_77977_a();
                String s1 = new TranslationTextComponent(s, new Object[0]).getString();
                if (!s1.toLowerCase(Locale.ROOT).equals(item.func_77658_a())) continue;
                field_147123_G.debug("Missing translation for: {} {} {}", (Object)itemstack, (Object)s, (Object)itemstack.func_77973_b());
            }
        }
        if (flag |= ScreenManager.func_216910_a()) {
            throw new IllegalStateException("Your game data is foobar, fix the errors above!");
        }
    }

    public SaveFormat func_71359_d() {
        return this.field_71469_aa;
    }

    public void func_147108_a(@Nullable Screen guiScreenIn) {
        if (guiScreenIn == null && this.field_71441_e == null) {
            guiScreenIn = new MainMenuScreen();
        } else if (guiScreenIn == null && this.field_71439_g.func_110143_aJ() <= 0.0f) {
            guiScreenIn = new DeathScreen(null, this.field_71441_e.func_72912_H().func_76093_s());
        }
        Screen old = this.field_71462_r;
        GuiOpenEvent event = new GuiOpenEvent(guiScreenIn);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        guiScreenIn = event.getGui();
        if (old != null && guiScreenIn != old) {
            old.removed();
        }
        if (guiScreenIn instanceof MainMenuScreen || guiScreenIn instanceof MultiplayerScreen) {
            this.field_71474_y.field_74330_P = false;
            this.field_71456_v.func_146158_b().func_146231_a(true);
        }
        this.field_71462_r = guiScreenIn;
        if (guiScreenIn != null) {
            this.field_71417_B.func_198032_j();
            KeyBinding.func_74506_a();
            guiScreenIn.init(this, this.field_195558_d.func_198107_o(), this.field_195558_d.func_198087_p());
            this.field_71454_w = false;
            NarratorChatListener.field_193643_a.func_216864_a(guiScreenIn.getNarrationMessage());
        } else {
            this.field_147127_av.func_147687_e();
            this.field_71417_B.func_198034_i();
        }
    }

    public void func_213268_a(@Nullable LoadingGui loadingGuiIn) {
        this.field_213279_p = loadingGuiIn;
    }

    public void func_71405_e() {
        try {
            field_147123_G.info("Stopping!");
            NarratorChatListener.field_193643_a.func_216867_c();
            try {
                if (this.field_71441_e != null) {
                    this.field_71441_e.func_72882_A();
                }
                this.func_213254_o();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.field_71462_r != null) {
                this.field_71462_r.removed();
            }
            this.close();
        }
        finally {
            Util.field_211180_a = System::nanoTime;
            if (!this.field_71434_R) {
                System.exit(0);
            }
        }
    }

    @Override
    public void close() {
        try {
            this.field_147128_au.func_195419_g();
            this.field_71466_p.close();
            this.field_211501_aD.close();
            this.field_71460_t.close();
            this.field_71438_f.close();
            this.field_147127_av.func_147685_d();
            this.field_110448_aq.close();
            this.field_71452_i.func_215232_a();
            this.field_213273_aM.close();
            this.field_213272_aL.close();
            Util.func_215082_f();
        }
        finally {
            this.field_195557_T.close();
            this.field_195558_d.close();
        }
    }

    private void func_195542_b(boolean renderWorldIn) {
        boolean flag;
        Runnable runnable;
        this.field_195558_d.func_198076_a("Pre render");
        long i = Util.func_211178_c();
        this.field_71424_I.func_219894_a();
        if (GLX.shouldClose(this.field_195558_d)) {
            this.func_71400_g();
        }
        if (this.field_213276_aV != null && !(this.field_213279_p instanceof ResourceLoadProgressGui)) {
            CompletableFuture<Void> completablefuture = this.field_213276_aV;
            this.field_213276_aV = null;
            this.func_213237_g().thenRun(() -> completablefuture.complete(null));
        }
        while ((runnable = this.field_213275_aU.poll()) != null) {
            runnable.run();
        }
        if (renderWorldIn) {
            this.field_71428_T.func_74275_a(Util.func_211177_b());
            this.field_71424_I.func_76320_a("scheduledExecutables");
            this.func_213160_bf();
            this.field_71424_I.func_76319_b();
        }
        long j = Util.func_211178_c();
        this.field_71424_I.func_76320_a("tick");
        if (renderWorldIn) {
            for (int k = 0; k < Math.min(10, this.field_71428_T.field_74280_b); ++k) {
                this.func_71407_l();
            }
        }
        this.field_71417_B.func_198028_a();
        this.field_195558_d.func_198076_a("Render");
        GLX.pollEvents();
        long i1 = Util.func_211178_c() - j;
        this.field_71424_I.func_219895_b("sound");
        this.field_147127_av.func_215289_a(this.field_71460_t.func_215316_n());
        this.field_71424_I.func_76319_b();
        this.field_71424_I.func_76320_a("render");
        GlStateManager.pushMatrix();
        GlStateManager.clear((int)16640, (boolean)field_142025_a);
        this.field_147124_at.func_147610_a(true);
        this.field_71424_I.func_76320_a("display");
        GlStateManager.enableTexture();
        this.field_71424_I.func_76319_b();
        if (!this.field_71454_w) {
            BasicEventHooks.onRenderTickStart((float)this.field_71428_T.field_194147_b);
            this.field_71424_I.func_219895_b("gameRenderer");
            this.field_71460_t.func_195458_a(this.field_71445_n ? this.field_193996_ah : this.field_71428_T.field_194147_b, i, renderWorldIn);
            this.field_71424_I.func_219895_b("toasts");
            this.field_193034_aS.func_195625_a();
            this.field_71424_I.func_76319_b();
            BasicEventHooks.onRenderTickEnd((float)this.field_71428_T.field_194147_b);
        }
        this.field_71424_I.func_219897_b();
        if (this.field_71474_y.field_74330_P && this.field_71474_y.field_74329_Q && !this.field_71474_y.field_74319_N) {
            this.field_71424_I.func_219899_d().func_219939_d();
            this.func_203410_as();
        } else {
            this.field_71424_I.func_219899_d().func_219938_b();
        }
        this.field_147124_at.func_147609_e();
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        this.field_147124_at.func_147615_c(this.field_195558_d.func_198109_k(), this.field_195558_d.func_198091_l());
        GlStateManager.popMatrix();
        this.field_71424_I.func_219894_a();
        this.func_213227_b(true);
        Thread.yield();
        this.field_195558_d.func_198076_a("Post render");
        ++this.field_71420_M;
        boolean bl = flag = this.func_71356_B() && (this.field_71462_r != null && this.field_71462_r.isPauseScreen() || this.field_213279_p != null && this.field_213279_p.func_212969_a()) && !this.field_71437_Z.func_71344_c();
        if (this.field_71445_n != flag) {
            if (this.field_71445_n) {
                this.field_193996_ah = this.field_71428_T.field_194147_b;
            } else {
                this.field_71428_T.field_194147_b = this.field_193996_ah;
            }
            this.field_71445_n = flag;
        }
        long l = Util.func_211178_c();
        this.field_181542_y.func_181747_a(l - this.field_181543_z);
        this.field_181543_z = l;
        while (Util.func_211177_b() >= this.field_71419_L + 1000L) {
            field_71470_ab = this.field_71420_M;
            Object[] objectArray = new Object[8];
            objectArray[0] = field_71470_ab;
            objectArray[1] = ChunkRender.field_178592_a;
            objectArray[2] = ChunkRender.field_178592_a == 1 ? "" : "s";
            objectArray[3] = (double)this.field_71474_y.field_74350_i == AbstractOption.field_216701_h.func_216733_c() ? "inf" : Integer.valueOf(this.field_71474_y.field_74350_i);
            objectArray[4] = this.field_71474_y.field_74352_v ? " vsync" : "";
            Object object = objectArray[5] = this.field_71474_y.field_74347_j ? "" : " fast";
            objectArray[6] = this.field_71474_y.field_74345_l == CloudOption.OFF ? "" : (this.field_71474_y.field_74345_l == CloudOption.FAST ? " fast-clouds" : " fancy-clouds");
            objectArray[7] = GLX.useVbo() ? " vbo" : "";
            this.field_71426_K = String.format("%d fps (%d chunk update%s) T: %s%s%s%s%s", objectArray);
            ChunkRender.field_178592_a = 0;
            this.field_71419_L += 1000L;
            this.field_71420_M = 0;
            this.field_71427_U.func_76471_b();
            if (this.field_71427_U.func_76468_d()) continue;
            this.field_71427_U.func_76463_a();
        }
        this.field_71424_I.func_219897_b();
    }

    public void func_213227_b(boolean limitFramerate) {
        this.field_71424_I.func_76320_a("display_update");
        this.field_195558_d.func_198086_a(this.field_71474_y.field_74353_u);
        this.field_71424_I.func_76319_b();
        if (limitFramerate && this.func_213266_aD()) {
            this.field_71424_I.func_76320_a("fpslimit_wait");
            this.field_195558_d.func_216524_c();
            this.field_71424_I.func_76319_b();
        }
    }

    public void func_213226_a() {
        Framebuffer framebuffer;
        int i = this.field_195558_d.func_216521_a(this.field_71474_y.field_74335_Z, this.func_211821_e());
        this.field_195558_d.func_216525_a((double)i);
        if (this.field_71462_r != null) {
            this.field_71462_r.resize(this, this.field_195558_d.func_198107_o(), this.field_195558_d.func_198087_p());
        }
        if ((framebuffer = this.func_147110_a()) != null) {
            framebuffer.func_216491_a(this.field_195558_d.func_198109_k(), this.field_195558_d.func_198091_l(), field_142025_a);
        }
        if (this.field_71460_t != null) {
            this.field_71460_t.func_147704_a(this.field_195558_d.func_198109_k(), this.field_195558_d.func_198091_l());
        }
        if (this.field_71417_B != null) {
            this.field_71417_B.func_198021_g();
        }
    }

    private int func_213243_aC() {
        return this.field_71441_e != null || this.field_71462_r == null && this.field_213279_p == null ? this.field_195558_d.func_198082_x() : 60;
    }

    private boolean func_213266_aD() {
        return (double)this.func_213243_aC() < AbstractOption.field_216701_h.func_216733_c();
    }

    public void func_71398_f() {
        try {
            field_71444_a = new byte[0];
            this.field_71438_f.func_72728_f();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.gc();
            if (this.func_71356_B()) {
                this.field_71437_Z.func_71263_m(true);
            }
            this.func_213231_b((Screen)new DirtMessageScreen((ITextComponent)new TranslationTextComponent("menu.savingLevel", new Object[0])));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.gc();
    }

    void func_71383_b(int keyCount) {
        IProfileResult iprofileresult = this.field_71424_I.func_219899_d().func_219937_c();
        List list = iprofileresult.func_219917_a(this.field_71465_an);
        if (!list.isEmpty()) {
            DataPoint datapoint = (DataPoint)list.remove(0);
            if (keyCount == 0) {
                int i;
                if (!datapoint.field_219945_c.isEmpty() && (i = this.field_71465_an.lastIndexOf(46)) >= 0) {
                    this.field_71465_an = this.field_71465_an.substring(0, i);
                }
            } else if (--keyCount < list.size() && !"unspecified".equals(((DataPoint)list.get((int)keyCount)).field_219945_c)) {
                if (!this.field_71465_an.isEmpty()) {
                    this.field_71465_an = this.field_71465_an + ".";
                }
                this.field_71465_an = this.field_71465_an + ((DataPoint)list.get((int)keyCount)).field_219945_c;
            }
        }
    }

    private void func_203410_as() {
        if (this.field_71424_I.func_219899_d().func_219936_a()) {
            IProfileResult iprofileresult = this.field_71424_I.func_219899_d().func_219937_c();
            List list = iprofileresult.func_219917_a(this.field_71465_an);
            DataPoint datapoint = (DataPoint)list.remove(0);
            GlStateManager.clear((int)256, (boolean)field_142025_a);
            GlStateManager.matrixMode((int)5889);
            GlStateManager.enableColorMaterial();
            GlStateManager.loadIdentity();
            GlStateManager.ortho((double)0.0, (double)this.field_195558_d.func_198109_k(), (double)this.field_195558_d.func_198091_l(), (double)0.0, (double)1000.0, (double)3000.0);
            GlStateManager.matrixMode((int)5888);
            GlStateManager.loadIdentity();
            GlStateManager.translatef((float)0.0f, (float)0.0f, (float)-2000.0f);
            GlStateManager.lineWidth((float)1.0f);
            GlStateManager.disableTexture();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            int i = 160;
            int j = this.field_195558_d.func_198109_k() - 160 - 10;
            int k = this.field_195558_d.func_198091_l() - 320;
            GlStateManager.enableBlend();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_181662_b((float)j - 176.0f, (float)k - 96.0f - 16.0f, 0.0).func_181669_b(200, 0, 0, 0).func_181675_d();
            bufferbuilder.func_181662_b((float)j - 176.0f, k + 320, 0.0).func_181669_b(200, 0, 0, 0).func_181675_d();
            bufferbuilder.func_181662_b((float)j + 176.0f, k + 320, 0.0).func_181669_b(200, 0, 0, 0).func_181675_d();
            bufferbuilder.func_181662_b((float)j + 176.0f, (float)k - 96.0f - 16.0f, 0.0).func_181669_b(200, 0, 0, 0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.disableBlend();
            double d0 = 0.0;
            for (int l = 0; l < list.size(); ++l) {
                DataPoint datapoint1 = (DataPoint)list.get(l);
                int i1 = MathHelper.func_76128_c((double)(datapoint1.field_219943_a / 4.0)) + 1;
                bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
                int j1 = datapoint1.func_219942_a();
                int k1 = j1 >> 16 & 0xFF;
                int l1 = j1 >> 8 & 0xFF;
                int i2 = j1 & 0xFF;
                bufferbuilder.func_181662_b(j, k, 0.0).func_181669_b(k1, l1, i2, 255).func_181675_d();
                for (int j2 = i1; j2 >= 0; --j2) {
                    float f = (float)((d0 + datapoint1.field_219943_a * (double)j2 / (double)i1) * 6.2831854820251465 / 100.0);
                    float f1 = MathHelper.func_76126_a((float)f) * 160.0f;
                    float f2 = MathHelper.func_76134_b((float)f) * 160.0f * 0.5f;
                    bufferbuilder.func_181662_b((float)j + f1, (float)k - f2, 0.0).func_181669_b(k1, l1, i2, 255).func_181675_d();
                }
                tessellator.func_78381_a();
                bufferbuilder.func_181668_a(5, DefaultVertexFormats.field_181706_f);
                for (int i3 = i1; i3 >= 0; --i3) {
                    float f3 = (float)((d0 + datapoint1.field_219943_a * (double)i3 / (double)i1) * 6.2831854820251465 / 100.0);
                    float f4 = MathHelper.func_76126_a((float)f3) * 160.0f;
                    float f5 = MathHelper.func_76134_b((float)f3) * 160.0f * 0.5f;
                    bufferbuilder.func_181662_b((float)j + f4, (float)k - f5, 0.0).func_181669_b(k1 >> 1, l1 >> 1, i2 >> 1, 255).func_181675_d();
                    bufferbuilder.func_181662_b((float)j + f4, (float)k - f5 + 10.0f, 0.0).func_181669_b(k1 >> 1, l1 >> 1, i2 >> 1, 255).func_181675_d();
                }
                tessellator.func_78381_a();
                d0 += datapoint1.field_219943_a;
            }
            DecimalFormat decimalformat = new DecimalFormat("##0.00");
            decimalformat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT));
            GlStateManager.enableTexture();
            String s = "";
            if (!"unspecified".equals(datapoint.field_219945_c)) {
                s = s + "[0] ";
            }
            s = datapoint.field_219945_c.isEmpty() ? s + "ROOT " : s + datapoint.field_219945_c + ' ';
            int l2 = 0xFFFFFF;
            this.field_71466_p.func_175063_a(s, (float)(j - 160), (float)(k - 80 - 16), 0xFFFFFF);
            s = decimalformat.format(datapoint.field_219944_b) + "%";
            this.field_71466_p.func_175063_a(s, (float)(j + 160 - this.field_71466_p.func_78256_a(s)), (float)(k - 80 - 16), 0xFFFFFF);
            for (int k2 = 0; k2 < list.size(); ++k2) {
                DataPoint datapoint2 = (DataPoint)list.get(k2);
                StringBuilder stringbuilder = new StringBuilder();
                if ("unspecified".equals(datapoint2.field_219945_c)) {
                    stringbuilder.append("[?] ");
                } else {
                    stringbuilder.append("[").append(k2 + 1).append("] ");
                }
                String s1 = stringbuilder.append(datapoint2.field_219945_c).toString();
                this.field_71466_p.func_175063_a(s1, (float)(j - 160), (float)(k + 80 + k2 * 8 + 20), datapoint2.func_219942_a());
                s1 = decimalformat.format(datapoint2.field_219943_a) + "%";
                this.field_71466_p.func_175063_a(s1, (float)(j + 160 - 50 - this.field_71466_p.func_78256_a(s1)), (float)(k + 80 + k2 * 8 + 20), datapoint2.func_219942_a());
                s1 = decimalformat.format(datapoint2.field_219944_b) + "%";
                this.field_71466_p.func_175063_a(s1, (float)(j + 160 - this.field_71466_p.func_78256_a(s1)), (float)(k + 80 + k2 * 8 + 20), datapoint2.func_219942_a());
            }
        }
    }

    public void func_71400_g() {
        this.field_71425_J = false;
    }

    public void func_71385_j(boolean pauseOnly) {
        if (this.field_71462_r == null) {
            boolean flag;
            boolean bl = flag = this.func_71356_B() && !this.field_71437_Z.func_71344_c();
            if (flag) {
                this.func_147108_a((Screen)new IngameMenuScreen(!pauseOnly));
                this.field_147127_av.func_147689_b();
            } else {
                this.func_147108_a((Screen)new IngameMenuScreen(true));
            }
        }
    }

    private void func_147115_a(boolean leftClick) {
        if (!leftClick) {
            this.field_71429_W = 0;
        }
        if (this.field_71429_W <= 0 && !this.field_71439_g.func_184587_cr()) {
            if (leftClick && this.field_71476_x != null && this.field_71476_x.func_216346_c() == RayTraceResult.Type.BLOCK) {
                Direction direction;
                BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)this.field_71476_x;
                BlockPos blockpos = blockraytraceresult.func_216350_a();
                if (!this.field_71441_e.func_175623_d(blockpos) && this.field_71442_b.func_180512_c(blockpos, direction = blockraytraceresult.func_216354_b())) {
                    this.field_71452_i.addBlockHitEffects(blockpos, blockraytraceresult);
                    this.field_71439_g.func_184609_a(Hand.MAIN_HAND);
                }
            } else {
                this.field_71442_b.func_78767_c();
            }
        }
    }

    private void func_147116_af() {
        if (this.field_71429_W <= 0) {
            if (this.field_71476_x == null) {
                field_147123_G.error("Null returned as 'hitResult', this shouldn't happen!");
                if (this.field_71442_b.func_78762_g()) {
                    this.field_71429_W = 10;
                }
            } else if (!this.field_71439_g.func_184838_M()) {
                switch (this.field_71476_x.func_216346_c()) {
                    case ENTITY: {
                        this.field_71442_b.func_78764_a(this.field_71439_g, ((EntityRayTraceResult)this.field_71476_x).func_216348_a());
                        break;
                    }
                    case BLOCK: {
                        BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)this.field_71476_x;
                        BlockPos blockpos = blockraytraceresult.func_216350_a();
                        if (!this.field_71441_e.func_180495_p(blockpos).isAir((IBlockReader)this.field_71441_e, blockpos)) {
                            this.field_71442_b.func_180511_b(blockpos, blockraytraceresult.func_216354_b());
                            break;
                        }
                    }
                    case MISS: {
                        if (this.field_71442_b.func_78762_g()) {
                            this.field_71429_W = 10;
                        }
                        this.field_71439_g.func_184821_cY();
                        ForgeHooks.onEmptyLeftClick((PlayerEntity)this.field_71439_g);
                    }
                }
                this.field_71439_g.func_184609_a(Hand.MAIN_HAND);
            }
        }
    }

    private void func_147121_ag() {
        if (!this.field_71442_b.func_181040_m()) {
            this.field_71467_ac = 4;
            if (!this.field_71439_g.func_184838_M()) {
                if (this.field_71476_x == null) {
                    field_147123_G.warn("Null returned as 'hitResult', this shouldn't happen!");
                }
                for (Hand hand : Hand.values()) {
                    ItemStack itemstack = this.field_71439_g.func_184586_b(hand);
                    if (this.field_71476_x != null) {
                        switch (this.field_71476_x.func_216346_c()) {
                            case ENTITY: {
                                EntityRayTraceResult entityraytraceresult = (EntityRayTraceResult)this.field_71476_x;
                                Entity entity = entityraytraceresult.func_216348_a();
                                if (this.field_71442_b.func_187102_a(this.field_71439_g, entity, entityraytraceresult, hand) == ActionResultType.SUCCESS) {
                                    return;
                                }
                                if (this.field_71442_b.func_187097_a(this.field_71439_g, entity, hand) != ActionResultType.SUCCESS) break;
                                return;
                            }
                            case BLOCK: {
                                BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)this.field_71476_x;
                                int i = itemstack.func_190916_E();
                                ActionResultType actionresulttype = this.field_71442_b.func_217292_a(this.field_71439_g, this.field_71441_e, hand, blockraytraceresult);
                                if (actionresulttype == ActionResultType.SUCCESS) {
                                    this.field_71439_g.func_184609_a(hand);
                                    if (!itemstack.func_190926_b() && (itemstack.func_190916_E() != i || this.field_71442_b.func_78758_h())) {
                                        this.field_71460_t.field_78516_c.func_187460_a(hand);
                                    }
                                    return;
                                }
                                if (actionresulttype != ActionResultType.FAIL) break;
                                return;
                            }
                        }
                    }
                    if (itemstack.func_190926_b() && (this.field_71476_x == null || this.field_71476_x.func_216346_c() == RayTraceResult.Type.MISS)) {
                        ForgeHooks.onEmptyClick((PlayerEntity)this.field_71439_g, (Hand)hand);
                    }
                    if (itemstack.func_190926_b() || this.field_71442_b.func_187101_a(this.field_71439_g, this.field_71441_e, hand) != ActionResultType.SUCCESS) continue;
                    this.field_71460_t.field_78516_c.func_187460_a(hand);
                    return;
                }
            }
        }
    }

    public MusicTicker func_181535_r() {
        return this.field_147126_aw;
    }

    public void func_71407_l() {
        if (this.field_71467_ac > 0) {
            --this.field_71467_ac;
        }
        BasicEventHooks.onPreClientTick();
        this.field_71424_I.func_76320_a("gui");
        if (!this.field_71445_n) {
            this.field_71456_v.func_73831_a();
        }
        this.field_71424_I.func_76319_b();
        this.field_71460_t.func_78473_a(1.0f);
        this.field_193035_aW.func_193297_a(this.field_71441_e, this.field_71476_x);
        this.field_71424_I.func_76320_a("gameMode");
        if (!this.field_71445_n && this.field_71441_e != null) {
            this.field_71442_b.func_78765_e();
        }
        this.field_71424_I.func_219895_b("textures");
        if (this.field_71441_e != null) {
            this.field_71446_o.func_110550_d();
        }
        if (this.field_71462_r == null && this.field_71439_g != null) {
            if (this.field_71439_g.func_110143_aJ() <= 0.0f && !(this.field_71462_r instanceof DeathScreen)) {
                this.func_147108_a(null);
            } else if (this.field_71439_g.func_70608_bn() && this.field_71441_e != null) {
                this.func_147108_a((Screen)((Object)new SleepInMultiplayerScreen()));
            }
        } else if (this.field_71462_r != null && this.field_71462_r instanceof SleepInMultiplayerScreen && !this.field_71439_g.func_70608_bn()) {
            this.func_147108_a(null);
        }
        if (this.field_71462_r != null) {
            this.field_71429_W = 10000;
        }
        if (this.field_71462_r != null) {
            Screen.wrapScreenError(() -> this.field_71462_r.tick(), "Ticking screen", ((Object)((Object)this.field_71462_r)).getClass().getCanonicalName());
        }
        if (!this.field_71474_y.field_74330_P) {
            this.field_71456_v.func_212910_m();
        }
        if (this.field_213279_p == null && (this.field_71462_r == null || this.field_71462_r.passEvents)) {
            this.field_71424_I.func_219895_b("GLFW events");
            GLX.pollEvents();
            this.func_184117_aA();
            if (this.field_71429_W > 0) {
                --this.field_71429_W;
            }
        }
        if (this.field_71441_e != null) {
            this.field_71424_I.func_219895_b("gameRenderer");
            if (!this.field_71445_n) {
                this.field_71460_t.func_78464_a();
            }
            this.field_71424_I.func_219895_b("levelRenderer");
            if (!this.field_71445_n) {
                this.field_71438_f.func_72734_e();
            }
            this.field_71424_I.func_219895_b("level");
            if (!this.field_71445_n) {
                if (this.field_71441_e.func_175658_ac() > 0) {
                    this.field_71441_e.func_175702_c(this.field_71441_e.func_175658_ac() - 1);
                }
                this.field_71441_e.func_217419_d();
            }
        } else if (this.field_71460_t.func_147702_a()) {
            this.field_71460_t.func_181022_b();
        }
        if (!this.field_71445_n) {
            this.field_147126_aw.func_73660_a();
        }
        this.field_147127_av.func_215290_a(this.field_71445_n);
        if (this.field_71441_e != null) {
            if (!this.field_71445_n) {
                this.field_71441_e.func_72891_a(this.field_71441_e.func_175659_aa() != Difficulty.PEACEFUL, true);
                this.field_193035_aW.func_193303_d();
                try {
                    this.field_71441_e.func_72835_b(() -> true);
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.func_85055_a(throwable, "Exception in world tick");
                    if (this.field_71441_e == null) {
                        CrashReportCategory crashreportcategory = crashreport.func_85058_a("Affected level");
                        crashreportcategory.func_71507_a("Problem", "Level is null!");
                    } else {
                        this.field_71441_e.func_72914_a(crashreport);
                    }
                    throw new ReportedException(crashreport);
                }
            }
            this.field_71424_I.func_219895_b("animateTick");
            if (!this.field_71445_n && this.field_71441_e != null) {
                this.field_71441_e.func_73029_E(MathHelper.func_76128_c((double)this.field_71439_g.field_70165_t), MathHelper.func_76128_c((double)this.field_71439_g.field_70163_u), MathHelper.func_76128_c((double)this.field_71439_g.field_70161_v));
            }
            this.field_71424_I.func_219895_b("particles");
            if (!this.field_71445_n) {
                this.field_71452_i.func_78868_a();
            }
        } else if (this.field_71453_ak != null) {
            this.field_71424_I.func_219895_b("pendingConnection");
            this.field_71453_ak.func_74428_b();
        }
        this.field_71424_I.func_219895_b("keyboard");
        this.field_195559_v.func_204870_b();
        this.field_71424_I.func_76319_b();
        BasicEventHooks.onPostClientTick();
    }

    private void func_184117_aA() {
        boolean flag2;
        while (this.field_71474_y.field_151457_aa.func_151468_f()) {
            ++this.field_71474_y.field_74320_O;
            if (this.field_71474_y.field_74320_O > 2) {
                this.field_71474_y.field_74320_O = 0;
            }
            if (this.field_71474_y.field_74320_O == 0) {
                this.field_71460_t.func_175066_a(this.func_175606_aa());
            } else if (this.field_71474_y.field_74320_O == 1) {
                this.field_71460_t.func_175066_a(null);
            }
            this.field_71438_f.func_174979_m();
        }
        while (this.field_71474_y.field_151458_ab.func_151468_f()) {
            this.field_71474_y.field_74326_T = !this.field_71474_y.field_74326_T;
        }
        for (int i = 0; i < 9; ++i) {
            boolean flag = this.field_71474_y.field_193629_ap.func_151470_d();
            boolean flag1 = this.field_71474_y.field_193630_aq.func_151470_d();
            if (!this.field_71474_y.field_151456_ac[i].func_151468_f()) continue;
            if (this.field_71439_g.func_175149_v()) {
                this.field_71456_v.func_175187_g().func_175260_a(i);
                continue;
            }
            if (!this.field_71439_g.func_184812_l_() || this.field_71462_r != null || !flag1 && !flag) {
                this.field_71439_g.field_71071_by.field_70461_c = i;
                continue;
            }
            CreativeScreen.func_192044_a(this, i, flag1, flag);
        }
        while (this.field_71474_y.field_151445_Q.func_151468_f()) {
            if (this.field_71442_b.func_110738_j()) {
                this.field_71439_g.func_175163_u();
                continue;
            }
            this.field_193035_aW.func_193296_a();
            this.func_147108_a((Screen)new InventoryScreen((PlayerEntity)this.field_71439_g));
        }
        while (this.field_71474_y.field_194146_ao.func_151468_f()) {
            this.func_147108_a(new AdvancementsScreen(this.field_71439_g.field_71174_a.func_191982_f()));
        }
        while (this.field_71474_y.field_186718_X.func_151468_f()) {
            if (this.field_71439_g.func_175149_v()) continue;
            this.func_147114_u().func_147297_a((IPacket<?>)new CPlayerDiggingPacket(CPlayerDiggingPacket.Action.SWAP_HELD_ITEMS, BlockPos.field_177992_a, Direction.DOWN));
        }
        while (this.field_71474_y.field_74316_C.func_151468_f()) {
            if (this.field_71439_g.func_175149_v()) continue;
            this.field_71439_g.func_71040_bB(Screen.hasControlDown());
        }
        boolean bl = flag2 = this.field_71474_y.field_74343_n != ChatVisibility.HIDDEN;
        if (flag2) {
            while (this.field_71474_y.field_74310_D.func_151468_f()) {
                this.func_147108_a((Screen)new ChatScreen(""));
            }
            if (this.field_71462_r == null && this.field_213279_p == null && this.field_71474_y.field_74323_J.func_151468_f()) {
                this.func_147108_a((Screen)new ChatScreen("/"));
            }
        }
        if (this.field_71439_g.func_184587_cr()) {
            if (!this.field_71474_y.field_74313_G.func_151470_d()) {
                this.field_71442_b.func_78766_c(this.field_71439_g);
            }
            while (this.field_71474_y.field_74312_F.func_151468_f()) {
            }
            while (this.field_71474_y.field_74313_G.func_151468_f()) {
            }
            while (this.field_71474_y.field_74322_I.func_151468_f()) {
            }
        } else {
            while (this.field_71474_y.field_74312_F.func_151468_f()) {
                this.func_147116_af();
            }
            while (this.field_71474_y.field_74313_G.func_151468_f()) {
                this.func_147121_ag();
            }
            while (this.field_71474_y.field_74322_I.func_151468_f()) {
                this.func_147112_ai();
            }
        }
        if (this.field_71474_y.field_74313_G.func_151470_d() && this.field_71467_ac == 0 && !this.field_71439_g.func_184587_cr()) {
            this.func_147121_ag();
        }
        this.func_147115_a(this.field_71462_r == null && this.field_71474_y.field_74312_F.func_151470_d() && this.field_71417_B.func_198035_h());
    }

    public void func_71371_a(String folderName, String worldName, @Nullable WorldSettings worldSettingsIn) {
        this.func_213254_o();
        SaveHandler savehandler = this.field_71469_aa.func_197715_a(folderName, null);
        WorldInfo worldinfo = savehandler.func_75757_d();
        if (worldinfo == null && worldSettingsIn != null) {
            worldinfo = new WorldInfo(worldSettingsIn, folderName);
            savehandler.func_75761_a(worldinfo);
        }
        if (worldSettingsIn == null) {
            worldSettingsIn = new WorldSettings(worldinfo);
        }
        this.field_213277_ad.set(null);
        try {
            YggdrasilAuthenticationService yggdrasilauthenticationservice = new YggdrasilAuthenticationService(this.field_110453_aa, UUID.randomUUID().toString());
            MinecraftSessionService minecraftsessionservice = yggdrasilauthenticationservice.createMinecraftSessionService();
            GameProfileRepository gameprofilerepository = yggdrasilauthenticationservice.createProfileRepository();
            PlayerProfileCache playerprofilecache = new PlayerProfileCache(gameprofilerepository, new File(this.field_71412_D, MinecraftServer.field_152367_a.getName()));
            SkullTileEntity.func_184293_a((PlayerProfileCache)playerprofilecache);
            SkullTileEntity.func_184294_a((MinecraftSessionService)minecraftsessionservice);
            PlayerProfileCache.func_187320_a((boolean)false);
            this.field_71437_Z = new IntegratedServer(this, folderName, worldName, worldSettingsIn, yggdrasilauthenticationservice, minecraftsessionservice, gameprofilerepository, playerprofilecache, p_213246_1_ -> {
                TrackingChunkStatusListener trackingchunkstatuslistener = new TrackingChunkStatusListener(p_213246_1_ + 0);
                trackingchunkstatuslistener.func_219521_a();
                this.field_213277_ad.set(trackingchunkstatuslistener);
                return new ChainedChunkStatusListener((IChunkStatusListener)trackingchunkstatuslistener, this.field_213275_aU::add);
            });
            this.field_71437_Z.func_71256_s();
            this.field_71455_al = true;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Starting integrated server");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Starting integrated server");
            crashreportcategory.func_71507_a("Level ID", folderName);
            crashreportcategory.func_71507_a("Level Name", worldName);
            throw new ReportedException(crashreport);
        }
        while (this.field_213277_ad.get() == null) {
            Thread.yield();
        }
        WorldLoadProgressScreen worldloadprogressscreen = new WorldLoadProgressScreen(this.field_213277_ad.get());
        this.func_147108_a((Screen)worldloadprogressscreen);
        while (!this.field_71437_Z.func_71200_ad()) {
            if (!StartupQuery.check() || this.field_71437_Z.func_71241_aa()) {
                this.func_147108_a(null);
                return;
            }
            if (this.field_71462_r == null) {
                this.func_147108_a((Screen)worldloadprogressscreen);
            }
            worldloadprogressscreen.tick();
            this.func_195542_b(false);
            try {
                Thread.sleep(16L);
            }
            catch (InterruptedException crashreport) {
                // empty catch block
            }
            if (!this.field_71434_R || this.field_71433_S == null) continue;
            this.func_71377_b(this.field_71433_S);
            return;
        }
        SocketAddress socketaddress = this.field_71437_Z.func_147137_ag().func_151270_a();
        NetworkManager networkmanager = NetworkManager.func_150722_a(socketaddress);
        networkmanager.func_150719_a((INetHandler)new ClientLoginNetHandler(networkmanager, this, null, p_213261_0_ -> {}));
        networkmanager.func_179290_a(new CHandshakePacket(socketaddress.toString(), 0, ProtocolType.LOGIN));
        GameProfile gameProfile = this.func_110432_I().func_148256_e();
        if (!this.func_110432_I().hasCachedProperties()) {
            gameProfile = this.field_152355_az.fillProfileProperties(gameProfile, true);
            this.func_110432_I().setProperties(gameProfile.getProperties());
        }
        networkmanager.func_179290_a((IPacket<?>)new CLoginStartPacket(gameProfile));
        this.field_71453_ak = networkmanager;
    }

    public void func_71403_a(ClientWorld worldClientIn) {
        if (this.field_71441_e != null) {
            MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Unload((IWorld)this.field_71441_e));
        }
        WorkingScreen workingscreen = new WorkingScreen();
        workingscreen.func_200210_a((ITextComponent)new TranslationTextComponent("connect.joining", new Object[0]));
        this.func_213241_c((Screen)workingscreen);
        this.field_71441_e = worldClientIn;
        this.func_213257_b(worldClientIn);
        if (!this.field_71455_al) {
            YggdrasilAuthenticationService authenticationservice = new YggdrasilAuthenticationService(this.field_110453_aa, UUID.randomUUID().toString());
            MinecraftSessionService minecraftsessionservice = authenticationservice.createMinecraftSessionService();
            GameProfileRepository gameprofilerepository = authenticationservice.createProfileRepository();
            PlayerProfileCache playerprofilecache = new PlayerProfileCache(gameprofilerepository, new File(this.field_71412_D, MinecraftServer.field_152367_a.getName()));
            SkullTileEntity.func_184293_a((PlayerProfileCache)playerprofilecache);
            SkullTileEntity.func_184294_a((MinecraftSessionService)minecraftsessionservice);
            PlayerProfileCache.func_187320_a((boolean)false);
        }
    }

    public void func_213254_o() {
        this.func_213231_b((Screen)new WorkingScreen());
    }

    public void func_213231_b(Screen screenIn) {
        ClientPlayNetHandler clientplaynethandler = this.func_147114_u();
        if (clientplaynethandler != null) {
            this.func_213159_be();
            clientplaynethandler.func_147296_c();
        }
        IntegratedServer integratedserver = this.field_71437_Z;
        this.field_71437_Z = null;
        this.field_71460_t.func_190564_k();
        ClientHooks.firePlayerLogout((PlayerController)this.field_71442_b, (ClientPlayerEntity)this.field_71439_g);
        this.field_71442_b = null;
        NarratorChatListener.field_193643_a.func_193642_b();
        this.func_213241_c(screenIn);
        if (this.field_71441_e != null) {
            MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Unload((IWorld)this.field_71441_e));
            if (integratedserver != null) {
                while (!integratedserver.func_213201_w()) {
                    this.func_195542_b(false);
                }
            }
            this.field_195554_ax.func_195749_c();
            this.field_71456_v.func_181029_i();
            this.func_71351_a(null);
            this.field_71455_al = false;
            this.field_213274_aO.func_216815_b();
        }
        this.field_71441_e = null;
        this.func_213257_b(null);
        this.field_71439_g = null;
    }

    private void func_213241_c(Screen screenIn) {
        this.field_147126_aw.func_209200_a();
        this.field_147127_av.func_147690_c();
        this.field_175622_Z = null;
        this.field_71453_ak = null;
        this.func_147108_a(screenIn);
        this.func_195542_b(false);
    }

    private void func_213257_b(@Nullable ClientWorld worldIn) {
        if (this.field_71438_f != null) {
            this.field_71438_f.func_72732_a(worldIn);
        }
        if (this.field_71452_i != null) {
            this.field_71452_i.func_78870_a(worldIn);
        }
        TileEntityRendererDispatcher.field_147556_a.func_147543_a(worldIn);
        MinecraftForgeClient.clearRenderCache();
    }

    public final boolean func_71355_q() {
        return this.field_71459_aj;
    }

    @Nullable
    public ClientPlayNetHandler func_147114_u() {
        return this.field_71439_g == null ? null : this.field_71439_g.field_71174_a;
    }

    public static boolean func_71382_s() {
        return field_71432_P == null || !Minecraft.field_71432_P.field_71474_y.field_74319_N;
    }

    public static boolean func_71375_t() {
        return field_71432_P != null && Minecraft.field_71432_P.field_71474_y.field_74347_j;
    }

    public static boolean func_71379_u() {
        return field_71432_P != null && Minecraft.field_71432_P.field_71474_y.field_74348_k != AmbientOcclusionStatus.OFF;
    }

    private void func_147112_ai() {
        if (this.field_71476_x != null && this.field_71476_x.func_216346_c() != RayTraceResult.Type.MISS) {
            ForgeHooks.onPickBlock((RayTraceResult)this.field_71476_x, (PlayerEntity)this.field_71439_g, (World)this.field_71441_e);
        }
    }

    public ItemStack func_184119_a(ItemStack stack, TileEntity te) {
        CompoundNBT compoundnbt = te.func_189515_b(new CompoundNBT());
        if (stack.func_77973_b() instanceof SkullItem && compoundnbt.func_74764_b("Owner")) {
            CompoundNBT compoundnbt2 = compoundnbt.func_74775_l("Owner");
            stack.func_196082_o().func_218657_a("SkullOwner", compoundnbt2);
            return stack;
        }
        stack.func_77983_a("BlockEntityTag", compoundnbt);
        CompoundNBT compoundnbt1 = new CompoundNBT();
        ListNBT listnbt = new ListNBT();
        listnbt.add((Object)new StringNBT("\"(+NBT)\""));
        compoundnbt1.func_218657_a("Lore", (INBT)listnbt);
        stack.func_77983_a("display", compoundnbt1);
        return stack;
    }

    public CrashReport func_71396_d(CrashReport theCrash) {
        CrashReportCategory crashreportcategory = theCrash.func_85056_g();
        crashreportcategory.func_189529_a("Launched Version", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.field_110447_Z));
        crashreportcategory.func_189529_a("LWJGL", (ICrashReportDetail<String>)((ICrashReportDetail)GLX::getLWJGLVersion));
        crashreportcategory.func_189529_a("OpenGL", (ICrashReportDetail<String>)((ICrashReportDetail)GLX::getOpenGLVersionString));
        crashreportcategory.func_189529_a("GL Caps", (ICrashReportDetail<String>)((ICrashReportDetail)GLX::getCapsString));
        crashreportcategory.func_189529_a("Using VBOs", (ICrashReportDetail<String>)((ICrashReportDetail)() -> "Yes"));
        crashreportcategory.func_189529_a("Is Modded", (ICrashReportDetail<String>)((ICrashReportDetail)() -> {
            String s = ClientBrandRetriever.getClientModName();
            if (!"vanilla".equals(s)) {
                return "Definitely; Client brand changed to '" + s + "'";
            }
            return Minecraft.class.getSigners() == null ? "Very likely; Jar signature invalidated" : "Probably not. Jar signature remains and client brand is untouched.";
        }));
        crashreportcategory.func_71507_a("Type", "Client (map_client.txt)");
        crashreportcategory.func_189529_a("Resource Packs", (ICrashReportDetail<String>)((ICrashReportDetail)() -> {
            StringBuilder stringbuilder = new StringBuilder();
            for (String s : this.field_71474_y.field_151453_l) {
                if (stringbuilder.length() > 0) {
                    stringbuilder.append(", ");
                }
                stringbuilder.append(s);
                if (!this.field_71474_y.field_183018_l.contains(s)) continue;
                stringbuilder.append(" (incompatible)");
            }
            return stringbuilder.toString();
        }));
        crashreportcategory.func_189529_a("Current Language", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.field_135017_as.func_135041_c().toString()));
        crashreportcategory.func_189529_a("CPU", (ICrashReportDetail<String>)((ICrashReportDetail)GLX::getCpuInfo));
        if (this.field_71441_e != null) {
            this.field_71441_e.func_72914_a(theCrash);
        }
        return theCrash;
    }

    public static Minecraft func_71410_x() {
        return field_71432_P;
    }

    @Deprecated
    public CompletableFuture<Void> func_213245_w() {
        return this.func_213169_a(this::func_213237_g).thenCompose(p_213240_0_ -> p_213240_0_);
    }

    public void func_70000_a(Snooper snooper) {
        snooper.func_152768_a("fps", (Object)field_71470_ab);
        snooper.func_152768_a("vsync_enabled", (Object)this.field_71474_y.field_74352_v);
        int i = GLX.getRefreshRate(this.field_195558_d);
        snooper.func_152768_a("display_frequency", (Object)i);
        snooper.func_152768_a("display_type", (Object)(this.field_195558_d.func_198113_j() ? "fullscreen" : "windowed"));
        snooper.func_152768_a("run_time", (Object)((Util.func_211177_b() - snooper.func_130105_g()) / 60L * 1000L));
        snooper.func_152768_a("current_action", (Object)this.func_181538_aA());
        snooper.func_152768_a("language", (Object)(this.field_71474_y.field_74363_ab == null ? "en_us" : this.field_71474_y.field_74363_ab));
        String s = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "little" : "big";
        snooper.func_152768_a("endianness", (Object)s);
        snooper.func_152768_a("subtitles", (Object)this.field_71474_y.field_186717_N);
        snooper.func_152768_a("touch", (Object)(this.field_71474_y.field_85185_A ? "touch" : "mouse"));
        int j = 0;
        for (ClientResourcePackInfo clientresourcepackinfo : this.field_110448_aq.func_198980_d()) {
            if (clientresourcepackinfo.func_195797_g() || clientresourcepackinfo.func_195798_h()) continue;
            snooper.func_152768_a("resource_pack[" + j++ + "]", (Object)clientresourcepackinfo.func_195790_f());
        }
        snooper.func_152768_a("resource_packs", (Object)j);
        if (this.field_71437_Z != null && this.field_71437_Z.func_80003_ah() != null) {
            snooper.func_152768_a("snooper_partner", (Object)this.field_71437_Z.func_80003_ah().func_80006_f());
        }
    }

    private String func_181538_aA() {
        if (this.field_71437_Z != null) {
            return this.field_71437_Z.func_71344_c() ? "hosting_lan" : "singleplayer";
        }
        if (this.field_71422_O != null) {
            return this.field_71422_O.func_181041_d() ? "playing_lan" : "multiplayer";
        }
        return "out_of_game";
    }

    public static int func_71369_N() {
        if (field_211120_F == -1) {
            for (int i = 16384; i > 0; i >>= 1) {
                GlStateManager.texImage2D((int)32868, (int)0, (int)6408, (int)i, (int)i, (int)0, (int)6408, (int)5121, (IntBuffer)null);
                int j = GlStateManager.getTexLevelParameter((int)32868, (int)0, (int)4096);
                if (j == 0) continue;
                field_211120_F = i;
                return i;
            }
            field_211120_F = MathHelper.func_76125_a((int)GlStateManager.getInteger((int)3379), (int)1024, (int)16384);
            field_147123_G.info("Failed to determine maximum texture size by probing, trying GL_MAX_TEXTURE_SIZE = {}", (Object)field_211120_F);
        }
        return field_211120_F;
    }

    public void func_71351_a(ServerData serverDataIn) {
        this.field_71422_O = serverDataIn;
    }

    @Nullable
    public ServerData func_147104_D() {
        return this.field_71422_O;
    }

    public boolean func_71387_A() {
        return this.field_71455_al;
    }

    public boolean func_71356_B() {
        return this.field_71455_al && this.field_71437_Z != null;
    }

    @Nullable
    public IntegratedServer func_71401_C() {
        return this.field_71437_Z;
    }

    public Snooper func_71378_E() {
        return this.field_71427_U;
    }

    public Session func_110432_I() {
        return this.field_71449_j;
    }

    public PropertyMap func_181037_M() {
        if (this.field_181038_N.isEmpty()) {
            GameProfile gameprofile = this.func_152347_ac().fillProfileProperties(this.field_71449_j.func_148256_e(), false);
            this.field_181038_N.putAll((Multimap)gameprofile.getProperties());
        }
        return this.field_181038_N;
    }

    public Proxy func_110437_J() {
        return this.field_110453_aa;
    }

    public TextureManager func_110434_K() {
        return this.field_71446_o;
    }

    public IResourceManager func_195551_G() {
        return this.field_110451_am;
    }

    public ResourcePackList<ClientResourcePackInfo> func_195548_H() {
        return this.field_110448_aq;
    }

    public DownloadingPackFinder func_195541_I() {
        return this.field_195554_ax;
    }

    public File func_195549_J() {
        return this.field_130070_K;
    }

    public LanguageManager func_135016_M() {
        return this.field_135017_as;
    }

    public AtlasTexture func_147117_R() {
        return this.field_147128_au;
    }

    public boolean func_147111_S() {
        return this.field_147129_ai;
    }

    public boolean func_147113_T() {
        return this.field_71445_n;
    }

    public SoundHandler func_147118_V() {
        return this.field_147127_av;
    }

    public MusicTicker.MusicType func_147109_W() {
        MusicTicker.MusicType type;
        MusicTicker.MusicType musicType = type = this.field_71441_e == null || this.field_71441_e.field_73011_w == null ? null : this.field_71441_e.field_73011_w.getMusicType();
        if (type != null) {
            return type;
        }
        if (this.field_71462_r instanceof WinGameScreen) {
            return MusicTicker.MusicType.CREDITS;
        }
        if (this.field_71439_g == null) {
            return MusicTicker.MusicType.MENU;
        }
        if (this.field_71439_g.field_70170_p.field_73011_w instanceof NetherDimension) {
            return MusicTicker.MusicType.NETHER;
        }
        if (this.field_71439_g.field_70170_p.field_73011_w instanceof EndDimension) {
            return this.field_71456_v.func_184046_j().func_184054_d() ? MusicTicker.MusicType.END_BOSS : MusicTicker.MusicType.END;
        }
        Biome.Category biome$category = this.field_71439_g.field_70170_p.func_180494_b(new BlockPos((Entity)this.field_71439_g)).func_201856_r();
        if (!this.field_147126_aw.func_209100_b(MusicTicker.MusicType.UNDER_WATER) && (!this.field_71439_g.func_204231_K() || this.field_147126_aw.func_209100_b(MusicTicker.MusicType.GAME) || biome$category != Biome.Category.OCEAN && biome$category != Biome.Category.RIVER)) {
            return this.field_71439_g.field_71075_bZ.field_75098_d && this.field_71439_g.field_71075_bZ.field_75101_c ? MusicTicker.MusicType.CREATIVE : MusicTicker.MusicType.GAME;
        }
        return MusicTicker.MusicType.UNDER_WATER;
    }

    public MinecraftSessionService func_152347_ac() {
        return this.field_152355_az;
    }

    public SkinManager func_152342_ad() {
        return this.field_152350_aA;
    }

    @Nullable
    public Entity func_175606_aa() {
        return this.field_175622_Z;
    }

    public void func_175607_a(Entity viewingEntity) {
        this.field_175622_Z = viewingEntity;
        this.field_71460_t.func_175066_a(viewingEntity);
    }

    protected Thread func_213170_ax() {
        return this.field_152352_aC;
    }

    protected Runnable func_212875_d_(Runnable runnable) {
        return runnable;
    }

    protected boolean func_212874_c_(Runnable runnable) {
        return true;
    }

    public BlockRendererDispatcher func_175602_ab() {
        return this.field_175618_aM;
    }

    public EntityRendererManager func_175598_ae() {
        return this.field_175616_W;
    }

    public ItemRenderer func_175599_af() {
        return this.field_175621_X;
    }

    public FirstPersonRenderer func_175597_ag() {
        return this.field_175620_Y;
    }

    public <T> IMutableSearchTree<T> func_213253_a(SearchTreeManager.Key<T> p_213253_1_) {
        return this.field_193995_ae.func_215358_a(p_213253_1_);
    }

    public static int func_175610_ah() {
        return field_71470_ab;
    }

    public FrameTimer func_181539_aj() {
        return this.field_181542_y;
    }

    public boolean func_181540_al() {
        return this.field_181541_X;
    }

    public void func_181537_a(boolean isConnected) {
        this.field_181541_X = isConnected;
    }

    public DataFixer func_184126_aj() {
        return this.field_184131_U;
    }

    public float func_184121_ak() {
        return this.field_71428_T.field_194147_b;
    }

    public float func_193989_ak() {
        return this.field_71428_T.field_194148_c;
    }

    public BlockColors func_184125_al() {
        return this.field_184127_aH;
    }

    public boolean func_189648_am() {
        return this.field_71439_g != null && this.field_71439_g.func_175140_cp() || this.field_71474_y.field_178879_v;
    }

    public ToastGui func_193033_an() {
        return this.field_193034_aS;
    }

    public Tutorial func_193032_ao() {
        return this.field_193035_aW;
    }

    public boolean func_195544_aj() {
        return this.field_195555_I;
    }

    public CreativeSettings func_199403_al() {
        return this.field_191950_u;
    }

    public ModelManager func_209506_al() {
        return this.field_175617_aL;
    }

    public FontResourceManager func_211500_ak() {
        return this.field_211501_aD;
    }

    public PaintingSpriteUploader func_213263_ao() {
        return this.field_213272_aL;
    }

    public PotionSpriteUploader func_213248_ap() {
        return this.field_213273_aM;
    }

    public void func_213228_a(boolean focused) {
        this.field_195555_I = focused;
    }

    public IProfiler func_213239_aq() {
        return this.field_71424_I;
    }

    public MinecraftGame func_213229_ar() {
        return this.field_213274_aO;
    }

    public Splashes func_213269_at() {
        return this.field_213271_aF;
    }

    @Nullable
    public LoadingGui func_213250_au() {
        return this.field_213279_p;
    }

    public ItemColors getItemColors() {
        return this.field_184128_aI;
    }

    public SearchTreeManager getSearchTreeManager() {
        return this.field_193995_ae;
    }

    private static /* synthetic */ IResourcePack lambda$null$1(Supplier p_213262_2_) {
        return new LegacyResourcePackWrapper((IResourcePack)p_213262_2_.get(), LegacyResourcePackWrapper.field_211853_a);
    }
}

