/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.block;

import java.util.Random;
import net.minecraft.block.AttachedStemBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.ToolType;

public class FertilizedDirtBlock
extends Block {
    private static final VoxelShape SHAPE_TILLED = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    public static final BooleanProperty TILLED = BooleanProperty.func_177716_a((String)"tilled");

    public FertilizedDirtBlock() {
        super(Block.Properties.func_200949_a((Material)Material.field_151578_c, (MaterialColor)MaterialColor.field_151664_l).func_200943_b(0.5f).func_200947_a(SoundType.field_185849_b).func_200944_c());
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)TILLED, (Comparable)Boolean.valueOf(false)));
    }

    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        BlockState aboveState;
        Block aboveBlock;
        super.func_196267_b(state, worldIn, pos, random);
        for (int i = 0; i < 3 && (aboveBlock = (aboveState = worldIn.func_180495_p(pos.func_177984_a())).func_177230_c()) instanceof IPlantable && aboveState.func_204519_t(); ++i) {
            aboveState.func_196944_b(worldIn, pos.func_177984_a(), random);
        }
    }

    public boolean isToolEffective(BlockState state, ToolType tool) {
        return tool == ToolType.SHOVEL;
    }

    public boolean func_220074_n(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)TILLED);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (Boolean)state.func_177229_b((IProperty)TILLED) != false ? SHAPE_TILLED : VoxelShapes.func_197868_b();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{TILLED});
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        PlantType plantType = plantable.getPlantType(world, pos.func_177984_a());
        boolean tilled = (Boolean)state.func_177229_b((IProperty)TILLED);
        Block b = plantable.getPlant(world, pos.func_177972_a(facing)).func_177230_c();
        if (b.getBlock() instanceof AttachedStemBlock) {
            return true;
        }
        switch (plantType) {
            case Desert: {
                return !tilled;
            }
            case Nether: {
                return false;
            }
            case Crop: {
                return tilled;
            }
            case Cave: {
                return !tilled;
            }
            case Plains: {
                return !tilled || tilled && world.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_185773_cZ;
            }
            case Water: {
                return false;
            }
            case Beach: {
                return !tilled;
            }
        }
        return false;
    }

    public boolean isFertile(BlockState state, IBlockReader world, BlockPos pos) {
        return true;
    }
}

