/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block.machine;

import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.block.BlockContainerBase;
import com.bluepowermod.block.machine.BlockLampRGB;
import com.bluepowermod.client.render.IBPColoredBlock;
import com.bluepowermod.client.render.ICustomModelBlock;
import com.bluepowermod.client.render.RenderLamp;
import com.bluepowermod.tile.tier1.TileLamp;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockLamp
extends BlockContainerBase
implements ICustomModelBlock,
IBPColoredBlock {
    public static final IntegerProperty POWER = IntegerProperty.func_177719_a((String)"power", (int)0, (int)15);
    private final boolean isInverted;
    private final MinecraftColor color;
    private final String name;

    public BlockLamp(String name, boolean isInverted, MinecraftColor color) {
        super(Block.Properties.func_200945_a((Material)Material.field_151591_t).func_200947_a(SoundType.field_185851_d).func_200943_b(1.0f).func_200951_a(15), TileLamp.class);
        this.isInverted = isInverted;
        this.color = color;
        this.name = name;
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)POWER, (Comparable)Integer.valueOf(isInverted ? 15 : 0)));
        this.setRegistryName(name + (isInverted ? "inverted" : "") + "_" + (color == MinecraftColor.NONE ? "rgb" : color.name().toLowerCase()));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initModel() {
    }

    @Override
    protected TileLamp get(IBlockReader w, BlockPos pos) {
        TileEntity te = w.func_175625_s(pos);
        if (!(te instanceof TileLamp)) {
            return null;
        }
        return (TileLamp)te;
    }

    public int getLightValue(BlockState state, IEnviromentBlockReader w, BlockPos pos) {
        return (Integer)state.func_177229_b((IProperty)POWER);
    }

    public int func_149750_m(BlockState state) {
        return (Integer)state.func_177229_b((IProperty)POWER);
    }

    @Override
    public int getColor(IBlockReader w, BlockPos pos, int tint) {
        return this.color.getHex();
    }

    @Override
    public int getColor(int tint) {
        return this.color.getHex();
    }

    public boolean isInverted() {
        return this.isInverted;
    }

    @Override
    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return !(world.func_180495_p(pos).func_177230_c() instanceof BlockLampRGB) && super.canConnectRedstone(state, world, pos, side);
    }

    public boolean canRenderInLayer(BlockState state, BlockRenderLayer layer) {
        RenderLamp.pass = layer.ordinal();
        return super.canRenderInLayer(state, layer);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{POWER});
    }

    public BlockState getStateForPlacement(BlockState state, Direction facing, BlockState state2, IWorld world, BlockPos pos1, BlockPos pos2, Hand hand) {
        return super.getStateForPlacement(state, facing, state2, world, pos1, pos2, hand);
    }

    @Override
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean bool) {
        super.func_220069_a(state, world, pos, blockIn, fromPos, bool);
        int redstoneValue = world.func_175687_A(pos);
        if (this.isInverted) {
            redstoneValue = 15 - redstoneValue;
        }
        world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)POWER, (Comparable)Integer.valueOf(redstoneValue)), 2);
    }
}

