/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.api.wire.redstone;

public enum RedwireType {
    BLUESTONE(false, false, 0x1B1B51, 0x4444CC, "ingotBlueAlloy"),
    RED_ALLOY(true, true, 0x470000, 0xBB0000, "ingotRedAlloy"),
    INFUSED_TESLATITE(true, false, 3801150, 0xAA00BB, "ingotPurpleAlloy");

    private boolean analogue;
    private boolean loss;
    private int minColor;
    private int maxColor;
    private String ingotOredictName;

    private RedwireType(boolean analogue, boolean loss, int minColor, int maxColor, String ingotOredictName) {
        this.analogue = analogue;
        this.loss = loss;
        this.minColor = minColor;
        this.maxColor = maxColor;
        this.ingotOredictName = ingotOredictName;
    }

    public boolean isAnalogue() {
        return this.analogue;
    }

    public boolean hasLoss() {
        return this.loss;
    }

    public String getName() {
        return this.name().toLowerCase().replace("_", "");
    }

    public int getMinColor() {
        return this.minColor;
    }

    public int getMaxColor() {
        return this.maxColor;
    }

    public String getIngotOredictName() {
        return this.ingotOredictName;
    }

    public boolean canConnectTo(RedwireType type) {
        if (type == null) {
            return false;
        }
        return type == this;
    }
}

