/*
 * Decompiled with CFR 0.152.
 */
package lumien.quickleafdecay;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.LogicalSide;

public class LeafTickScheduler {
    public static LeafTickScheduler INSTANCE = new LeafTickScheduler();
    List<ScheduledTick> planned = new ArrayList<ScheduledTick>();
    List<ScheduledTick> scheduled = new ArrayList<ScheduledTick>();

    public void schedule(World world, BlockPos pos, int delay) {
        this.planned.add(new ScheduledTick(world, pos, delay));
    }

    public void tick(TickEvent.ServerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END) {
            if (!this.planned.isEmpty()) {
                this.scheduled.addAll(this.planned);
                this.planned.clear();
            }
            Iterator<ScheduledTick> iterator = this.scheduled.iterator();
            while (iterator.hasNext()) {
                BlockState state;
                ScheduledTick st = iterator.next();
                if (--st.tick > 0) continue;
                iterator.remove();
                World worldObj = (World)st.worldReference.get();
                if (worldObj == null || !worldObj.func_175667_e(st.pos) || !BlockTags.field_206952_E.func_199685_a_((Object)(state = worldObj.func_180495_p(st.pos)).func_177230_c())) continue;
                state.func_196940_a(worldObj, st.pos, worldObj.func_201674_k());
                state.func_196944_b(worldObj, st.pos, worldObj.func_201674_k());
            }
        }
    }

    class ScheduledTick {
        WeakReference<World> worldReference;
        BlockPos pos;
        int tick;

        public ScheduledTick(World worldObj, BlockPos pos, int tick) {
            this.worldReference = new WeakReference<World>(worldObj);
            this.pos = pos;
            this.tick = tick;
        }
    }
}

