/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.village;

import com.google.common.base.Predicates;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.passive.horse.TraderLlamaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WanderingTraderSpawner;
import net.minecraft.world.storage.WorldInfo;

public class WandererSpawnerExt
extends WanderingTraderSpawner {
    public static int defaultDelay = 24000;
    public static int defaultChance = 10;
    protected final Random field_221246_a = new Random();
    protected final ServerWorld field_221247_b;
    protected int delay;
    protected int spawnDelay;
    protected int spawnChance;
    static AxisAlignedBB aabb = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 2.0, 1.0);

    public WandererSpawnerExt(ServerWorld world) {
        super(world);
        this.field_221247_b = world;
        this.delay = 1200;
        WorldInfo worldinfo = world.func_72912_H();
        this.spawnDelay = worldinfo.func_215765_R();
        this.spawnChance = worldinfo.func_215760_S();
        if (this.spawnDelay == 0 && this.spawnChance == 0) {
            this.spawnDelay = defaultDelay;
            worldinfo.func_215764_j(this.spawnDelay);
            this.spawnChance = defaultChance;
            worldinfo.func_215762_k(this.spawnChance);
        }
    }

    public void func_221242_a() {
        if (--this.delay <= 0) {
            this.delay = 1200;
            WorldInfo worldinfo = this.field_221247_b.func_72912_H();
            this.spawnDelay -= 1200;
            worldinfo.func_215764_j(this.spawnDelay);
            if (this.spawnDelay <= 0) {
                this.spawnDelay = defaultDelay;
                if (this.field_221247_b.func_82736_K().func_223586_b(GameRules.field_223601_d)) {
                    int i = this.spawnChance;
                    this.spawnChance = MathHelper.func_76125_a((int)(this.spawnChance + defaultChance), (int)defaultChance, (int)100);
                    worldinfo.func_215762_k(this.spawnChance);
                    if (this.field_221246_a.nextInt(100) <= i && this.spawnTrader()) {
                        this.spawnChance = defaultChance;
                    }
                }
            }
        }
    }

    protected boolean spawnTrader() {
        ServerPlayerEntity player = this.field_221247_b.func_217472_l_();
        if (player == null) {
            return false;
        }
        BlockPos pos = player.func_180425_c();
        PointOfInterestManager poiMgr = this.field_221247_b.func_217443_B();
        Optional optional = poiMgr.func_219127_a(PointOfInterestType.field_221070_r.func_221045_c(), (Predicate)Predicates.alwaysTrue(), pos, 48, PointOfInterestManager.Status.ANY);
        BlockPos poiPos = optional.orElse(pos);
        BlockPos spawnPos = this.findSpawnPoint(poiPos, 48);
        if (spawnPos != null) {
            if (this.field_221247_b.func_180494_b(spawnPos) == Biomes.field_185440_P) {
                return false;
            }
            WanderingTraderEntity wanderingtraderentity = (WanderingTraderEntity)EntityType.field_220351_aK.func_220342_a((World)this.field_221247_b, null, null, null, spawnPos, SpawnReason.EVENT, false, false);
            if (wanderingtraderentity != null) {
                for (int j = 0; j < 2; ++j) {
                    this.spawnLlamas(wanderingtraderentity, 4);
                }
                this.field_221247_b.func_72912_H().func_215761_a(wanderingtraderentity.func_110124_au());
                wanderingtraderentity.func_213728_s(48000);
                wanderingtraderentity.func_213726_g(poiPos);
                wanderingtraderentity.func_213390_a(poiPos, 16);
                return true;
            }
        }
        return false;
    }

    protected void spawnLlamas(WanderingTraderEntity p_221243_1_, int p_221243_2_) {
        TraderLlamaEntity traderllamaentity;
        BlockPos blockpos = this.findSpawnPoint(new BlockPos((Entity)p_221243_1_), p_221243_2_);
        if (blockpos != null && (traderllamaentity = (TraderLlamaEntity)EntityType.field_220354_ax.func_220342_a((World)this.field_221247_b, (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, blockpos, SpawnReason.EVENT, false, false)) != null) {
            traderllamaentity.func_110162_b((Entity)p_221243_1_, true);
        }
    }

    @Nullable
    protected BlockPos findSpawnPoint(BlockPos pos, int radius) {
        for (int i = 0; i < 10; ++i) {
            int k;
            int l;
            int j = pos.func_177958_n() + this.field_221246_a.nextInt(radius * 2) - radius;
            BlockPos spawnPos = new BlockPos(j, l = this.field_221247_b.func_201676_a(Heightmap.Type.WORLD_SURFACE, j, k = pos.func_177952_p() + this.field_221246_a.nextInt(radius * 2) - radius), k);
            if (!this.field_221247_b.func_180495_p(spawnPos).func_177230_c().func_181623_g() && !this.field_221247_b.func_217351_c(aabb.func_186670_a(spawnPos))) continue;
            return spawnPos;
        }
        return null;
    }
}

