/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.spawn.modifiers;

import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import shadows.apotheosis.spawn.SpawnerModifiers;
import shadows.apotheosis.spawn.TileSpawnerExt;
import shadows.placebo.config.Configuration;

public abstract class SpawnerModifier {
    public static final String ITEM = "item";
    public static final String VALUE = "value";
    public static final String MIN = "min_value";
    public static final String MAX = "max_value";
    protected Ingredient item;
    protected int value;
    protected int min;
    protected int max;

    public SpawnerModifier(Ingredient item, int value) {
        this.item = item;
        this.value = value;
    }

    public SpawnerModifier(ItemStack item, int value) {
        this(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{item}), value);
    }

    public boolean canModify(TileSpawnerExt spawner, ItemStack stack, boolean inverting) {
        return this.item.test(stack);
    }

    public abstract boolean modify(TileSpawnerExt var1, ItemStack var2, boolean var3);

    public void load(Configuration cfg) {
        String s = cfg.getString(ITEM, this.getCategory(), this.getDefaultItem(), "The item that applies this modifier.");
        this.item = SpawnerModifiers.readStackCfg(s);
        this.value = cfg.getInt(VALUE, this.getCategory(), this.value, Integer.MIN_VALUE, Integer.MAX_VALUE, "The amount each item changes this stat.");
        this.min = cfg.getInt(MIN, this.getCategory(), 0, Integer.MIN_VALUE, Integer.MAX_VALUE, "The min value of this stat.");
        this.max = cfg.getInt(MAX, this.getCategory(), Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, "The max value of this stat.");
    }

    public Ingredient getIngredient() {
        return this.item;
    }

    public int getValue() {
        return this.value;
    }

    public void setIngredient(Ingredient item) {
        this.item = item;
    }

    public abstract String getCategory();

    public abstract String getDefaultItem();
}

