/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.spawn;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.spawner.AbstractSpawner;
import net.minecraftforge.event.ForgeEventFactory;

public class TileSpawnerExt
extends MobSpawnerTileEntity {
    public boolean ignoresPlayers = false;
    public boolean ignoresConditions = false;
    public boolean ignoresCap = false;
    public boolean redstoneEnabled = false;

    public TileSpawnerExt() {
        this.field_145882_a = new SpawnerLogicExt();
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74757_a("ignore_players", this.ignoresPlayers);
        tag.func_74757_a("ignore_conditions", this.ignoresConditions);
        tag.func_74757_a("ignore_cap", this.ignoresPlayers);
        tag.func_74757_a("redstone_control", this.redstoneEnabled);
        return super.func_189515_b(tag);
    }

    public void func_145839_a(CompoundNBT tag) {
        this.ignoresPlayers = tag.func_74767_n("ignore_players");
        this.ignoresConditions = tag.func_74767_n("ignore_conditions");
        this.ignoresCap = tag.func_74767_n("ignore_cap");
        this.redstoneEnabled = tag.func_74767_n("redstone_control");
        super.func_145839_a(tag);
    }

    public void setIgnoresPlayers(boolean val) {
        this.ignoresPlayers = val;
    }

    public void setIgnoresConditions(boolean val) {
        this.ignoresConditions = val;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public class SpawnerLogicExt
    extends AbstractSpawner {
        public void func_98267_a(int id) {
            TileSpawnerExt.this.field_145850_b.func_175641_c(TileSpawnerExt.this.field_174879_c, Blocks.field_150474_ac, id, 0);
        }

        public World func_98271_a() {
            return TileSpawnerExt.this.field_145850_b;
        }

        public BlockPos func_177221_b() {
            return TileSpawnerExt.this.field_174879_c;
        }

        public void func_184993_a(WeightedSpawnerEntity p_184993_1_) {
            super.func_184993_a(p_184993_1_);
            if (this.func_98271_a() != null) {
                BlockState iblockstate = this.func_98271_a().func_180495_p(this.func_177221_b());
                this.func_98271_a().func_184138_a(TileSpawnerExt.this.field_174879_c, iblockstate, iblockstate, 4);
            }
        }

        private boolean isActivated() {
            BlockPos blockpos = this.func_177221_b();
            boolean flag = TileSpawnerExt.this.ignoresPlayers || this.func_98271_a().func_217358_a((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5, (double)this.field_98289_l);
            return flag && (!TileSpawnerExt.this.redstoneEnabled || TileSpawnerExt.this.field_145850_b.func_175640_z(blockpos));
        }

        private void resetTimer() {
            if (this.field_98293_h <= this.field_98283_g) {
                this.field_98286_b = this.field_98283_g;
            } else {
                int i = this.field_98293_h - this.field_98283_g;
                this.field_98286_b = this.field_98283_g + this.func_98271_a().field_73012_v.nextInt(i);
            }
            if (!this.field_98285_e.isEmpty()) {
                this.func_184993_a((WeightedSpawnerEntity)WeightedRandom.func_76271_a((Random)this.func_98271_a().field_73012_v, (List)this.field_98285_e));
            }
            this.func_98267_a(1);
        }

        public void func_98278_g() {
            if (!this.isActivated()) {
                this.field_98284_d = this.field_98287_c;
            } else {
                World world = this.func_98271_a();
                BlockPos blockpos = this.func_177221_b();
                if (world.field_72995_K) {
                    double d3 = (float)blockpos.func_177958_n() + world.field_73012_v.nextFloat();
                    double d4 = (float)blockpos.func_177956_o() + world.field_73012_v.nextFloat();
                    double d5 = (float)blockpos.func_177952_p() + world.field_73012_v.nextFloat();
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d3, d4, d5, 0.0, 0.0, 0.0);
                    world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d3, d4, d5, 0.0, 0.0, 0.0);
                    if (this.field_98286_b > 0) {
                        --this.field_98286_b;
                    }
                    this.field_98284_d = this.field_98287_c;
                    this.field_98287_c = (this.field_98287_c + (double)(1000.0f / ((float)this.field_98286_b + 200.0f))) % 360.0;
                } else {
                    if (this.field_98286_b == -1) {
                        this.resetTimer();
                    }
                    if (this.field_98286_b > 0) {
                        --this.field_98286_b;
                        return;
                    }
                    boolean flag = false;
                    for (int i = 0; i < this.field_98294_i; ++i) {
                        int k;
                        double z;
                        CompoundNBT compoundnbt = this.field_98282_f.func_185277_b();
                        Optional optional = EntityType.func_220347_a((CompoundNBT)compoundnbt);
                        if (!optional.isPresent()) {
                            this.resetTimer();
                            return;
                        }
                        ListNBT listnbt = compoundnbt.func_150295_c("Pos", 6);
                        int j = listnbt.size();
                        double x = j >= 1 ? listnbt.func_150309_d(0) : (double)blockpos.func_177958_n() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)this.field_98290_m + 0.5;
                        double y = j >= 2 ? listnbt.func_150309_d(1) : (double)(blockpos.func_177956_o() + world.field_73012_v.nextInt(3) - 1);
                        double d = z = j >= 3 ? listnbt.func_150309_d(2) : (double)blockpos.func_177952_p() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)this.field_98290_m + 0.5;
                        if (!TileSpawnerExt.this.ignoresConditions && (!world.func_217351_c(((EntityType)optional.get()).func_220328_a(x, y, z)) || !EntitySpawnPlacementRegistry.func_223515_a((EntityType)((EntityType)optional.get()), (IWorld)world.func_201672_e(), (SpawnReason)SpawnReason.SPAWNER, (BlockPos)new BlockPos(x, y, z), (Random)world.func_201674_k()))) continue;
                        Entity entity = EntityType.func_220335_a((CompoundNBT)compoundnbt, (World)world, p_221408_6_ -> {
                            p_221408_6_.func_70012_b(x, y, z, p_221408_6_.field_70177_z, p_221408_6_.field_70125_A);
                            return p_221408_6_;
                        });
                        if (entity == null) {
                            this.resetTimer();
                            return;
                        }
                        if (!TileSpawnerExt.this.ignoresCap && (k = world.func_217357_a(entity.getClass(), new AxisAlignedBB((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), (double)(blockpos.func_177958_n() + 1), (double)(blockpos.func_177956_o() + 1), (double)(blockpos.func_177952_p() + 1)).func_186662_g((double)this.field_98290_m)).size()) >= this.field_98292_k) {
                            this.resetTimer();
                            return;
                        }
                        entity.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                        if (entity instanceof MobEntity) {
                            MobEntity mobentity = (MobEntity)entity;
                            if (!TileSpawnerExt.this.ignoresConditions && !ForgeEventFactory.canEntitySpawnSpawner((MobEntity)mobentity, (World)world, (float)((float)entity.field_70165_t), (float)((float)entity.field_70163_u), (float)((float)entity.field_70161_v), (AbstractSpawner)this)) continue;
                            if (this.field_98282_f.func_185277_b().func_186856_d() == 1 && this.field_98282_f.func_185277_b().func_150297_b("id", 8) && !ForgeEventFactory.doSpecialSpawn((MobEntity)((MobEntity)entity), (World)this.func_98271_a(), (float)((float)entity.field_70165_t), (float)((float)entity.field_70163_u), (float)((float)entity.field_70161_v), (AbstractSpawner)this, (SpawnReason)SpawnReason.SPAWNER)) {
                                ((MobEntity)entity).func_213386_a((IWorld)world, world.func_175649_E(new BlockPos(entity)), SpawnReason.SPAWNER, (ILivingEntityData)null, (CompoundNBT)null);
                            }
                        }
                        this.spawnEntity(entity);
                        world.func_217379_c(2004, blockpos, 0);
                        if (entity instanceof MobEntity) {
                            ((MobEntity)entity).func_70656_aK();
                        }
                        flag = true;
                    }
                    if (flag) {
                        this.resetTimer();
                    }
                }
            }
        }

        protected void spawnEntity(Entity entity) {
            if (this.func_98271_a().func_217376_c(entity)) {
                for (Entity e : entity.func_184188_bt()) {
                    this.spawnEntity(e);
                }
            }
        }
    }
}

