/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.altar;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;
import shadows.apotheosis.ench.altar.TilePrismaticAltar;

public class BlockPrismaticAltar
extends Block {
    public static final VoxelShape DISPLAY = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)10.0, (double)1.0);
    public static final List<VoxelShape> BOXES = ImmutableList.of((Object)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (Object)Block.func_208617_a((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0), (Object)Block.func_208617_a((double)2.0, (double)4.0, (double)2.0, (double)4.0, (double)10.0, (double)4.0), (Object)Block.func_208617_a((double)2.0, (double)4.0, (double)12.0, (double)4.0, (double)10.0, (double)14.0), (Object)Block.func_208617_a((double)12.0, (double)4.0, (double)2.0, (double)14.0, (double)10.0, (double)4.0), (Object)Block.func_208617_a((double)12.0, (double)4.0, (double)12.0, (double)14.0, (double)10.0, (double)14.0));
    public static final List<VoxelShape> PILLARS = ImmutableList.of((Object)BOXES.get(2), (Object)BOXES.get(3), (Object)BOXES.get(4), (Object)BOXES.get(5));
    public static final VoxelShape SHAPE = BlockPrismaticAltar.merge(BOXES);

    public BlockPrismaticAltar() {
        super(Block.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_197656_x).func_200948_a(1.5f, 10.0f).func_200947_a(SoundType.field_185851_d));
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TilePrismaticAltar)) {
            return false;
        }
        TilePrismaticAltar altar = (TilePrismaticAltar)te;
        Vec3d eyes = player.func_174824_e(1.0f);
        Vec3d look = player.func_70676_i(1.0f);
        double reach = player.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e();
        Vec3d block = eyes.func_72441_c(look.field_72450_a * reach, look.field_72448_b * reach, look.field_72449_c * reach);
        for (int i = 0; i < 4; ++i) {
            if (this.rayTrace(pos, eyes, block, PILLARS.get(i)) == null) continue;
            return this.attemptSwap(altar, i, player, hand);
        }
        double hitX = hit.func_216347_e().field_72450_a - (double)pos.func_177958_n();
        double hitZ = hit.func_216347_e().field_72449_c - (double)pos.func_177952_p();
        if (hitX >= 0.34375 && hitX <= 0.65625 || hitZ >= 0.34375 && hitZ <= 0.65625) {
            this.attemptSwap(altar, 4, player, hand);
        }
        return true;
    }

    @Nullable
    protected RayTraceResult rayTrace(BlockPos pos, Vec3d start, Vec3d end, VoxelShape boundingBox) {
        BlockRayTraceResult result = boundingBox.func_212433_a(start, end, pos);
        return result == null ? null : new BlockRayTraceResult(result.func_216347_e().func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), result.func_216354_b(), pos, result.func_216353_d());
    }

    protected boolean attemptSwap(TilePrismaticAltar altar, int slot, PlayerEntity player, Hand hand) {
        ItemStackHandler inv = altar.getInv();
        ItemStack inAltar = inv.getStackInSlot(slot);
        ItemStack inHand = player.func_184586_b(hand);
        if (slot == 4 && !inHand.func_190926_b()) {
            return true;
        }
        if (inAltar.func_190926_b() && (inHand.func_77948_v() || inHand.func_77973_b() == Items.field_151134_bR)) {
            ItemStack toAltar = inHand.func_77946_l();
            inHand.func_190918_g(1);
            toAltar.func_190920_e(1);
            inv.setStackInSlot(slot, toAltar);
            altar.markAndNotify();
        } else if (!inAltar.func_190926_b() && inHand.func_190926_b()) {
            player.func_184611_a(hand, inAltar.func_77946_l());
            inAltar.func_190920_e(0);
            altar.markAndNotify();
        }
        return true;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return SHAPE;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TilePrismaticAltar();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Deprecated
    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TilePrismaticAltar) {
            ItemStackHandler inv = ((TilePrismaticAltar)te).inv;
            for (int i = 0; i < inv.getSlots(); ++i) {
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)inv.getStackInSlot(i));
            }
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    private static VoxelShape merge(List<VoxelShape> shapes) {
        VoxelShape shape = shapes.get(0);
        for (VoxelShape s : shapes) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)s, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        return shape;
    }
}

