/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.network;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.Supplier;
import mcjty.lib.network.ICommandHandler;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsutility.network.PacketPlayersReady;
import mcjty.rftoolsutility.network.RFToolsUtilityMessages;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketGetPlayers {
    protected BlockPos pos;
    protected String command;
    protected TypedMap params;
    private String clientcmd;

    public PacketGetPlayers(PacketBuffer buf) {
        this.pos = NetworkTools.readPos((ByteBuf)buf);
        this.command = NetworkTools.readString((ByteBuf)buf);
        this.params = TypedMapTools.readArguments((PacketBuffer)buf);
        this.clientcmd = NetworkTools.readString((ByteBuf)buf);
    }

    public void toBytes(PacketBuffer buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        NetworkTools.writeString((ByteBuf)buf, (String)this.command);
        TypedMapTools.writeArguments((PacketBuffer)buf, (TypedMap)this.params);
        NetworkTools.writeString((ByteBuf)buf, (String)this.clientcmd);
    }

    public PacketGetPlayers() {
    }

    public PacketGetPlayers(BlockPos pos, String cmd, String clientcmd) {
        this.pos = pos;
        this.command = cmd;
        this.params = TypedMap.EMPTY;
        this.clientcmd = clientcmd;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            TileEntity te = ctx.getSender().func_130014_f_().func_175625_s(this.pos);
            if (!(te instanceof ICommandHandler)) {
                Logging.log((String)"createStartScanPacket: TileEntity is not a CommandHandler!");
                return;
            }
            ICommandHandler commandHandler = (ICommandHandler)te;
            List list = commandHandler.executeWithResultList(this.command, this.params, Type.STRING);
            RFToolsUtilityMessages.INSTANCE.sendTo((Object)new PacketPlayersReady(this.pos, this.clientcmd, list), ctx.getSender().field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        });
        ctx.setPacketHandled(true);
    }
}

