/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.items.porter;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import mcjty.lib.McJtyLib;
import mcjty.lib.crafting.INBTPreservingIngredient;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.IEnergyItem;
import mcjty.lib.varia.ItemCapabilityProvider;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsutility.RFToolsUtility;
import mcjty.rftoolsutility.modules.teleporter.TeleportConfiguration;
import mcjty.rftoolsutility.modules.teleporter.TeleportationTools;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterReceiverTileEntity;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinations;
import mcjty.rftoolsutility.setup.ForgeEventHandlers;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ChargedPorterItem
extends Item
implements IEnergyItem,
INBTPreservingIngredient {
    private int capacity;
    private int maxReceive;
    private int maxExtract;

    public ChargedPorterItem() {
        this("charged_porter");
    }

    protected ChargedPorterItem(String name) {
        this(name, (Integer)TeleportConfiguration.CHARGEDPORTER_MAXENERGY.get());
    }

    protected ChargedPorterItem(String name, int capacity) {
        super(new Item.Properties().func_200917_a(1).func_200915_b(1).func_200916_a(RFToolsUtility.setup.getTab()));
        this.setRegistryName(name);
        this.capacity = capacity;
        this.maxReceive = (Integer)TeleportConfiguration.CHARGEDPORTER_RECEIVEPERTICK.get();
        this.maxExtract = 0;
        this.initOverrides();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.func_190926_b() != newStack.func_190926_b()) {
            return true;
        }
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new ItemCapabilityProvider(stack, (IEnergyItem)this);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.field_72995_K) {
            CompoundNBT tagCompound = stack.func_77978_p();
            if (tagCompound == null) {
                return;
            }
            if (!tagCompound.func_74764_b("tpTimer")) {
                return;
            }
            if (!(entityIn instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)entityIn;
            int timer = tagCompound.func_74762_e("tpTimer");
            if (--timer <= 0) {
                tagCompound.func_82580_o("tpTimer");
                TeleportDestinations destinations = TeleportDestinations.get();
                int target = tagCompound.func_74762_e("target");
                GlobalCoordinate coordinate = destinations.getCoordinateForId(target);
                if (coordinate == null) {
                    Logging.message((PlayerEntity)player, (String)(TextFormatting.RED + "Something went wrong! The target has disappeared!"));
                    TeleportationTools.applyEffectForSeverity(player, 3, false);
                    return;
                }
                TeleportDestination destination = destinations.getDestination(coordinate);
                ForgeEventHandlers.addPlayerToTeleportHere(destination, player);
            } else {
                tagCompound.func_74768_a("tpTimer", timer);
            }
        }
    }

    private void initOverrides() {
        this.func_185043_a(new ResourceLocation("rftoolsutility", "charge"), (stack, world, livingEntity) -> {
            CompoundNBT tagCompound = stack.func_77978_p();
            int energy = tagCompound == null ? 0 : tagCompound.func_74762_e("Energy");
            int level = 9 * energy / this.capacity;
            if (level < 0) {
                level = 0;
            } else if (level > 8) {
                level = 8;
            }
            return 9 - level;
        });
    }

    protected int getSpeedBonus() {
        return 1;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_70093_af()) {
            this.startTeleport(stack, player, world);
        } else {
            this.selectReceiver(stack, world, player);
        }
        return super.func_77659_a(world, player, hand);
    }

    protected void selectReceiver(ItemStack stack, World world, PlayerEntity player) {
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            TileEntity te = world.func_175625_s(pos);
            this.setTarget(stack, player, world, te);
        } else {
            this.startTeleport(stack, player, world);
        }
        return ActionResultType.SUCCESS;
    }

    private void startTeleport(ItemStack stack, PlayerEntity player, World world) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null || !tagCompound.func_74764_b("target") || tagCompound.func_74762_e("target") == -1) {
            if (world.field_72995_K) {
                Logging.message((PlayerEntity)player, (String)(TextFormatting.RED + "The charged porter has no target."));
            }
            return;
        }
        if (!world.field_72995_K) {
            if (tagCompound.func_74764_b("tpTimer")) {
                Logging.message((PlayerEntity)player, (String)(TextFormatting.RED + "Already teleporting!"));
                return;
            }
            int target = tagCompound.func_74762_e("target");
            TeleportDestinations destinations = TeleportDestinations.get();
            GlobalCoordinate coordinate = destinations.getCoordinateForId(target);
            if (coordinate == null) {
                Logging.message((PlayerEntity)player, (String)(TextFormatting.RED + "Something went wrong! The target has disappeared!"));
                TeleportationTools.applyEffectForSeverity(player, 3, false);
                return;
            }
            TeleportDestination destination = destinations.getDestination(coordinate);
            if (!TeleportationTools.checkValidTeleport(player, world.func_201675_m().func_186058_p(), destination.getDimension())) {
                return;
            }
            BlockPos playerCoordinate = new BlockPos((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            int cost = TeleportationTools.calculateRFCost(world, playerCoordinate, destination);
            long energy = this.getEnergyStoredL(stack);
            if ((long)(cost = (int)((float)cost * 1.5f)) > energy) {
                Logging.message((PlayerEntity)player, (String)(TextFormatting.RED + "Not enough energy to start the teleportation!"));
                return;
            }
            this.extractEnergyNoMax(stack, cost, false);
            int ticks = TeleportationTools.calculateTime(world, playerCoordinate, destination);
            tagCompound.func_74768_a("tpTimer", ticks /= this.getSpeedBonus());
            Logging.message((PlayerEntity)player, (String)(TextFormatting.YELLOW + "Start teleportation!"));
        }
    }

    private void setTarget(ItemStack stack, PlayerEntity player, World world, TileEntity te) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new CompoundNBT();
        }
        int id = -1;
        if (te instanceof MatterReceiverTileEntity) {
            MatterReceiverTileEntity matterReceiverTileEntity = (MatterReceiverTileEntity)te;
            if (!matterReceiverTileEntity.checkAccess(player.func_110124_au())) {
                Logging.message((PlayerEntity)player, (String)(TextFormatting.RED + "You have no access to target this receiver!"));
                return;
            }
            id = matterReceiverTileEntity.getId();
        }
        if (id != -1) {
            this.selectOnReceiver(player, world, tagCompound, id);
        } else {
            this.selectOnThinAir(player, world, tagCompound, stack);
        }
        stack.func_77982_d(tagCompound);
    }

    protected void selectOnReceiver(PlayerEntity player, World world, CompoundNBT tagCompound, int id) {
        if (world.field_72995_K) {
            Logging.message((PlayerEntity)player, (String)("Charged porter target is set to " + id + "."));
        }
        tagCompound.func_74768_a("target", id);
    }

    protected void selectOnThinAir(PlayerEntity player, World world, CompoundNBT tagCompound, ItemStack stack) {
        if (world.field_72995_K) {
            Logging.message((PlayerEntity)player, (String)"Charged porter is cleared.");
        }
        tagCompound.func_82580_o("target");
    }

    public void func_77624_a(ItemStack itemStack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, list, flag);
        CompoundNBT tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + "Energy: " + tagCompound.func_74762_e("Energy") + " RF"));
            if (tagCompound.func_74764_b("target")) {
                list.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + "Target: " + tagCompound.func_74762_e("target")));
            } else {
                list.add((ITextComponent)new StringTextComponent(TextFormatting.RED + "No target set! Sneak-Right click on receiver to set."));
            }
        }
        if (McJtyLib.proxy.isShiftKeyDown()) {
            list.add((ITextComponent)new StringTextComponent("This RF/charged item allows you to teleport to a"));
            list.add((ITextComponent)new StringTextComponent("previously set matter receiver. Sneak-right click"));
            list.add((ITextComponent)new StringTextComponent("on a receiver to set the destination."));
            list.add((ITextComponent)new StringTextComponent("Right click to perform the teleport."));
        } else {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "<Press Shift>"));
        }
    }

    public long receiveEnergyL(ItemStack container, long maxReceive, boolean simulate) {
        if (container.func_77978_p() == null) {
            container.func_77982_d(new CompoundNBT());
        }
        int energy = container.func_77978_p().func_74762_e("Energy");
        int energyReceived = Math.min(this.capacity - energy, Math.min(this.maxReceive, EnergyTools.unsignedClampToInt((long)maxReceive)));
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    public long extractEnergyL(ItemStack container, long maxExtract, boolean simulate) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Energy")) {
            return 0L;
        }
        int energy = container.func_77978_p().func_74762_e("Energy");
        int energyExtracted = Math.min(energy, Math.min(this.maxExtract, EnergyTools.unsignedClampToInt((long)maxExtract)));
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public int extractEnergyNoMax(ItemStack container, int maxExtract, boolean simulate) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Energy")) {
            return 0;
        }
        int energy = container.func_77978_p().func_74762_e("Energy");
        int energyExtracted = Math.min(energy, maxExtract);
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public long getEnergyStoredL(ItemStack container) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Energy")) {
            return 0L;
        }
        return container.func_77978_p().func_74762_e("Energy");
    }

    public long getMaxEnergyStoredL(ItemStack container) {
        return this.capacity;
    }

    public Collection<String> getTagsToPreserve() {
        return Arrays.asList("Energy");
    }
}

