/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.data;

import io.netty.buffer.ByteBuf;
import mcjty.lib.network.NetworkTools;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.dimension.DimensionType;

public class TeleportDestination {
    private final BlockPos coordinate;
    private final DimensionType dimension;
    private String name = "";

    public TeleportDestination(PacketBuffer buf) {
        int cx = buf.readInt();
        int cy = buf.readInt();
        int cz = buf.readInt();
        this.coordinate = cx == -1 && cy == -1 && cz == -1 ? null : new BlockPos(cx, cy, cz);
        this.dimension = DimensionType.func_186069_a((int)buf.readInt());
        this.setName(NetworkTools.readString((ByteBuf)buf));
    }

    public TeleportDestination(BlockPos coordinate, DimensionType dimension) {
        this.coordinate = coordinate;
        this.dimension = dimension;
    }

    public boolean isValid() {
        return this.coordinate != null;
    }

    public void toBytes(PacketBuffer buf) {
        if (this.coordinate == null) {
            buf.writeInt(-1);
            buf.writeInt(-1);
            buf.writeInt(-1);
        } else {
            buf.writeInt(this.coordinate.func_177958_n());
            buf.writeInt(this.coordinate.func_177956_o());
            buf.writeInt(this.coordinate.func_177952_p());
        }
        buf.writeInt(this.dimension.func_186068_a());
        NetworkTools.writeString((ByteBuf)buf, (String)this.getName());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? "" : name;
    }

    public BlockPos getCoordinate() {
        return this.coordinate;
    }

    public DimensionType getDimension() {
        return this.dimension;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TeleportDestination that = (TeleportDestination)o;
        if (!this.dimension.equals(that.dimension)) {
            return false;
        }
        if (this.coordinate != null ? !this.coordinate.equals((Object)that.coordinate) : that.coordinate != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.coordinate != null ? this.coordinate.hashCode() : 0;
        result = 31 * result + this.dimension.func_186068_a();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }
}

