/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.client;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.DefaultSelectionEvent;
import mcjty.lib.gui.events.SelectionEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinationClientInfo;
import mcjty.rftoolsutility.modules.teleporter.network.PacketGetAllReceivers;
import mcjty.rftoolsutility.network.RFToolsUtilityMessages;
import mcjty.rftoolsutility.setup.CommandHandler;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.dimension.DimensionType;

public class GuiTeleportProbe
extends Screen {
    private int xSize = 356;
    private int ySize = 180;
    private Window window;
    private WidgetList list;
    private static List<TeleportDestinationClientInfo> serverDestinationList = null;
    private static List<TeleportDestinationClientInfo> destinationList = null;
    private int listDirty = 0;

    public GuiTeleportProbe() {
        super((ITextComponent)new StringTextComponent("Teleport Probe"));
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void init() {
        super.init();
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        this.list = ((WidgetList)new WidgetList(this.minecraft, (Screen)this).setName("list")).addSelectionEvent((SelectionEvent)new DefaultSelectionEvent(){

            public void doubleClick(Widget<?> parent, int index) {
                GuiTeleportProbe.this.teleport(index);
            }
        });
        Slider listSlider = ((Slider)new Slider(this.minecraft, (Screen)this).setDesiredWidth(11)).setVertical().setScrollableName("list");
        Panel toplevel = (Panel)((Panel)((Panel)new Panel(this.minecraft, (Screen)this).setFilledRectThickness(2)).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setSpacing(1)).setHorizontalMargin(3)).addChild((Widget)this.list)).addChild((Widget)listSlider);
        toplevel.setBounds(new Rectangle(k, l, this.xSize, this.ySize));
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
        serverDestinationList = null;
        destinationList = null;
        this.requestReceiversFromServer();
    }

    private void teleport(int index) {
        TeleportDestinationClientInfo destination = destinationList.get(index);
        BlockPos c = destination.getCoordinate();
        RFToolsUtilityMessages.sendToServer("forceTeleport", TypedMap.builder().put(CommandHandler.PARAM_DIMENSION, (Object)destination.getDimension().getRegistryName().toString()).put(CommandHandler.PARAM_POS, (Object)c));
    }

    public static void setReceivers(List<TeleportDestinationClientInfo> destinationList) {
        serverDestinationList = new ArrayList<TeleportDestinationClientInfo>(destinationList);
    }

    private void requestReceiversFromServer() {
        RFToolsUtilityMessages.INSTANCE.sendToServer((Object)new PacketGetAllReceivers());
    }

    private void populateList() {
        if (serverDestinationList == null) {
            return;
        }
        if (serverDestinationList.equals(destinationList)) {
            return;
        }
        destinationList = new ArrayList<TeleportDestinationClientInfo>(serverDestinationList);
        this.list.removeChildren();
        for (TeleportDestinationClientInfo destination : destinationList) {
            BlockPos coordinate = destination.getCoordinate();
            DimensionType dim = destination.getDimension();
            Panel panel = new Panel(this.minecraft, (Screen)this).setLayout((Layout)new HorizontalLayout());
            panel.addChild((Widget)((Label)((Label)((Label)new Label(this.minecraft, (Screen)this).setColor(StyleConfig.colorTextInListNormal)).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).setText(destination.getName())).setDesiredWidth(100));
            panel.addChild((Widget)((Label)((Label)((Label)new Label(this.minecraft, (Screen)this).setColor(StyleConfig.colorTextInListNormal)).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).setText(BlockPosTools.toString((BlockPos)coordinate))).setDesiredWidth(75));
            panel.addChild((Widget)((Label)((Label)((Label)new Label(this.minecraft, (Screen)this).setColor(StyleConfig.colorTextInListNormal)).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).setText("Id " + dim)).setDesiredWidth(75));
            this.list.addChild((Widget)panel);
        }
    }

    public void render(int xSize_lo, int ySize_lo, float par3) {
        super.render(xSize_lo, ySize_lo, par3);
        --this.listDirty;
        if (this.listDirty <= 0) {
            this.populateList();
            this.listDirty = 10;
        }
        this.window.draw();
        List tooltips = this.window.getTooltips();
        if (tooltips != null) {
            int guiLeft = (this.width - this.xSize) / 2;
            int guiTop = (this.height - this.ySize) / 2;
            double mouseX = this.minecraft.field_71417_B.func_198024_e();
            double mouseY = this.minecraft.field_71417_B.func_198026_f();
            int x = (int)(mouseX * (double)this.width / (double)this.minecraft.field_195558_d.func_198105_m());
            int y = (int)((double)this.height - mouseY * (double)this.height / (double)this.minecraft.field_195558_d.func_198083_n() - 1.0);
            this.renderTooltip(tooltips, x - guiLeft, y - guiTop, this.minecraft.field_71466_p);
        }
    }
}

