/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.crafter.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsutility.craftinggrid.CraftingRecipe;
import mcjty.rftoolsutility.modules.crafter.blocks.CrafterBaseTE;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSelectRecipe {
    private BlockPos pos;
    private int recipeIndex;
    private ItemStack[] items;
    private boolean keepOne;
    private CraftingRecipe.CraftMode craftInternal;

    public void toBytes(PacketBuffer buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        buf.writeBoolean(this.keepOne);
        buf.writeByte(this.craftInternal.ordinal());
        buf.writeByte(this.recipeIndex);
        if (this.items != null) {
            buf.writeByte(this.items.length);
            for (ItemStack item : this.items) {
                if (item.func_190926_b()) {
                    buf.writeBoolean(false);
                    continue;
                }
                buf.writeBoolean(true);
                NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)item);
            }
        } else {
            buf.writeByte(0);
        }
    }

    public PacketSelectRecipe() {
    }

    public PacketSelectRecipe(BlockPos pos, int recipeIndex, CraftingInventory inv, ItemStack result, boolean keepOne, CraftingRecipe.CraftMode craftInternal) {
        this.pos = pos;
        this.recipeIndex = recipeIndex;
        this.items = new ItemStack[10];
        if (inv != null) {
            for (int i = 0; i < 9; ++i) {
                ItemStack slot = inv.func_70301_a(i);
                this.items[i] = !slot.func_190926_b() ? slot.func_77946_l() : ItemStack.field_190927_a;
            }
        }
        this.items[9] = result.func_190926_b() ? ItemStack.field_190927_a : result.func_77946_l();
        this.keepOne = keepOne;
        this.craftInternal = craftInternal;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            TileEntity te = ctx.getSender().func_130014_f_().func_175625_s(this.pos);
            if (!(te instanceof CrafterBaseTE)) {
                Logging.logError((String)"Wrong type of tile entity (expected CrafterBaseTE)!");
                return;
            }
            CrafterBaseTE crafterBlockTileEntity = (CrafterBaseTE)te;
            if (this.recipeIndex != -1) {
                CraftingRecipe recipe = crafterBlockTileEntity.getRecipe(this.recipeIndex);
                recipe.setRecipe(this.items, this.items[9]);
                recipe.setKeepOne(this.keepOne);
                recipe.setCraftMode(this.craftInternal);
                crafterBlockTileEntity.markDirtyClient();
            }
        });
        ctx.setPacketHandled(true);
    }
}

