/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.craftinggrid;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mcjty.lib.varia.CapabilityTools;
import mcjty.rftoolsutility.craftinggrid.IItemKey;
import mcjty.rftoolsutility.craftinggrid.IItemSource;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityItemSource
implements IItemSource {
    private List<Pair<IItemHandler, Integer>> inventories = new ArrayList<Pair<IItemHandler, Integer>>();

    public TileEntityItemSource add(TileEntity te, int offset) {
        CapabilityTools.getItemCapabilitySafe((TileEntity)te).ifPresent(h -> this.inventories.add((Pair<IItemHandler, Integer>)Pair.of((Object)h, (Object)offset)));
        return this;
    }

    private static ItemStack getStackInSlot(Object inv, int slot) {
        if (inv instanceof IItemHandler) {
            return ((IItemHandler)inv).getStackInSlot(slot);
        }
        return ItemStack.field_190927_a;
    }

    private static boolean insertStackInSlot(Object inv, int slot, ItemStack stack) {
        if (inv instanceof IItemHandler) {
            IItemHandler handler = (IItemHandler)inv;
            if (!handler.insertItem(slot, stack, true).func_190926_b()) {
                return false;
            }
            return handler.insertItem(slot, stack, false).func_190926_b();
        }
        if (inv instanceof IInventory) {
            IInventory inventory = (IInventory)inv;
            ItemStack oldStack = inventory.func_70301_a(slot);
            if (!oldStack.func_190926_b()) {
                if (stack.func_190916_E() + oldStack.func_190916_E() > stack.func_77976_d()) {
                    return false;
                }
                stack.func_190917_f(oldStack.func_190916_E());
            }
            inventory.func_70299_a(slot, stack);
            return true;
        }
        return false;
    }

    private static int insertStackInAnySlot(Object inv, ItemStack stack) {
        if (inv instanceof IItemHandler) {
            IItemHandler handler = (IItemHandler)inv;
            ItemStack leftOver = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false);
            return leftOver.func_190916_E();
        }
        return stack.func_190916_E();
    }

    private static int getSizeInventory(Object inv) {
        if (inv instanceof IItemHandler) {
            return ((IItemHandler)inv).getSlots();
        }
        if (inv instanceof IInventory) {
            return ((IInventory)inv).func_70302_i_();
        }
        return 0;
    }

    @Override
    public Iterable<Pair<IItemKey, ItemStack>> getItems() {
        return () -> new Iterator<Pair<IItemKey, ItemStack>>(){
            private int inventoryIndex = 0;
            private int slotIndex = 0;

            private boolean firstValidItem() {
                while (this.inventoryIndex < TileEntityItemSource.this.inventories.size()) {
                    Object inventory = ((Pair)TileEntityItemSource.this.inventories.get(this.inventoryIndex)).getLeft();
                    if (this.slotIndex < TileEntityItemSource.getSizeInventory(inventory)) {
                        return true;
                    }
                    this.slotIndex = 0;
                    ++this.inventoryIndex;
                }
                return false;
            }

            @Override
            public boolean hasNext() {
                return this.firstValidItem();
            }

            @Override
            public Pair<IItemKey, ItemStack> next() {
                IItemHandler te = (IItemHandler)((Pair)TileEntityItemSource.this.inventories.get(this.inventoryIndex)).getLeft();
                ItemKey key = new ItemKey(te, this.slotIndex);
                Pair result = Pair.of((Object)key, (Object)TileEntityItemSource.getStackInSlot(te, this.slotIndex));
                ++this.slotIndex;
                return result;
            }
        };
    }

    @Override
    public ItemStack decrStackSize(IItemKey key, int amount) {
        ItemKey realKey = (ItemKey)key;
        IItemHandler te = realKey.getInventory();
        if (te != null) {
            return te.extractItem(realKey.getSlot(), amount, false);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean insertStack(IItemKey key, ItemStack stack) {
        ItemKey realKey = (ItemKey)key;
        return TileEntityItemSource.insertStackInSlot(realKey.getInventory(), realKey.getSlot(), stack);
    }

    @Override
    public int insertStackAnySlot(IItemKey key, ItemStack stack) {
        ItemKey realKey = (ItemKey)key;
        return TileEntityItemSource.insertStackInAnySlot(realKey.getInventory(), stack);
    }

    private static class ItemKey
    implements IItemKey {
        private IItemHandler inventory;
        private int slot;

        public ItemKey(IItemHandler inventory, int slot) {
            this.inventory = inventory;
            this.slot = slot;
        }

        public IItemHandler getInventory() {
            return this.inventory;
        }

        public int getSlot() {
            return this.slot;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ItemKey itemKey = (ItemKey)o;
            if (this.slot != itemKey.slot) {
                return false;
            }
            return this.inventory.equals(itemKey.inventory);
        }

        public int hashCode() {
            int result = this.inventory.hashCode();
            result = 31 * result + this.slot;
            return result;
        }
    }
}

