/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.util;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public class AnnotationUtil {
    public static List<Class> getAnnotatedClasses(Class<? extends Annotation> annotation) {
        ArrayList<Class> classList = new ArrayList<Class>();
        Type type = Type.getType(annotation);
        for (ModFileScanData allScanDatum : ModList.get().getAllScanData()) {
            for (ModFileScanData.AnnotationData allScanDatumAnnotation : allScanDatum.getAnnotations()) {
                if (!Objects.equals(allScanDatumAnnotation.getAnnotationType(), type)) continue;
                try {
                    classList.add(Class.forName(allScanDatumAnnotation.getMemberName()));
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        return classList;
    }

    public static List<Class> getFilteredAnnotatedClasses(Class<? extends Annotation> annotation, String filter) {
        ArrayList<Class> classList = new ArrayList<Class>();
        Type type = Type.getType(annotation);
        for (ModFileScanData allScanDatum : ModList.get().getAllScanData()) {
            if (allScanDatum.getTargets().get(filter) == null) continue;
            for (ModFileScanData.AnnotationData allScanDatumAnnotation : allScanDatum.getAnnotations()) {
                if (!Objects.equals(allScanDatumAnnotation.getAnnotationType(), type)) continue;
                try {
                    classList.add(Class.forName(allScanDatumAnnotation.getMemberName()));
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        return classList;
    }
}

