/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.reward.storage;

import com.hrznstudio.titanium.reward.storage.EnabledRewards;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;

public class RewardWorldStorage
extends WorldSavedData {
    public static String NAME = "TitaniumReward";
    private HashMap<UUID, EnabledRewards> rewards = new HashMap();
    private List<ResourceLocation> freeRewards = new ArrayList<ResourceLocation>();
    private List<UUID> configuredPlayers = new ArrayList<UUID>();

    private RewardWorldStorage(String p_i2141_1_) {
        super(NAME);
    }

    public RewardWorldStorage() {
        this(NAME);
    }

    public static RewardWorldStorage get(ServerWorld world) {
        return (RewardWorldStorage)world.func_217481_x().func_215752_a(RewardWorldStorage::new, NAME);
    }

    public void remove(UUID uuid, ResourceLocation resourceLocation) {
        this.rewards.computeIfAbsent(uuid, uuid1 -> new EnabledRewards()).getEnabled().remove(resourceLocation);
    }

    public void add(UUID uuid, ResourceLocation resourceLocation, String option) {
        this.rewards.computeIfAbsent(uuid, uuid1 -> new EnabledRewards()).getEnabled().put(resourceLocation, option);
    }

    public void addFree(ResourceLocation resourceLocation) {
        this.freeRewards.add(resourceLocation);
    }

    public List<ResourceLocation> getFreeRewards() {
        return this.freeRewards;
    }

    public List<UUID> getConfiguredPlayers() {
        return this.configuredPlayers;
    }

    public void func_76184_a(CompoundNBT nbt) {
        CompoundNBT compoundNBT = nbt.func_74775_l(NAME);
        this.rewards.clear();
        compoundNBT.func_150296_c().forEach(s -> {
            EnabledRewards rewards = new EnabledRewards();
            rewards.deserializeNBT(compoundNBT.func_74775_l(s));
            this.rewards.put(UUID.fromString(s), rewards);
        });
        this.freeRewards.clear();
        CompoundNBT free = nbt.func_74775_l("FreeRewards");
        free.func_150296_c().forEach(s -> this.freeRewards.add(new ResourceLocation(s)));
        this.configuredPlayers.clear();
        CompoundNBT configured = nbt.func_74775_l("ConfiguredPlayers");
        configured.func_150296_c().forEach(s -> this.configuredPlayers.add(UUID.fromString(s)));
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        CompoundNBT compoundNBT = new CompoundNBT();
        this.rewards.forEach((uuid, enabledRewards) -> compoundNBT.func_218657_a(uuid.toString(), (INBT)enabledRewards.serializeNBT()));
        compound.func_218657_a(NAME, (INBT)compoundNBT);
        CompoundNBT free = new CompoundNBT();
        this.freeRewards.forEach(resourceLocation -> free.func_74757_a(resourceLocation.toString(), true));
        compound.func_218657_a("FreeRewards", (INBT)free);
        CompoundNBT configured = new CompoundNBT();
        this.configuredPlayers.forEach(uuid -> configured.func_74757_a(uuid.toString(), true));
        compound.func_218657_a("ConfiguredPlayers", (INBT)configured);
        return compound;
    }

    public CompoundNBT serializeSimple() {
        CompoundNBT compoundNBT = new CompoundNBT();
        this.rewards.forEach((uuid, enabledRewards) -> compoundNBT.func_218657_a(uuid.toString(), (INBT)enabledRewards.serializeNBT()));
        return compoundNBT;
    }
}

