/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.recipe.generator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium.recipe.generator.IJSONGenerator;
import com.hrznstudio.titanium.recipe.generator.IJsonFile;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class JsonDataGenerator {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final File DATA_DIR;
    private boolean dev;
    private List<IJsonFile> recipes = new ArrayList<IJsonFile>();
    private List<String> usedNames;
    private boolean alreadyGenerating;

    public JsonDataGenerator(DataTypes type, String modid) {
        this.dev = new File("../src/main/resources/").exists();
        this.DATA_DIR = new File("../src/main/resources/data/" + modid + "/" + type.getFolderName());
        this.usedNames = new ArrayList<String>();
        if (this.dev && !this.DATA_DIR.exists()) {
            this.DATA_DIR.mkdirs();
        }
        this.alreadyGenerating = false;
    }

    public JsonDataGenerator addRecipe(IJsonFile recipe) {
        if (this.alreadyGenerating) {
            Titanium.LOGGER.warn("Tried to add " + recipe.getRecipeKey() + " too late! This file won't be generated");
        } else {
            this.recipes.add(recipe);
        }
        return this;
    }

    public void generate() {
        if (this.dev) {
            this.alreadyGenerating = true;
            for (IJsonFile recipe : new ArrayList<IJsonFile>(this.recipes)) {
                try {
                    File folder = this.DATA_DIR;
                    if (recipe.getRecipeSubfolder() != null && !(folder = new File(this.DATA_DIR, recipe.getRecipeSubfolder())).exists()) {
                        folder.mkdirs();
                    }
                    FileWriter writer = new FileWriter(new File(folder, this.getUniqueName(recipe.getRecipeKey()) + ".json"));
                    GSON.toJson(recipe instanceof IJSONGenerator ? ((IJSONGenerator)((Object)recipe)).generate() : recipe, (Appendable)writer);
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String getUniqueName(String name) {
        if (this.usedNames.contains(name)) {
            return this.getUniqueName(name + "_alt");
        }
        this.usedNames.add(name);
        return name;
    }

    public static enum DataTypes {
        ADVANCEMENT("advancements"),
        LOOT_BLOCKS("loot_tables/blocks"),
        LOOT_CHESTS("loot_tables/chests"),
        LOOT_ENTITIES("loot_tables/entities"),
        LOOT_GAMEPLAY("loot_tables/gameplay"),
        RECIPE("recipes"),
        TAG("tags");

        private final String folderName;

        private DataTypes(String folderName) {
            this.folderName = folderName;
        }

        public String getFolderName() {
            return this.folderName;
        }
    }
}

