/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.item;

import com.hrznstudio.titanium.energy.EnergyStorageItemStack;
import com.hrznstudio.titanium.item.ItemBase;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ItemEnergy
extends ItemBase {
    private final int capacity;
    private final int input;
    private final int output;

    public ItemEnergy(String name, int capacity, int input, int output, Item.Properties properties) {
        super(name, properties.func_200917_a(1));
        this.capacity = capacity;
        this.input = input;
        this.output = output;
    }

    public ItemEnergy(String name, Item.Properties properties, int capacity, int throughput) {
        this(name, capacity, throughput, throughput, properties);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getInput() {
        return this.input;
    }

    public int getOutput() {
        return this.output;
    }

    @Override
    public boolean hasTooltipDetails(@Nullable ItemBase.Key key) {
        return key == ItemBase.Key.SHIFT || super.hasTooltipDetails(key);
    }

    @Override
    public void addTooltipDetails(@Nullable ItemBase.Key key, ItemStack stack, List<ITextComponent> tooltip, boolean advanced) {
        super.addTooltipDetails(key, stack, tooltip, advanced);
        if (key == ItemBase.Key.SHIFT) {
            // empty if block
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergyStorage(stack).isPresent();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (Double)this.getEnergyStorage(stack).map(storage -> 1.0 - (double)storage.getEnergyStored() / (double)storage.getMaxEnergyStored()).orElse((Object)0.0);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 15282738;
    }

    public LazyOptional<IEnergyStorage> getEnergyStorage(ItemStack stack) {
        return stack.getCapability(CapabilityEnergy.ENERGY, null);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapabilityProvider(new EnergyStorageItemStack(stack, this.capacity, this.input, this.output));
    }

    public static class CapabilityProvider
    implements ICapabilityProvider {
        private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> energy);

        public CapabilityProvider(EnergyStorageItemStack energy) {
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityEnergy.ENERGY) {
                return this.energyCap.cast();
            }
            return LazyOptional.empty();
        }
    }
}

