/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.energy;

import com.hrznstudio.titanium.block.tile.TileBase;
import net.minecraft.nbt.IntNBT;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.EnergyStorage;

public class NBTEnergyHandler
extends EnergyStorage
implements INBTSerializable<IntNBT> {
    private TileBase base;

    public NBTEnergyHandler(TileBase base, int capacity) {
        super(capacity);
        this.base = base;
    }

    public NBTEnergyHandler(TileBase base, int capacity, int maxTransfer) {
        super(capacity, maxTransfer);
        this.base = base;
    }

    public NBTEnergyHandler(TileBase base, int capacity, int maxReceive, int maxExtract) {
        super(capacity, maxReceive, maxExtract);
        this.base = base;
    }

    public NBTEnergyHandler(TileBase base, int capacity, int maxReceive, int maxExtract, int energy) {
        super(capacity, maxReceive, maxExtract, energy);
        this.base = base;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energy = super.receiveEnergy(maxReceive, simulate);
        if (energy != 0 && !simulate) {
            this.base.markForUpdate();
        }
        return energy;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int energy = super.extractEnergy(maxExtract, simulate);
        if (energy != 0 && !simulate) {
            this.base.markForUpdate();
        }
        return energy;
    }

    public void receiveEnergyForced(int maxReceive) {
        this.energy = Math.min(this.capacity, this.energy + maxReceive);
        this.base.markForUpdate();
    }

    public void extractEnergyForced(int maxExtract) {
        this.energy = Math.max(0, this.energy - maxExtract);
        this.base.markForUpdate();
    }

    public IntNBT serializeNBT() {
        return new IntNBT(this.getEnergyStored());
    }

    public void deserializeNBT(IntNBT nbt) {
        this.energy = nbt.func_150287_d();
    }
}

