/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.gui.container;

import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IGuiAddon;
import com.hrznstudio.titanium.api.client.assets.types.IBackgroundAsset;
import com.hrznstudio.titanium.client.gui.IGuiAddonConsumer;
import com.hrznstudio.titanium.client.gui.addon.AssetGuiAddon;
import com.hrznstudio.titanium.client.gui.addon.interfaces.ICanMouseDrag;
import com.hrznstudio.titanium.client.gui.addon.interfaces.IClickable;
import com.hrznstudio.titanium.client.gui.asset.IAssetProvider;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.glfw.GLFW;

public class GuiContainerBase<T extends Container>
extends ContainerScreen<T>
implements IGuiAddonConsumer {
    private final T container;
    private final ITextComponent title;
    private IAssetProvider assetProvider;
    private int xCenter;
    private int yCenter;
    private List<IGuiAddon> addons;
    private int dragX;
    private int dragY;

    public GuiContainerBase(T container, PlayerInventory inventory, ITextComponent title) {
        super(container, inventory, title);
        this.container = container;
        this.title = title;
        this.assetProvider = IAssetProvider.DEFAULT_PROVIDER;
        IBackgroundAsset background = IAssetProvider.getAsset(this.assetProvider, AssetTypes.BACKGROUND);
        this.field_146999_f = background.getArea().width;
        this.field_147000_g = background.getArea().height;
        this.addons = new ArrayList<IGuiAddon>();
    }

    public GuiContainerBase(T container, PlayerInventory inventory, ITextComponent title, IAssetProvider provider) {
        super(container, inventory, title);
        this.container = container;
        this.title = title;
        this.assetProvider = provider;
        IBackgroundAsset background = IAssetProvider.getAsset(this.assetProvider, AssetTypes.BACKGROUND);
        this.field_146999_f = background.getArea().width;
        this.field_147000_g = background.getArea().height;
        this.addons = new ArrayList<IGuiAddon>();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.renderBackground();
        this.xCenter = (this.width - this.field_146999_f) / 2;
        this.yCenter = (this.height - this.field_147000_g) / 2;
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(IAssetProvider.getAsset(this.assetProvider, AssetTypes.BACKGROUND).getResourceLocation());
        this.blit(this.xCenter, this.yCenter, 0, 0, this.field_146999_f, this.field_147000_g);
        String name = TextFormatting.GRAY + this.title.func_150254_d();
        Minecraft.func_71410_x().field_71466_p.func_211126_b(name, (float)(this.xCenter + this.field_146999_f / 2 - Minecraft.func_71410_x().field_71466_p.func_78256_a(name) / 2), (float)(this.yCenter + 6), 0xFFFFFF);
        this.checkForMouseDrag(mouseX, mouseY);
        this.addons.forEach(iGuiAddon -> {
            if (iGuiAddon instanceof AssetGuiAddon) {
                AssetGuiAddon assetGuiAddon = (AssetGuiAddon)iGuiAddon;
                if (assetGuiAddon.isBackground()) {
                    iGuiAddon.drawGuiContainerBackgroundLayer((Screen)this, this.assetProvider, this.xCenter, this.yCenter, mouseX, mouseY, partialTicks);
                }
            } else {
                iGuiAddon.drawGuiContainerBackgroundLayer((Screen)this, this.assetProvider, this.xCenter, this.yCenter, mouseX, mouseY, partialTicks);
            }
        });
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.addons.forEach(iGuiAddon -> {
            if (iGuiAddon instanceof AssetGuiAddon) {
                AssetGuiAddon assetGuiAddon = (AssetGuiAddon)iGuiAddon;
                if (assetGuiAddon.isBackground()) {
                    iGuiAddon.drawGuiContainerForegroundLayer((Screen)this, this.assetProvider, this.xCenter, this.yCenter, mouseX, mouseY);
                }
            } else {
                iGuiAddon.drawGuiContainerForegroundLayer((Screen)this, this.assetProvider, this.xCenter, this.yCenter, mouseX, mouseY);
            }
        });
        this.func_191948_b(mouseX - this.xCenter, mouseY - this.yCenter);
        for (IGuiAddon iGuiAddon2 : this.addons) {
            if (!iGuiAddon2.isInside((Screen)this, mouseX - this.xCenter, mouseY - this.yCenter) || iGuiAddon2.getTooltipLines().isEmpty()) continue;
            this.renderTooltip(iGuiAddon2.getTooltipLines(), mouseX - this.xCenter, mouseY - this.yCenter);
        }
    }

    private void checkForMouseDrag(int mouseX, int mouseY) {
        if (GLFW.glfwGetMouseButton((long)Minecraft.func_71410_x().field_195558_d.func_198092_i(), (int)0) == 1) {
            for (IGuiAddon iGuiAddon : this.addons) {
                if (!(iGuiAddon instanceof ICanMouseDrag)) continue;
                ((ICanMouseDrag)((Object)iGuiAddon)).drag(mouseX - this.dragX, mouseY - this.dragY);
            }
        }
        this.dragX = mouseX;
        this.dragY = mouseY;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        new ArrayList<IGuiAddon>(this.addons).stream().filter(iGuiAddon -> iGuiAddon instanceof IClickable && iGuiAddon.isInside((Screen)this, mouseX - (double)this.xCenter, mouseY - (double)this.yCenter)).forEach(iGuiAddon -> ((IClickable)((Object)iGuiAddon)).handleClick((Screen)this, this.xCenter, this.yCenter, mouseX, mouseY, mouseButton));
        return false;
    }

    public int getX() {
        return this.xCenter;
    }

    public int getY() {
        return this.yCenter;
    }

    public T func_212873_a_() {
        return this.container;
    }

    public List<IGuiAddon> getAddons() {
        return this.addons;
    }

    public void setAddons(List<IGuiAddon> addons) {
        this.addons = addons;
    }

    public IAssetProvider getAssetProvider() {
        return this.assetProvider;
    }

    public void setAssetProvider(IAssetProvider assetProvider) {
        this.assetProvider = assetProvider;
    }
}

