/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.gui;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IGuiAddon;
import com.hrznstudio.titanium.api.client.assets.types.IBackgroundAsset;
import com.hrznstudio.titanium.client.gui.IGuiAddonConsumer;
import com.hrznstudio.titanium.client.gui.addon.interfaces.ICanMouseDrag;
import com.hrznstudio.titanium.client.gui.addon.interfaces.IClickable;
import com.hrznstudio.titanium.client.gui.asset.IAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.lwjgl.glfw.GLFW;

public abstract class GuiAddonScreen
extends Screen
implements IGuiAddonConsumer {
    public int x;
    public int y;
    private IAssetProvider assetProvider;
    private List<IGuiAddon> addonList;
    private boolean drawBackground;
    private boolean isMouseDragging;
    private int dragX;
    private int dragY;

    public GuiAddonScreen(IAssetProvider assetProvider, boolean drawBackground) {
        super((ITextComponent)new StringTextComponent(""));
        this.assetProvider = assetProvider;
        this.drawBackground = drawBackground;
    }

    public void init() {
        super.init();
        IBackgroundAsset background = IAssetProvider.getAsset(this.assetProvider, AssetTypes.BACKGROUND);
        this.x = this.width / 2 - background.getArea().width / 2;
        this.y = this.height / 2 - background.getArea().height / 2;
        this.addonList = this.guiAddons().stream().map(IFactory::create).collect(Collectors.toList());
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.pushMatrix();
        this.renderBackground(mouseX, mouseY, partialTicks);
        GlStateManager.popMatrix();
        super.render(mouseX, mouseY, partialTicks);
        GlStateManager.pushMatrix();
        this.renderForeground(mouseX, mouseY, partialTicks);
        GlStateManager.popMatrix();
    }

    public void renderBackground(int mouseX, int mouseY, float partialTicks) {
        this.checkForMouseDrag(mouseX, mouseY);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.drawBackground) {
            this.renderBackground();
            AssetUtil.drawAsset(this, this.assetProvider.getAsset(AssetTypes.BACKGROUND), this.x, this.y);
        }
        this.addonList.forEach(iGuiAddon -> iGuiAddon.drawGuiContainerBackgroundLayer(this, this.assetProvider, this.x, this.y, mouseX, mouseY, partialTicks));
    }

    public void renderForeground(int mouseX, int mouseY, float partialTicks) {
        this.addonList.forEach(iGuiAddon -> iGuiAddon.drawGuiContainerForegroundLayer(this, this.assetProvider, this.x, this.y, mouseX, mouseY));
        for (IGuiAddon iGuiAddon2 : this.addonList) {
            if (!iGuiAddon2.isInside(this, mouseX - this.x, mouseY - this.y) || iGuiAddon2.getTooltipLines().isEmpty()) continue;
            this.renderTooltip(iGuiAddon2.getTooltipLines(), mouseX, mouseY);
        }
    }

    public abstract List<IFactory<IGuiAddon>> guiAddons();

    private void checkForMouseDrag(int mouseX, int mouseY) {
        if (GLFW.glfwGetMouseButton((long)Minecraft.func_71410_x().field_195558_d.func_198092_i(), (int)0) == 1) {
            if (!this.isMouseDragging) {
                this.isMouseDragging = true;
            } else {
                for (IGuiAddon iGuiAddon : this.addonList) {
                    if (!(iGuiAddon instanceof ICanMouseDrag) || !iGuiAddon.isInside(null, mouseX - this.x, mouseY - this.y)) continue;
                    ((ICanMouseDrag)((Object)iGuiAddon)).drag(mouseX - this.dragX, mouseY - this.dragY);
                }
            }
            this.dragX = mouseX;
            this.dragY = mouseY;
        } else {
            this.isMouseDragging = false;
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        new ArrayList<IGuiAddon>(this.addonList).stream().filter(iGuiAddon -> iGuiAddon instanceof IClickable && iGuiAddon.isInside(this, mouseX - (double)this.x, mouseY - (double)this.y)).forEach(iGuiAddon -> ((IClickable)((Object)iGuiAddon)).handleClick(this, this.x, this.y, mouseX, mouseY, mouseButton));
        return false;
    }

    public List<IGuiAddon> getAddons() {
        return this.addonList;
    }
}

