/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

@ParametersAreNonnullByDefault
public class TitaniumModelLoader
implements ICustomModelLoader {
    private final Map<ResourceLocation, IUnbakedModel> MODEL_MAP = new HashMap<ResourceLocation, IUnbakedModel>();

    public boolean accepts(ResourceLocation modelLocation) {
        return this.MODEL_MAP.containsKey(modelLocation);
    }

    @Nonnull
    public IUnbakedModel loadModel(ResourceLocation modelLocation) {
        return this.MODEL_MAP.get(modelLocation);
    }

    public void func_195410_a(IResourceManager resourceManager) {
        this.MODEL_MAP.clear();
        MinecraftForge.EVENT_BUS.post((Event)new TitaniumModelEvent(this));
    }

    public static class TitaniumModelEvent
    extends Event {
        private final TitaniumModelLoader loader;

        public TitaniumModelEvent(TitaniumModelLoader loader) {
            this.loader = loader;
        }

        public void register(ResourceLocation resourceLocation, IUnbakedModel model) {
            this.loader.MODEL_MAP.put(resourceLocation, model);
        }

        public void register(String location, IUnbakedModel model) {
            this.register(new ResourceLocation(location), model);
        }

        public void register(String domain, String location, IUnbakedModel model) {
            this.register(new ResourceLocation(domain, location), model);
        }
    }
}

