/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block.tile.sideness;

import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.api.client.IAssetType;
import com.hrznstudio.titanium.client.gui.addon.StateButtonInfo;
import com.hrznstudio.titanium.util.FacingUtil;
import java.awt.Rectangle;
import java.util.HashMap;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public interface IFacingHandler {
    public HashMap<FacingUtil.Sideness, FaceMode> getFacingModes();

    public int getColor();

    public Rectangle getRectangle(IAsset var1);

    public String getName();

    public int getFacingHandlerX();

    public int getFacingHandlerY();

    public boolean work(World var1, BlockPos var2, Direction var3, int var4);

    public IFacingHandler setFacingHandlerPos(int var1, int var2);

    public static enum FaceMode {
        NONE(false, 0, AssetTypes.BUTTON_SIDENESS_DISABLED, TextFormatting.RED),
        ENABLED(true, 1, AssetTypes.BUTTON_SIDENESS_ENABLED, TextFormatting.GREEN),
        PUSH(true, 2, AssetTypes.BUTTON_SIDENESS_PUSH, TextFormatting.YELLOW),
        PULL(true, 3, AssetTypes.BUTTON_SIDENESS_PULL, TextFormatting.BLUE);

        private final boolean allowsConnection;
        private final int index;
        private final IAssetType assetType;
        private final TextFormatting color;

        private FaceMode(boolean allowsConnection, int index, IAssetType assetType, TextFormatting color) {
            this.allowsConnection = allowsConnection;
            this.index = index;
            this.assetType = assetType;
            this.color = color;
        }

        public boolean allowsConnection() {
            return this.allowsConnection;
        }

        public StateButtonInfo getInfo() {
            return new StateButtonInfo(this.index, this.assetType, this.name().toLowerCase());
        }

        public int getIndex() {
            return this.index;
        }

        public TextFormatting getColor() {
            return this.color;
        }
    }
}

