/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block.tile.inventory;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IGuiAddon;
import com.hrznstudio.titanium.api.client.IGuiAddonProvider;
import com.hrznstudio.titanium.client.gui.addon.SlotsGuiAddon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class PosInvHandler
extends ItemStackHandler
implements IGuiAddonProvider {
    private final String name;
    private int xPos;
    private int yPos;
    private int xSize;
    private int ySize;
    private TileEntity tileEntity;
    private BiPredicate<ItemStack, Integer> insertPredicate;
    private BiPredicate<ItemStack, Integer> extractPredicate;
    private BiConsumer<ItemStack, Integer> onSlotChanged;
    private HashMap<Integer, Integer> slotAmountFilter;
    private int slotLimit;
    private Function<Integer, Pair<Integer, Integer>> slotPosition;

    public PosInvHandler(String name, int xPos, int yPos, int size) {
        this.name = name;
        this.xPos = xPos;
        this.yPos = yPos;
        this.setSize(size);
        this.setRange(size, 1);
        this.insertPredicate = (stack, integer) -> true;
        this.extractPredicate = (stack, integer) -> true;
        this.onSlotChanged = (stack, integer) -> {};
        this.slotAmountFilter = new HashMap();
        this.slotLimit = 64;
        this.slotPosition = integer -> Pair.of((Object)(18 * (integer % this.xSize)), (Object)(18 * (integer % this.ySize)));
    }

    public PosInvHandler setRange(int x, int y) {
        this.xSize = x;
        this.ySize = y;
        return this;
    }

    public PosInvHandler setTile(TileEntity tile) {
        this.tileEntity = tile;
        return this;
    }

    public PosInvHandler setInputFilter(BiPredicate<ItemStack, Integer> predicate) {
        this.insertPredicate = predicate;
        return this;
    }

    public PosInvHandler setOutputFilter(BiPredicate<ItemStack, Integer> predicate) {
        this.extractPredicate = predicate;
        return this;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (!this.insertPredicate.test(stack, slot)) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return super.extractItem(slot, amount, simulate);
    }

    protected void onContentsChanged(int slot) {
        if (this.tileEntity != null) {
            this.tileEntity.func_70296_d();
        }
        this.onSlotChanged.accept(this.getStackInSlot(slot), slot);
    }

    public String getName() {
        return this.name;
    }

    public int getXPos() {
        return this.xPos;
    }

    public void setXPos(int xPos) {
        this.xPos = xPos;
    }

    public int getYPos() {
        return this.yPos;
    }

    public void setYPos(int yPos) {
        this.yPos = yPos;
    }

    public int getXSize() {
        return this.xSize;
    }

    public int getYSize() {
        return this.ySize;
    }

    public TileEntity getTileEntity() {
        return this.tileEntity;
    }

    public BiPredicate<ItemStack, Integer> getInsertPredicate() {
        return this.insertPredicate;
    }

    public BiPredicate<ItemStack, Integer> getExtractPredicate() {
        return this.extractPredicate;
    }

    public BiConsumer<ItemStack, Integer> getOnSlotChanged() {
        return this.onSlotChanged;
    }

    public PosInvHandler setOnSlotChanged(BiConsumer<ItemStack, Integer> onSlotChanged) {
        this.onSlotChanged = onSlotChanged;
        return this;
    }

    public PosInvHandler setSlotLimit(int slot, int limit) {
        this.slotAmountFilter.put(slot, limit);
        return this;
    }

    public PosInvHandler setSlotLimit(int limit) {
        this.slotLimit = limit;
        return this;
    }

    public int getSlotLimit(int slot) {
        return this.slotAmountFilter.getOrDefault(slot, this.slotLimit);
    }

    public Function<Integer, Pair<Integer, Integer>> getSlotPosition() {
        return this.slotPosition;
    }

    public PosInvHandler setSlotPosition(Function<Integer, Pair<Integer, Integer>> slotPosition) {
        this.slotPosition = slotPosition;
        return this;
    }

    @Override
    public List<IFactory<? extends IGuiAddon>> getGuiAddons() {
        ArrayList<IFactory<? extends IGuiAddon>> addons = new ArrayList<IFactory<? extends IGuiAddon>>();
        addons.add(() -> new SlotsGuiAddon(this));
        return addons;
    }
}

