/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.cooking.fuel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.plugins.vanilla.cooking.fuel.FuelRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraftforge.event.ForgeEventFactory;

public final class FuelRecipeMaker {
    private FuelRecipeMaker() {
    }

    public static List<FuelRecipe> getFuelRecipes(IIngredientManager ingredientManager, IJeiHelpers helpers) {
        IGuiHelper guiHelper = helpers.getGuiHelper();
        List<ItemStack> fuelStacks = ingredientManager.getFuels();
        ArrayList<FuelRecipe> fuelRecipes = new ArrayList<FuelRecipe>(fuelStacks.size());
        Map burnTimes = FurnaceTileEntity.func_214001_f();
        for (ItemStack fuelStack : fuelStacks) {
            int burnTime = FuelRecipeMaker.getItemBurnTime(fuelStack, burnTimes);
            fuelRecipes.add(new FuelRecipe(guiHelper, Collections.singleton(fuelStack), burnTime));
        }
        return fuelRecipes;
    }

    private static int getItemBurnTime(ItemStack stack, Map<Item, Integer> burnTimes) {
        if (stack.func_190926_b()) {
            return 0;
        }
        int ret = stack.getBurnTime();
        if (ret == -1) {
            Item item = stack.func_77973_b();
            ret = burnTimes.getOrDefault(item, 0);
        }
        return ForgeEventFactory.getItemBurnTime((ItemStack)stack, (int)ret);
    }
}

