/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.helpers;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.ItemStack;

public class FoodHelper {
    public static boolean isFood(ItemStack itemStack) {
        return itemStack.func_77973_b().func_219967_s() != null;
    }

    public static BasicFoodValues getDefaultFoodValues(ItemStack itemStack) {
        Food itemFood = itemStack.func_77973_b().func_219967_s();
        int hunger = itemFood != null ? itemFood.func_221466_a() : 0;
        float saturationModifier = itemFood != null ? itemFood.func_221469_b() : 0.0f;
        return new BasicFoodValues(hunger, saturationModifier);
    }

    public static BasicFoodValues getModifiedFoodValues(ItemStack itemStack, PlayerEntity player) {
        return FoodHelper.getDefaultFoodValues(itemStack);
    }

    public static class BasicFoodValues {
        public final int hunger;
        public final float saturationModifier;

        public BasicFoodValues(int hunger, float saturationModifier) {
            this.hunger = hunger;
            this.saturationModifier = saturationModifier;
        }

        public float getSaturationIncrement() {
            return (float)this.hunger * this.saturationModifier * 2.0f;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BasicFoodValues)) {
                return false;
            }
            BasicFoodValues that = (BasicFoodValues)o;
            return this.hunger == that.hunger && Float.compare(that.saturationModifier, this.saturationModifier) == 0;
        }

        public int hashCode() {
            int result = this.hunger;
            result = 31 * result + (this.saturationModifier != 0.0f ? Float.floatToIntBits(this.saturationModifier) : 0);
            return result;
        }
    }
}

